/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.codegeneration;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nullable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.codegeneration.IGeneratedClass;
import nl.pim16aap2.bigDoors.util.ConfigLoader;
import org.jetbrains.annotations.NotNull;

abstract class ClassGenerator {
    private boolean isGenerated = false;
    @NotNull
    private final String mappingsVersion;
    @NotNull
    private final ClassLoader classLoader = BigDoors.get().getBigDoorsClassLoader();
    @Nullable
    protected Class<?> generatedClass;
    @Nullable
    protected Constructor<?> generatedConstructor;

    protected ClassGenerator(@NotNull String mappingsVersion) {
        this.mappingsVersion = mappingsVersion;
    }

    protected final void generate() throws Exception {
        if (this.isGenerated) {
            if (this.generatedClass == null || this.generatedConstructor == null) {
                throw new IllegalStateException(this.getFormattedName() + " could not be generated");
            }
            return;
        }
        this.isGenerated = true;
        long startTime = System.nanoTime();
        this.generateImpl();
        long duration = System.nanoTime() - startTime;
        BigDoors.get().getMyLogger().info(String.format("Generated Class %s in %dms.", this.getGeneratedClass().getName(), duration / 1000000L));
    }

    protected abstract void generateImpl() throws Exception;

    @NotNull
    protected final DynamicType.Builder<?> createBuilder(@NotNull Class<?> superClass) {
        return new ByteBuddy().subclass(superClass, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).implement(new Type[]{IGeneratedClass.class}).name(this.getFormattedName());
    }

    @NotNull
    protected String getFormattedName() {
        return String.format("Generated_%s_%s", this.getBaseName(), this.mappingsVersion);
    }

    @NotNull
    protected abstract String getBaseName();

    @NotNull
    protected abstract Class<?>[] getConstructorArgumentTypes();

    protected final void finishBuilder(@NotNull DynamicType.Builder<?> builder) {
        DynamicType.Unloaded unloaded = builder.make();
        if (ConfigLoader.DEBUG) {
            this.saveGeneratedClass(unloaded, new File(BigDoors.get().getDataFolder(), "generated"));
        }
        this.generatedClass = unloaded.load(this.classLoader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
        try {
            this.generatedConstructor = this.generatedClass.getConstructor(this.getConstructorArgumentTypes());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to get constructor of generated class for mapping " + this.mappingsVersion + " for generator: " + this, e);
        }
        Objects.requireNonNull(this.generatedClass, "Failed to construct class with generator: " + this);
        Objects.requireNonNull(this.generatedConstructor, "Failed to find constructor with generator: " + this);
    }

    private void saveGeneratedClass(@NotNull DynamicType.Unloaded<?> unloaded, @NotNull File file) {
        try {
            unloaded.saveIn(file);
        }
        catch (IOException e) {
            BigDoors.get().getMyLogger().severe("Failed to save class " + this.getFormattedName() + " to file: " + file);
            e.printStackTrace();
        }
    }

    @NotNull
    public final Class<?> getGeneratedClass() {
        return Objects.requireNonNull(this.generatedClass, "Failed to find class generated by ClassGenerator " + this);
    }

    @NotNull
    public final Constructor<?> getGeneratedConstructor() {
        return Objects.requireNonNull(this.generatedConstructor, "Failed to find constructor generated by ClassGenerator " + this + " for class: " + this.getGeneratedClass());
    }
}

