/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import java.util.HashMap;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.milkbowl.vault.permission.Permission;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.compatibility.IPermissionsManager;
import nl.pim16aap2.bigDoors.lib.jcalculator.JCalculator;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public final class VaultManager
implements IPermissionsManager {
    Integer doorPrice;
    Integer drawbridgePrice;
    Integer portcullisPrice;
    Integer slidingDoorPrice;
    private static final double EPSILON = 1.0E-5;
    private final BigDoors plugin;
    private final HashMap<Long, Double> menu;
    private final boolean vaultEnabled;
    private Economy economy = null;
    private Permission perms = null;

    public VaultManager(BigDoors plugin) {
        this.plugin = plugin;
        this.menu = new HashMap();
        this.init();
        this.vaultEnabled = this.setupEconomy() && this.setupPermissions();
    }

    public void refundDoor(Door door) {
        if (!this.vaultEnabled || !this.plugin.getConfigLoader().refundOnDelete()) {
            return;
        }
        double price = this.getPrice(door.getType(), door.getBlockCount());
        this.economy.depositPlayer(Bukkit.getOfflinePlayer((UUID)door.getPrimeOwner()), door.getWorld().getName(), price);
    }

    public boolean buyDoor(Player player, DoorType type, int blockCount) {
        if (!this.vaultEnabled) {
            return true;
        }
        double price = this.getPrice(type, blockCount);
        if (price < 1.0E-5) {
            return true;
        }
        if (this.withdrawPlayer((OfflinePlayer)player, player.getWorld().getName(), price)) {
            if (price > 0.0) {
                Util.messagePlayer(player, this.plugin.getMessages().getString("CREATOR.GENERAL.MoneyWithdrawn") + " " + price);
            }
            return true;
        }
        Util.messagePlayer(player, this.plugin.getMessages().getString("CREATOR.GENERAL.InsufficientFunds") + " " + price);
        return false;
    }

    public void init() {
        this.menu.clear();
        try {
            this.doorPrice = Integer.parseInt(this.plugin.getConfigLoader().doorPrice());
        }
        catch (Exception e) {
            this.doorPrice = null;
        }
        try {
            this.drawbridgePrice = Integer.parseInt(this.plugin.getConfigLoader().drawbridgePrice());
        }
        catch (Exception e) {
            this.drawbridgePrice = null;
        }
        try {
            this.portcullisPrice = Integer.parseInt(this.plugin.getConfigLoader().portcullisPrice());
        }
        catch (Exception e) {
            this.portcullisPrice = null;
        }
        try {
            this.slidingDoorPrice = Integer.parseInt(this.plugin.getConfigLoader().slidingDoorPrice());
        }
        catch (Exception e) {
            this.slidingDoorPrice = null;
        }
    }

    @Override
    public boolean hasPermission(Player player, String permission) {
        return this.vaultEnabled && this.perms.playerHas(player.getWorld().getName(), (OfflinePlayer)player, permission);
    }

    public boolean hasPermission(OfflinePlayer player, String permission, String worldName) {
        return this.vaultEnabled && this.perms.playerHas(worldName, player, permission);
    }

    private double evaluateFormula(String formula, int blockCount) {
        try {
            return JCalculator.getResult(formula, new String[]{"blockCount"}, new double[]{blockCount});
        }
        catch (Exception e) {
            this.plugin.getMyLogger().logMessageToConsole("Failed to determine door creation price! Please contact pim16aap2! Include this: \"" + formula + "\"");
            e.printStackTrace();
            return 0.0;
        }
    }

    public double getPrice(DoorType type, int blockCount) {
        if (!this.vaultEnabled) {
            return 0.0;
        }
        long priceID = blockCount * 100 + DoorType.getValue(type);
        if (this.menu.containsKey(priceID)) {
            return this.menu.get(priceID);
        }
        double price = 0.0;
        switch (type) {
            case DOOR: {
                if (this.doorPrice != null) {
                    price = this.doorPrice.intValue();
                    break;
                }
                price = this.evaluateFormula(this.plugin.getConfigLoader().doorPrice(), blockCount);
                break;
            }
            case DRAWBRIDGE: {
                if (this.drawbridgePrice != null) {
                    price = this.drawbridgePrice.intValue();
                    break;
                }
                price = this.evaluateFormula(this.plugin.getConfigLoader().drawbridgePrice(), blockCount);
                break;
            }
            case PORTCULLIS: {
                if (this.portcullisPrice != null) {
                    price = this.portcullisPrice.intValue();
                    break;
                }
                price = this.evaluateFormula(this.plugin.getConfigLoader().portcullisPrice(), blockCount);
                break;
            }
            case SLIDINGDOOR: {
                price = this.slidingDoorPrice != null ? (double)this.slidingDoorPrice.intValue() : this.evaluateFormula(this.plugin.getConfigLoader().slidingDoorPrice(), blockCount);
            }
        }
        price = Math.max(0.0, price);
        this.menu.put(priceID, price);
        return price;
    }

    private boolean has(OfflinePlayer player, double amount) {
        if (amount < 1.0E-5) {
            return true;
        }
        try {
            return this.economy.has(player, amount);
        }
        catch (Exception e) {
            this.plugin.getMyLogger().warn("Failed to check balance of player \"" + player.getName() + "\" (" + player.getUniqueId() + ")! Please contact pim16aap2!");
            this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
            return true;
        }
    }

    private boolean withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        if (amount < 1.0E-5) {
            return true;
        }
        try {
            if (this.has(player, amount)) {
                return this.economy.withdrawPlayer((OfflinePlayer)player, (String)worldName, (double)amount).type.equals((Object)EconomyResponse.ResponseType.SUCCESS);
            }
            return false;
        }
        catch (Exception e) {
            this.plugin.getMyLogger().warn("Failed to subtract money from player \"" + player.getName() + "\" (" + player.getUniqueId() + ")! Please contact pim16aap2!");
            this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
            return true;
        }
    }

    private boolean setupEconomy() {
        try {
            if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
                return false;
            }
            RegisteredServiceProvider economyProvider = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (economyProvider != null) {
                this.economy = (Economy)economyProvider.getProvider();
            }
            return this.economy != null;
        }
        catch (Exception e) {
            this.plugin.getMyLogger().logMessage("Exception encountered while initiating Vault dependency! It will be disabled! Please contact pim16aap2!", true, false);
            this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
            return false;
        }
    }

    private boolean setupPermissions() {
        try {
            RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
            this.perms = (Permission)rsp.getProvider();
            return this.perms != null;
        }
        catch (Exception e) {
            this.plugin.getMyLogger().logMessage("Exception encountered while initiating Vault dependency! It will be disabled! Please contact pim16aap2!", true, false);
            this.plugin.getMyLogger().logMessageToLogFile(Util.throwableToString(e));
            return false;
        }
    }
}

