/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors.GUI;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.GUI.GUIItem;
import nl.pim16aap2.bigDoors.lib.xseries.XMaterial;
import nl.pim16aap2.bigDoors.util.DoorAttribute;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.DoorOwner;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.Messages;
import nl.pim16aap2.bigDoors.util.PageType;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class GUI {
    private static final Material PAGESWITCHMAT = Material.ARROW;
    private static final Material CURRDOORMAT = Material.BOOK;
    private static final Material CHANGETIMEMAT = XMaterial.CLOCK.parseMaterial();
    private static final Material NEWDOORMAT = XMaterial.WRITABLE_BOOK.parseMaterial();
    private static final Material LOCKDOORMAT = XMaterial.GREEN_STAINED_GLASS_PANE.parseMaterial();
    private static final Material UNLOCKDOORMAT = XMaterial.RED_STAINED_GLASS_PANE.parseMaterial();
    private static final Material CONFIRMMAT = XMaterial.RED_STAINED_GLASS_PANE.parseMaterial();
    private static final Material NOTCONFIRMMAT = XMaterial.GREEN_STAINED_GLASS_PANE.parseMaterial();
    private static final Material TOGGLEDOORMAT = Material.LEVER;
    private static final Material INFOMAT = Material.BOOKSHELF;
    private static final Material DELDOORMAT = Material.BARRIER;
    private static final Material RELOCATEPBMAT = Material.LEATHER_BOOTS;
    private static final Material SETOPENDIRMAT = Material.COMPASS;
    private static final Material SETBTMOVEMAT = XMaterial.STICKY_PISTON.parseMaterial();
    private static final Material ADDOWNERMAT = XMaterial.PLAYER_HEAD.parseMaterial();
    private static final Material REMOVEOWNERMAT = XMaterial.SKELETON_SKULL.parseMaterial();
    private static final Material NOTIFICATIONSMAT_ON = XMaterial.MUSIC_DISC_STAL.parseMaterial();
    private static final Material NOTIFICATIONSMAT_OFF = XMaterial.MUSIC_DISC_11.parseMaterial();
    private static final byte LOCKEDDATA = 14;
    private static final byte UNLOCKEDDATA = 5;
    private static final byte CONFIRMDATA = 14;
    private static final byte NOTCONFIRMDATA = 5;
    private static final byte PLAYERHEADDATA = 3;
    private static final byte SKULLDATA = 0;
    private static final int CHESTSIZE = 45;
    private static Material[] DOORTYPES = new Material[4];
    private static final Pattern newLines;
    private final BigDoors plugin;
    private final Messages messages;
    private final Player player;
    private int missingHeadTextures = 0;
    private PageType pageType;
    private int page;
    private final ArrayList<Door> doors;
    private ArrayList<DoorOwner> owners;
    private int doorOwnerPage = 0;
    private int maxDoorOwnerPageCount = 0;
    private boolean sortAlphabetically = false;
    private Inventory inventory = null;
    private final Map<Integer, GUIItem> items;
    private int maxPageCount;
    private Door door = null;

    public GUI(BigDoors plugin, Player player) {
        this.plugin = plugin;
        this.messages = plugin.getMessages();
        this.player = player;
        this.pageType = PageType.DOORLIST;
        this.page = 0;
        this.items = new HashMap<Integer, GUIItem>();
        this.doors = plugin.getCommander().getDoors(player.getUniqueId().toString(), null);
        this.sort();
        this.update();
    }

    private void addLore(ArrayList<String> lore, String toAdd) {
        lore.addAll(Arrays.asList(newLines.split(toAdd)));
    }

    private void update() {
        if (this.pageType != PageType.DOORLIST && this.pageType != PageType.DOORCREATION) {
            this.isStillOwner();
        }
        this.items.clear();
        this.maxPageCount = this.doors.size() / 36 + (this.doors.size() % 36 == 0 ? 0 : 1);
        this.refresh();
    }

    private void refresh() {
        if (this.pageType == PageType.CONFIRMATION || this.pageType == PageType.DOORINFO) {
            this.fillInfoHeader();
            if (this.pageType == PageType.CONFIRMATION) {
                this.fillConfirmationItems();
            } else {
                this.fillInformationItems();
            }
        } else if (this.pageType == PageType.DOORLIST || this.pageType == PageType.DOORCREATION) {
            this.fillDefaultHeader();
            this.fillDoors();
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this.player, (int)45, (String)this.messages.getString(PageType.getMessage(this.pageType)));
        this.player.openInventory(this.inventory);
        this.items.forEach((k, v) -> this.inventory.setItem(k.intValue(), v.getItemStack()));
    }

    private void fillOwnerListHeader() {
        this.fillInfoHeader();
        ArrayList<String> lore = new ArrayList<String>();
        if (this.doorOwnerPage != 0) {
            this.addLore(lore, this.messages.getString("GUI.ToPage") + this.doorOwnerPage + this.messages.getString("GUI.OutOf") + this.maxDoorOwnerPageCount);
            this.items.put(1, new GUIItem(PAGESWITCHMAT, this.messages.getString("GUI.PreviousPage"), lore, this.doorOwnerPage));
            lore.clear();
        }
        if (this.doorOwnerPage + 1 < this.maxDoorOwnerPageCount) {
            this.addLore(lore, this.messages.getString("GUI.ToPage") + (this.doorOwnerPage + 2) + this.messages.getString("GUI.OutOf") + this.maxDoorOwnerPageCount);
            this.items.put(7, new GUIItem(PAGESWITCHMAT, this.messages.getString("GUI.NextPage"), lore, this.doorOwnerPage + 2));
            lore.clear();
        }
    }

    private void fillInfoHeader() {
        ArrayList<String> lore = new ArrayList<String>();
        this.items.put(0, new GUIItem(PAGESWITCHMAT, this.messages.getString("GUI.PreviousPage"), lore, this.page + 1));
        lore.clear();
        this.addLore(lore, this.messages.getString("GUI.MoreInfoMenu") + this.door.getName());
        this.addLore(lore, "This door has ID " + this.door.getDoorUID());
        this.addLore(lore, this.messages.getString(DoorType.getNameKey(this.door.getType())));
        this.items.put(4, new GUIItem(CURRDOORMAT, this.door.getName() + ": " + this.door.getDoorUID(), lore, 1));
    }

    private void fillDefaultHeader() {
        ArrayList<String> lore = new ArrayList<String>();
        if (this.page != 0) {
            this.addLore(lore, this.messages.getString("GUI.ToPage") + this.page + this.messages.getString("GUI.OutOf") + this.maxPageCount);
            this.items.put(0, new GUIItem(PAGESWITCHMAT, this.messages.getString("GUI.PreviousPage"), lore, this.page));
            lore.clear();
        }
        this.addLore(lore, this.sortAlphabetically ? this.messages.getString("GUI.SORTED.Alphabetically") : this.messages.getString("GUI.SORTED.Numerically"));
        this.items.put(1, new GUIItem(TOGGLEDOORMAT, this.messages.getString("GUI.SORTED.Change"), lore, 1));
        lore.clear();
        this.addCreationBook(DoorType.DRAWBRIDGE, 3, "GUI.NewDrawbridge");
        this.addCreationBook(DoorType.DOOR, 4, "GUI.NewDoor");
        this.addCreationBook(DoorType.PORTCULLIS, 5, "GUI.NewPortcullis");
        this.addCreationBook(DoorType.SLIDINGDOOR, 6, "GUI.NewSlidingDoor");
        if (this.page + 1 < this.maxPageCount) {
            this.addLore(lore, this.messages.getString("GUI.ToPage") + (this.page + 2) + this.messages.getString("GUI.OutOf") + this.maxPageCount);
            this.items.put(8, new GUIItem(PAGESWITCHMAT, this.messages.getString("GUI.NextPage"), lore, this.page + 2));
            lore.clear();
        }
    }

    private void addCreationBook(DoorType type, int idx, String message) {
        if (this.player.hasPermission(DoorType.getPermission(type))) {
            ArrayList<String> lore = new ArrayList<String>();
            this.addLore(lore, this.messages.getString("GUI.NewObjectLong") + this.messages.getString(message));
            this.items.put(idx, new GUIItem(NEWDOORMAT, this.messages.getString(message), lore, this.page + 1));
        }
    }

    private void fillConfirmationItems() {
        int mid = 22;
        for (int idx = 9; idx < 45; ++idx) {
            ArrayList<String> lore = new ArrayList<String>();
            if (idx == mid) {
                this.addLore(lore, this.messages.getString("GUI.ConfirmDelete"));
                this.items.put(idx, new GUIItem(NOTCONFIRMMAT, this.messages.getString("GUI.Confirm"), lore, 1, 14));
                continue;
            }
            this.addLore(lore, this.messages.getString("GUI.NotConfirm"));
            this.items.put(idx, new GUIItem(CONFIRMMAT, this.messages.getString("GUI.No"), lore, 1, 5));
        }
    }

    private void fillInformationItems() {
        int position = 9;
        for (DoorAttribute attr : DoorType.getAttributes(this.door.getType())) {
            GUIItem item;
            if (!this.plugin.getCommander().hasPermissionNodeForAction(this.player, attr) || attr == DoorAttribute.NOTIFICATIONS && !this.plugin.getConfigLoader().allowNotifications() || (item = this.getGUIItem(this.door, attr)) == null) continue;
            this.items.put(position++, item);
        }
    }

    private void fillDoors() {
        int offset = this.page * 36;
        int endCount = Math.min(36, this.doors.size() - offset);
        ArrayList<String> lore = new ArrayList<String>();
        for (int idx = 0; idx < endCount; ++idx) {
            int realIdx = offset + idx;
            DoorType doorType = this.doors.get(realIdx).getType();
            if (doorType == null) {
                this.plugin.getMyLogger().logMessage("Failed to determine doorType of door: " + this.doors.get(realIdx).getDoorUID(), true, false);
                continue;
            }
            this.addLore(lore, this.messages.getString("GUI.DoorHasID") + this.doors.get(realIdx).getDoorUID());
            this.addLore(lore, this.messages.getString(DoorType.getNameKey(doorType)));
            GUIItem item = new GUIItem(DOORTYPES[DoorType.getValue(doorType)], this.doors.get(realIdx).getName(), lore, 1);
            item.setDoor(this.doors.get(realIdx));
            this.items.put(idx + 9, item);
            lore.clear();
        }
    }

    private boolean isStillOwner() {
        if (this.door != null && this.plugin.getCommander().getPermission(this.player.getUniqueId().toString(), this.door.getDoorUID()) == -1) {
            this.doors.remove(this.door);
            this.door = null;
            this.pageType = PageType.DOORLIST;
            return false;
        }
        return true;
    }

    public void handleInput(int interactionIDX) {
        if (!this.items.containsKey(interactionIDX)) {
            return;
        }
        boolean header = Util.between(interactionIDX, 0, 8);
        switch (this.pageType) {
            case CONFIRMATION: {
                this.handleInputConfirmation(interactionIDX);
                break;
            }
            case DOORINFO: {
                this.handleInputDoorInfo(interactionIDX);
                break;
            }
            case DOORLIST: {
                this.handleInputDoorList(interactionIDX, header);
                break;
            }
        }
    }

    private void handleInputConfirmation(int interactionIDX) {
        if (!this.isStillOwner()) {
            return;
        }
        int mid = 22;
        if (interactionIDX == mid) {
            this.deleteDoor();
        }
        this.pageType = PageType.DOORINFO;
        this.update();
    }

    private void handleInputDoorInfo(int interactionIDX) {
        if (interactionIDX == 0) {
            this.pageType = PageType.DOORLIST;
            this.update();
        } else {
            DoorAttribute attribute = this.items.get(interactionIDX).getDoorAttribute();
            if (attribute == null) {
                return;
            }
            if (!this.plugin.getCommander().hasPermissionForAction(this.player, this.door.getDoorUID(), attribute)) {
                this.update();
                return;
            }
            switch (attribute) {
                case LOCK: {
                    this.door.setLock(!this.door.isLocked());
                    this.plugin.getCommander().setLock(this.door.getDoorUID(), this.door.isLocked());
                    this.update();
                    break;
                }
                case TOGGLE: {
                    this.plugin.getCommandHandler().openDoorCommand(this.player, this.door);
                    break;
                }
                case INFO: {
                    this.plugin.getCommandHandler().listDoorInfo(this.player, this.door);
                    break;
                }
                case DELETE: {
                    this.pageType = PageType.CONFIRMATION;
                    this.update();
                    break;
                }
                case RELOCATEPOWERBLOCK: {
                    this.plugin.getCommandHandler().startPowerBlockRelocator(this.player, this.door);
                    this.close();
                    break;
                }
                case DIRECTION_STRAIGHT: 
                case DIRECTION_ROTATE: {
                    this.changeOpenDir(this.player, this.door);
                    break;
                }
                case CHANGETIMER: {
                    this.plugin.getCommandHandler().startTimerSetter(this.player, this.door.getDoorUID());
                    this.close();
                    break;
                }
                case BLOCKSTOMOVE: {
                    this.plugin.getCommandHandler().startBlocksToMoveSetter(this.player, this.door.getDoorUID());
                    this.close();
                    break;
                }
                case ADDOWNER: {
                    this.plugin.getCommandHandler().startAddOwner(this.player, this.door.getDoorUID());
                    this.close();
                    break;
                }
                case REMOVEOWNER: {
                    this.switchToRemoveOwner();
                    break;
                }
                case NOTIFICATIONS: {
                    boolean newStatus = !this.door.notificationEnabled();
                    this.door.setNotificationEnabled(newStatus);
                    this.plugin.getCommander().updateDoorNotify(this.door.getDoorUID(), newStatus);
                    this.update();
                }
            }
        }
    }

    private void handleInputDoorList(int interactionIDX, boolean header) {
        if (interactionIDX == 0) {
            --this.page;
            this.update();
        } else if (interactionIDX == 1) {
            this.sortAlphabetically = !this.sortAlphabetically;
            this.sort();
            this.update();
        } else if (interactionIDX == 8) {
            ++this.page;
            this.update();
        } else if (header) {
            String itemName = this.items.get(interactionIDX).getName();
            if (itemName.equals(this.messages.getString("GUI.NewDoor"))) {
                this.startCreationProcess(this.player, DoorType.DOOR);
            } else if (itemName.equals(this.messages.getString("GUI.NewPortcullis"))) {
                this.startCreationProcess(this.player, DoorType.PORTCULLIS);
            } else if (itemName.equals(this.messages.getString("GUI.NewDrawbridge"))) {
                this.startCreationProcess(this.player, DoorType.DRAWBRIDGE);
            } else if (itemName.equals(this.messages.getString("GUI.NewSlidingDoor"))) {
                this.startCreationProcess(this.player, DoorType.SLIDINGDOOR);
            }
        } else {
            this.door = this.items.get(interactionIDX).getDoor();
            if (this.door == null) {
                Util.messagePlayer(this.player, "An unexpected error occurred while trying to open a sub-menu for a door! Try again!");
                this.close();
                return;
            }
            if (this.isStillOwner()) {
                this.pageType = PageType.DOORINFO;
            }
            this.update();
        }
    }

    private void switchToRemoveOwner() {
        this.plugin.getCommandHandler().startRemoveOwner(this.player, this.door.getDoorUID());
        this.close();
    }

    private void sort() {
        if (this.sortAlphabetically) {
            Collections.sort(this.doors, Comparator.comparing(Door::getName));
        } else {
            Collections.sort(this.doors, Comparator.comparing(Door::getDoorUID));
        }
    }

    private GUIItem getGUIItem(Door door, DoorAttribute atr) {
        if (door.getPermission() > DoorAttribute.getPermissionLevel(atr)) {
            return null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        GUIItem ret = null;
        switch (atr) {
            case LOCK: {
                if (door.isLocked()) {
                    ret = new GUIItem(LOCKDOORMAT, this.messages.getString("GUI.UnlockDoor"), null, 1, 5);
                    break;
                }
                ret = new GUIItem(UNLOCKDOORMAT, this.messages.getString("GUI.LockDoor"), null, 1, 14);
                break;
            }
            case TOGGLE: {
                String desc = this.messages.getString("GUI.ToggleDoor");
                ret = new GUIItem(TOGGLEDOORMAT, desc, lore, 1);
                break;
            }
            case INFO: {
                String desc = this.messages.getString("GUI.GetInfo");
                ret = new GUIItem(INFOMAT, desc, lore, 1);
                break;
            }
            case DELETE: {
                String desc = this.messages.getString("GUI.DeleteDoor");
                String loreStr = this.messages.getString("GUI.DeleteDoorLong");
                this.addLore(lore, loreStr);
                ret = new GUIItem(DELDOORMAT, desc, lore, 1);
                break;
            }
            case RELOCATEPOWERBLOCK: {
                String desc = this.messages.getString("GUI.RelocatePowerBlock");
                String loreStr = this.messages.getString("GUI.RelocatePowerBlockLore");
                this.addLore(lore, loreStr);
                ret = new GUIItem(RELOCATEPBMAT, desc, lore, 1);
                break;
            }
            case CHANGETIMER: {
                String desc = this.messages.getString("GUI.ChangeTimer");
                String loreStr = door.getAutoClose() > -1 ? this.messages.getString("GUI.ChangeTimerLore") + door.getAutoClose() + "s." : this.messages.getString("GUI.ChangeTimerLoreDisabled");
                this.addLore(lore, loreStr);
                int count = door.getAutoClose() < 1 ? 1 : door.getAutoClose();
                ret = new GUIItem(CHANGETIMEMAT, desc, lore, count);
                break;
            }
            case DIRECTION_STRAIGHT: {
                String desc = this.messages.getString("GUI.Direction.Name");
                String loreStr = this.messages.getString("GUI.Direction.ThisDoorGoes") + this.messages.getString(RotateDirection.getNameKey(door.getOpenDir()));
                this.addLore(lore, loreStr);
                ret = new GUIItem(SETOPENDIRMAT, desc, lore, 1);
                break;
            }
            case DIRECTION_ROTATE: {
                String desc = this.messages.getString("GUI.Direction.Name");
                String loreStr = this.messages.getString("GUI.Direction.ThisDoorOpens") + this.messages.getString(RotateDirection.getNameKey(door.getOpenDir()));
                this.addLore(lore, loreStr);
                this.addLore(lore, this.messages.getString("GUI.Direction.Looking") + (door.getType() == DoorType.DOOR ? this.messages.getString(RotateDirection.getNameKey(RotateDirection.DOWN)) : (door.getLookingDir() == DoorDirection.NORTH ? this.messages.getString(RotateDirection.getNameKey(RotateDirection.EAST)) : this.messages.getString(RotateDirection.getNameKey(RotateDirection.NORTH)))));
                ret = new GUIItem(SETOPENDIRMAT, desc, lore, 1);
                break;
            }
            case BLOCKSTOMOVE: {
                String desc = this.messages.getString("GUI.BLOCKSTOMOVE.Name");
                String loreStr = door.getBlocksToMove() <= 0 ? this.messages.getString("GUI.BLOCKSTOMOVE.Unavailable") : this.messages.getString("GUI.BLOCKSTOMOVE.Available") + " " + door.getBlocksToMove();
                this.addLore(lore, loreStr);
                ret = new GUIItem(SETBTMOVEMAT, desc, lore, 1);
                break;
            }
            case ADDOWNER: {
                String desc = this.messages.getString("GUI.ADDOWNER");
                ret = new GUIItem(ADDOWNERMAT, desc, lore, 1, 3);
                break;
            }
            case REMOVEOWNER: {
                String desc = this.messages.getString("GUI.REMOVEOWNER");
                ret = new GUIItem(REMOVEOWNERMAT, desc, lore, 1, 0);
                break;
            }
            case NOTIFICATIONS: {
                String desc = this.messages.getString("GUI.ReceiveNotifications");
                this.addLore(lore, door.notificationEnabled() ? this.messages.getString("GUI.ReceiveNotificationsLoreEnabled") : this.messages.getString("GUI.ReceiveNotificationsLoreDisabled"));
                ret = new GUIItem(door.notificationEnabled() ? NOTIFICATIONSMAT_ON : NOTIFICATIONSMAT_OFF, desc, lore, 1);
            }
        }
        if (ret != null) {
            ret.setDoorAttribute(atr);
        }
        return ret;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void close() {
        this.player.closeInventory();
        this.plugin.removeGUIUser(this);
    }

    private void deleteDoor() {
        if (this.plugin.getCommander().removeDoor(this.getPlayer(), this.door.getDoorUID())) {
            this.doors.remove(this.door);
        }
    }

    private void startCreationProcess(Player player, DoorType type) {
        player.closeInventory();
        this.plugin.getCommandHandler().startCreator(player, null, type);
    }

    private void changeOpenDir(Player player, Door door) {
        RotateDirection curOpenDir = door.getOpenDir();
        RotateDirection newOpenDir = door.getType() == DoorType.SLIDINGDOOR ? (curOpenDir == RotateDirection.NONE ? RotateDirection.NORTH : (curOpenDir == RotateDirection.NORTH ? RotateDirection.EAST : (curOpenDir == RotateDirection.EAST ? RotateDirection.SOUTH : (curOpenDir == RotateDirection.SOUTH ? RotateDirection.WEST : RotateDirection.NORTH)))) : (door.getType() == DoorType.DRAWBRIDGE ? (curOpenDir == RotateDirection.NONE ? RotateDirection.NORTH : (curOpenDir == RotateDirection.NORTH ? RotateDirection.SOUTH : (curOpenDir == RotateDirection.SOUTH ? RotateDirection.NORTH : (curOpenDir == RotateDirection.EAST ? RotateDirection.WEST : RotateDirection.EAST)))) : (door.getType() == DoorType.PORTCULLIS ? (curOpenDir == RotateDirection.DOWN ? RotateDirection.UP : RotateDirection.DOWN) : (curOpenDir == RotateDirection.NONE ? RotateDirection.CLOCKWISE : (curOpenDir == RotateDirection.CLOCKWISE ? RotateDirection.COUNTERCLOCKWISE : RotateDirection.CLOCKWISE))));
        this.plugin.getCommander().updateDoorOpenDirection(door.getDoorUID(), newOpenDir);
        int idx = this.doors.indexOf(door);
        this.doors.get(idx).setOpenDir(newOpenDir);
        door = this.doors.get(idx);
        this.refresh();
    }

    static {
        if (BigDoors.MCVersion.v1_11_R1.equals((Object)BigDoors.getMCVersion()) || BigDoors.MCVersion.v1_12_R1.equals((Object)BigDoors.getMCVersion())) {
            GUI.DOORTYPES[0] = Material.getMaterial((String)"WOOD_DOOR");
            GUI.DOORTYPES[1] = Material.getMaterial((String)"TRAP_DOOR");
            GUI.DOORTYPES[2] = Material.getMaterial((String)"IRON_DOOR");
            GUI.DOORTYPES[3] = Material.getMaterial((String)"PISTON_BASE");
        } else {
            GUI.DOORTYPES[0] = XMaterial.OAK_DOOR.parseMaterial();
            GUI.DOORTYPES[1] = XMaterial.OAK_TRAPDOOR.parseMaterial();
            GUI.DOORTYPES[2] = XMaterial.IRON_DOOR.parseMaterial();
            GUI.DOORTYPES[3] = XMaterial.PISTON.parseMaterial();
        }
        newLines = Pattern.compile("\\\n");
    }
}

