/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import java.util.UUID;
import nl.pim16aap2.bigDoors.util.DoorDirection;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.RotateDirection;
import nl.pim16aap2.bigDoors.util.Util;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class Door {
    private Location min;
    private Location max;
    private String name;
    private DoorType type;
    private World world;
    private boolean isOpen;
    private Location engine;
    private UUID player;
    private final long doorUID;
    private RotateDirection openDir;
    private boolean isLocked;
    private int autoClose;
    private DoorDirection engineSide;
    private String playerName;
    private Location powerBlock;
    private Integer roundedLength;
    private int permission;
    private Location chunkLoc;
    private Integer length;
    private UUID primeOwner;
    private boolean notify;
    private Integer blockCount = null;
    private int blocksToMove = 0;

    public Door(UUID player, String playerName, UUID primeOwner, World world, Location min, Location max, Location engine, String name, boolean isOpen, long doorUID, boolean isLocked, int permission, DoorType type, DoorDirection engineSide, Location powerBlock, RotateDirection openDir, int autoClose, boolean notify) {
        this.player = player;
        this.world = world;
        this.min = min;
        this.max = max;
        this.engine = engine;
        this.powerBlock = powerBlock;
        this.playerName = playerName;
        this.name = name;
        this.isOpen = isOpen;
        this.doorUID = doorUID;
        this.isLocked = isLocked;
        this.permission = permission;
        this.type = type;
        this.engineSide = engineSide;
        this.chunkLoc = null;
        this.length = null;
        this.roundedLength = null;
        this.openDir = openDir == null ? RotateDirection.NONE : openDir;
        this.autoClose = autoClose;
        this.primeOwner = primeOwner;
        this.notify = notify;
    }

    public Door(UUID player, String playerName, UUID primeOwner, World world, Location min, Location max, Location engine, String name, boolean isOpen, long doorUID, boolean isLocked, int permission, DoorType type, Location powerBlock, RotateDirection openDir, int autoClose, boolean notify) {
        this(player, playerName, primeOwner, world, min, max, engine, name, isOpen, doorUID, isLocked, permission, type, null, powerBlock, openDir, autoClose, notify);
    }

    public Door(World world, Location min, Location max, Location engine, String name, boolean isOpen, long doorUID, boolean isLocked, int permission, String player, String playerName, UUID primeOwner, DoorType type, Location powerBlock, RotateDirection openDir, int autoClose, boolean notify) {
        this(UUID.fromString(player), playerName, primeOwner, world, min, max, engine, name, isOpen, doorUID, isLocked, permission, type, null, powerBlock, openDir, autoClose, notify);
    }

    public Door(World world, Location min, Location max, Location engine, String name, boolean isOpen, long doorUID, boolean isLocked, int permission, String player, String playerName, UUID primeOwner, DoorType type, DoorDirection engineSide, Location powerBlock, RotateDirection openDir, int autoClose, boolean notify) {
        this(UUID.fromString(player), playerName, primeOwner, world, min, max, engine, name, isOpen, doorUID, isLocked, permission, type, engineSide, powerBlock, openDir, autoClose, notify);
    }

    public DoorType getType() throws NullPointerException {
        try {
            return this.type;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public World getWorld() {
        return this.world;
    }

    public long getDoorUID() {
        return this.doorUID;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public int getPermission() {
        return this.permission;
    }

    public UUID getPlayerUUID() {
        return this.player;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public DoorDirection getEngSide() {
        return this.engineSide;
    }

    public RotateDirection getOpenDir() {
        return this.openDir;
    }

    public int getAutoClose() {
        return this.autoClose;
    }

    public int getBlocksToMove() {
        return this.blocksToMove;
    }

    public boolean notificationEnabled() {
        return this.notify;
    }

    public void setNotificationEnabled(boolean notify) {
        this.notify = notify;
    }

    public UUID getPrimeOwner() {
        return this.primeOwner;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.player = playerUUID;
    }

    public void setOpenDir(RotateDirection newRotDir) {
        this.openDir = newRotDir;
    }

    public void setBlocksToMove(int move) {
        this.blocksToMove = move;
    }

    public void setOpenStatus(boolean bool) {
        this.isOpen = bool;
    }

    public Location getPowerBlockLoc() {
        return this.powerBlock.clone();
    }

    public Location getEngine() {
        return this.engine.clone();
    }

    public Location getMinimum() {
        return this.min.clone();
    }

    public Location getMaximum() {
        return this.max.clone();
    }

    public void setMinimum(Location loc) {
        this.min.setX(loc.getX());
        this.min.setY(loc.getY());
        this.min.setZ(loc.getZ());
    }

    public void setMaximum(Location loc) {
        this.max.setX(loc.getX());
        this.max.setY(loc.getY());
        this.max.setZ(loc.getZ());
    }

    public void setLock(boolean lock) {
        this.isLocked = lock;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public void setEngineSide(DoorDirection newEngSide) {
        this.engineSide = newEngSide;
    }

    public Location getChunkCoords() {
        if (this.chunkLoc != null) {
            return this.chunkLoc;
        }
        this.chunkLoc = new Location(this.world, (double)(this.engine.getBlockX() >> 4), 0.0, (double)(this.engine.getBlockZ() >> 4));
        return this.chunkLoc;
    }

    public boolean chunkInRange(Chunk chunk) {
        if (!this.world.equals(chunk.getWorld())) {
            return false;
        }
        this.getChunkCoords();
        this.getLength();
        int difX = Math.abs(chunk.getX() - this.chunkLoc.getBlockX());
        int difZ = Math.abs(chunk.getZ() - this.chunkLoc.getBlockZ());
        return difX <= this.roundedLength && difZ <= this.roundedLength;
    }

    public int getRoundedLength() {
        if (this.roundedLength == null) {
            this.getLength();
        }
        return this.roundedLength;
    }

    public int getLength() {
        if (this.length != null) {
            return this.length;
        }
        int xLen = this.max.getBlockX() - this.min.getBlockX();
        int zLen = this.max.getBlockZ() - this.min.getBlockZ();
        this.length = 1;
        if (this.type.equals((Object)DoorType.DOOR) || this.type.equals((Object)DoorType.PORTCULLIS)) {
            this.length = xLen > zLen ? xLen : zLen;
        } else if (this.type.equals((Object)DoorType.DRAWBRIDGE) && this.engineSide != null) {
            int yLen = Math.abs(this.max.getBlockY() - this.min.getBlockY());
            this.length = this.engineSide.equals((Object)DoorDirection.NORTH) || this.engineSide.equals((Object)DoorDirection.SOUTH) ? Integer.valueOf(zLen > yLen ? zLen : yLen) : Integer.valueOf(xLen > yLen ? xLen : yLen);
        }
        if (this.type.equals((Object)DoorType.PORTCULLIS)) {
            this.length = this.length / 2;
        }
        this.roundedLength = this.length / 16 + 1;
        return this.length;
    }

    public DoorDirection getLookingDir() {
        if (this.type.equals((Object)DoorType.DRAWBRIDGE) || this.type.equals((Object)DoorType.PORTCULLIS)) {
            return this.engineSide == DoorDirection.NORTH || this.engineSide == DoorDirection.SOUTH ? DoorDirection.NORTH : DoorDirection.EAST;
        }
        return this.engine.getBlockZ() != this.min.getBlockZ() ? DoorDirection.NORTH : (this.engine.getBlockX() != this.max.getBlockX() ? DoorDirection.EAST : (this.engine.getBlockZ() != this.max.getBlockZ() ? DoorDirection.SOUTH : (this.engine.getBlockX() != this.min.getBlockX() ? DoorDirection.WEST : null)));
    }

    public long getPowerBlockChunkHash() {
        return Util.chunkHashFromLocation(this.powerBlock.getBlockX(), this.powerBlock.getBlockZ(), this.world.getUID());
    }

    private int calculateBlockCount() {
        int xLen = Math.abs(this.getMaximum().getBlockX() - this.getMinimum().getBlockX()) + 1;
        int yLen = Math.abs(this.getMaximum().getBlockY() - this.getMinimum().getBlockY()) + 1;
        int zLen = Math.abs(this.getMaximum().getBlockZ() - this.getMinimum().getBlockZ()) + 1;
        return xLen * yLen * zLen;
    }

    public int getBlockCount() {
        return this.blockCount == null ? (this.blockCount = Integer.valueOf(this.calculateBlockCount())) : this.blockCount;
    }

    public String toSimpleString() {
        return this.doorUID + " \"" + this.name + "\"";
    }

    public String toString() {
        String ret = "";
        ret = ret + "\"" + this.name + "\". Owned by \"" + this.player.toString() + "\" (" + this.getPermission() + ")\n";
        ret = ret + "Max = " + Util.locIntToString(this.max) + ", min = " + Util.locIntToString(this.min) + "\n";
        ret = ret + "Eng = " + Util.locIntToString(this.engine) + ", locked = " + this.isLocked + ", open = " + this.isOpen + "\n";
        ret = ret + "blockCount = " + this.getBlockCount() + ", hash = " + this.getPowerBlockChunkHash();
        return ret;
    }
}

