/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import nl.pim16aap2.bigDoors.AutoCloseScheduler;
import nl.pim16aap2.bigDoors.Commander;
import nl.pim16aap2.bigDoors.Door;
import nl.pim16aap2.bigDoors.GUI.GUI;
import nl.pim16aap2.bigDoors.MyLogger;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_11_R1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_12_R1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_13_R1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_13_R1_5;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_13_R2;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_14_R1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_15_R1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_16_R1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_16_R2;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_16_R3;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_17_R1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_18_R1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_18_R2;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_19_R1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_19_R1_1;
import nl.pim16aap2.bigDoors.NMS.FallingBlockFactory_V1_19_R2;
import nl.pim16aap2.bigDoors.UpdateManager;
import nl.pim16aap2.bigDoors.VaultManager;
import nl.pim16aap2.bigDoors.WorldHeightManager;
import nl.pim16aap2.bigDoors.codegeneration.FallbackGeneratorManager;
import nl.pim16aap2.bigDoors.compatibility.FakePlayerCreator;
import nl.pim16aap2.bigDoors.compatibility.ProtectionCompatManager;
import nl.pim16aap2.bigDoors.handlers.ChunkUnloadHandler;
import nl.pim16aap2.bigDoors.handlers.CommandHandler;
import nl.pim16aap2.bigDoors.handlers.EventHandlers;
import nl.pim16aap2.bigDoors.handlers.FailureCommandHandler;
import nl.pim16aap2.bigDoors.handlers.GUIHandler;
import nl.pim16aap2.bigDoors.handlers.LoginMessageHandler;
import nl.pim16aap2.bigDoors.handlers.LoginResourcePackHandler;
import nl.pim16aap2.bigDoors.handlers.RedstoneHandler;
import nl.pim16aap2.bigDoors.lib.bstats.bukkit.Metrics;
import nl.pim16aap2.bigDoors.lib.bstats.charts.AdvancedPie;
import nl.pim16aap2.bigDoors.moveBlocks.BridgeOpener;
import nl.pim16aap2.bigDoors.moveBlocks.DoorOpener;
import nl.pim16aap2.bigDoors.moveBlocks.Opener;
import nl.pim16aap2.bigDoors.moveBlocks.PortcullisOpener;
import nl.pim16aap2.bigDoors.moveBlocks.SlidingDoorOpener;
import nl.pim16aap2.bigDoors.reflection.BukkitReflectionUtil;
import nl.pim16aap2.bigDoors.storage.sqlite.SQLiteJDBCDriverConnection;
import nl.pim16aap2.bigDoors.toolUsers.ToolUser;
import nl.pim16aap2.bigDoors.toolUsers.ToolVerifier;
import nl.pim16aap2.bigDoors.util.ChunkUtils;
import nl.pim16aap2.bigDoors.util.ConfigLoader;
import nl.pim16aap2.bigDoors.util.DoorOpenResult;
import nl.pim16aap2.bigDoors.util.DoorType;
import nl.pim16aap2.bigDoors.util.Messages;
import nl.pim16aap2.bigDoors.util.TimedCache;
import nl.pim16aap2.bigDoors.util.Util;
import nl.pim16aap2.bigDoors.waitForCommand.WaitForCommand;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigDoors
extends JavaPlugin
implements Listener {
    private static BigDoors instance;
    public static final boolean DEVBUILD = false;
    private int buildNumber = -1;
    private static final String PACKAGE_VERSION;
    public static final int MINIMUMDOORDELAY = 15;
    private static final Set<String> BLACKLISTED_SERVERS;
    private static final List<String> BLACKLISTED_PLUGINS;
    private ToolVerifier tf;
    private SQLiteJDBCDriverConnection db;
    private FallingBlockFactory fabf;
    private ConfigLoader config;
    private String locale;
    private final MyLogger logger;
    private final File logFile;
    private Metrics metrics;
    private Messages messages;
    private Commander commander = null;
    private DoorOpener doorOpener;
    private BridgeOpener bridgeOpener;
    private CommandHandler commandHandler;
    private FailureCommandHandler failureCommandHandler;
    private SlidingDoorOpener slidingDoorOpener;
    private PortcullisOpener portcullisOpener;
    @Nullable
    private RedstoneHandler redstoneHandler;
    private boolean validVersion;
    private HashMap<UUID, ToolUser> toolUsers;
    private HashMap<UUID, GUI> playerGUIs;
    private HashMap<UUID, WaitForCommand> cmdWaiters;
    private FakePlayerCreator fakePlayerCreator;
    private AutoCloseScheduler autoCloseScheduler;
    private ProtectionCompatManager protCompatMan;
    @Nullable
    private LoginResourcePackHandler rPackHandler;
    private TimedCache<Long, HashMap<Long, Long>> pbCache = null;
    private VaultManager vaultManager;
    private UpdateManager updateManager;
    @NotNull
    private static final MCVersion MC_VERSION;
    private static final boolean IS_ON_FLATTENED_VERSION;
    private boolean isEnabled = false;
    private final List<String> loginMessages = new ArrayList<String>();
    private final WorldHeightManager worldHeightManager = new WorldHeightManager();

    public BigDoors() {
        instance = this;
        this.logFile = new File(this.getDataFolder(), "log.txt");
        this.logger = new MyLogger(this, this.logFile);
        this.initLegacyMaterials();
    }

    public void onEnable() {
        this.updateManager = new UpdateManager(this);
        this.buildNumber = this.readBuildNumber();
        this.overrideVersion();
        try {
            this.readConfigValues();
        }
        catch (Exception e) {
            this.logger.logMessageToConsoleOnly("Failed to read config file. Plugin disabled!");
            this.setDisabled("This plugin is disabled because it failed to read config file!");
            this.getMyLogger().logMessage(Level.SEVERE, Util.throwableToString(e));
            return;
        }
        try {
            BukkitReflectionUtil.init();
        }
        catch (Exception e) {
            this.setDisabled("Failed to initialize BukkitReflectionUtil!");
            this.getMyLogger().logMessage(Level.SEVERE, Util.throwableToString(e));
            return;
        }
        this.updateManager.setEnabled(this.getConfigLoader().autoDLUpdate(), this.getConfigLoader().announceUpdateCheck());
        this.messages = new Messages(this);
        Optional<String> disableReason = this.isCurrentEnvironmentInvalid();
        if (disableReason.isPresent()) {
            if (!this.getConfigLoader().unsafeMode()) {
                String error = "This plugin is disabled because it is running in an invalid environment: '" + disableReason.get() + "'. This can be bypassed in the config if you are feeling adventurous (unsafeMode).";
                this.logger.logMessage(error, true, true);
                this.setDisabled(error);
                return;
            }
            if (this.config.unsafeModeNotification()) {
                this.loginMessages.add("You are trying to load this plugin in an unsupported environment: '" + disableReason.get() + "'. This may cause issues!");
            }
        }
        this.logger.logMessageToLogFile("Starting BigDoors version: " + this.getDescription().getVersion());
        try {
            Bukkit.getPluginManager().registerEvents((Listener)new LoginMessageHandler(this), (Plugin)this);
            this.validVersion = this.compatibleMCVer();
            if (!this.validVersion) {
                this.logger.logMessage("Trying to load the plugin on an incompatible version of Minecraft! (\"" + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3] + "\"). This plugin will NOT be enabled!", true, true);
                this.logger.logMessage("If no update is available for this version, you could try to enable __CODE GENERATION__ in the config.", true, true);
                this.logger.logMessage("Code generation may add support for this version, but be sure to read the warning in the config before using it!", true, true);
                this.setDisabled("This version of Minecraft is not supported. Is the plugin up-to-date? Or enable code generation.");
                return;
            }
            this.fakePlayerCreator = new FakePlayerCreator(this);
            this.init();
            this.vaultManager = new VaultManager(this);
            this.autoCloseScheduler = new AutoCloseScheduler(this);
            Bukkit.getPluginManager().registerEvents((Listener)new EventHandlers(this), (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)new GUIHandler(this), (Plugin)this);
            Bukkit.getPluginManager().registerEvents((Listener)new ChunkUnloadHandler(this), (Plugin)this);
            this.pbCache = new TimedCache(this, this.config.cacheTimeout());
            this.protCompatMan = new ProtectionCompatManager(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.protCompatMan, (Plugin)this);
            this.db = new SQLiteJDBCDriverConnection(this, this.config.dbFile());
            this.commander = new Commander(this, this.db);
            this.doorOpener = new DoorOpener(this);
            this.bridgeOpener = new BridgeOpener(this);
            this.commandHandler = new CommandHandler(this);
            this.portcullisOpener = new PortcullisOpener(this);
            this.slidingDoorOpener = new SlidingDoorOpener(this);
            this.registerCommands(this.commandHandler);
        }
        catch (Exception exception) {
            this.logger.logMessage(Util.throwableToString(exception), true, true, Level.SEVERE);
            this.setDisabled("This plugin is disabled because an unknown error occurred during startup, please check the logs!");
        }
        this.isEnabled = true;
    }

    public WorldHeightManager getWorldHeightManager() {
        return this.worldHeightManager;
    }

    private Optional<String> isCurrentEnvironmentInvalid() {
        for (String pluginName : BLACKLISTED_PLUGINS) {
            if (this.getServer().getPluginManager().getPlugin(pluginName) == null) continue;
            return Optional.of(pluginName);
        }
        if (BLACKLISTED_SERVERS.contains(Bukkit.getName())) {
            return Optional.of(Bukkit.getName());
        }
        return Optional.empty();
    }

    private void registerCommands(CommandExecutor commandExecutor) {
        this.getCommand("recalculatepowerblocks").setExecutor(commandExecutor);
        this.getCommand("killbigdoorsentities").setExecutor(commandExecutor);
        this.getCommand("inspectpowerblockloc").setExecutor(commandExecutor);
        this.getCommand("changepowerblockloc").setExecutor(commandExecutor);
        this.getCommand("setautoclosetime").setExecutor(commandExecutor);
        this.getCommand("setdoorrotation").setExecutor(commandExecutor);
        this.getCommand("setblockstomove").setExecutor(commandExecutor);
        this.getCommand("listplayerdoors").setExecutor(commandExecutor);
        this.getCommand("setnotification").setExecutor(commandExecutor);
        this.getCommand("newportcullis").setExecutor(commandExecutor);
        this.getCommand("toggledoor").setExecutor(commandExecutor);
        this.getCommand("pausedoors").setExecutor(commandExecutor);
        this.getCommand("closedoor").setExecutor(commandExecutor);
        this.getCommand("doordebug").setExecutor(commandExecutor);
        this.getCommand("listdoors").setExecutor(commandExecutor);
        this.getCommand("stopdoors").setExecutor(commandExecutor);
        this.getCommand("bdcancel").setExecutor(commandExecutor);
        this.getCommand("filldoor").setExecutor(commandExecutor);
        this.getCommand("doorinfo").setExecutor(commandExecutor);
        this.getCommand("opendoor").setExecutor(commandExecutor);
        this.getCommand("nameDoor").setExecutor(commandExecutor);
        this.getCommand("bigdoors").setExecutor(commandExecutor);
        this.getCommand("newdoor").setExecutor(commandExecutor);
        this.getCommand("deldoor").setExecutor(commandExecutor);
        this.getCommand("bdm").setExecutor(commandExecutor);
    }

    private void setDisabled(String reason) {
        this.failureCommandHandler = new FailureCommandHandler(reason);
        this.registerCommands(this.failureCommandHandler);
    }

    private void init() {
        if (!this.validVersion) {
            return;
        }
        if (this.isEnabled) {
            this.readConfigValues();
        }
        Util.processConfig(this.getConfigLoader());
        this.messages.reloadMessages();
        this.toolUsers = new HashMap();
        this.playerGUIs = new HashMap();
        this.cmdWaiters = new HashMap();
        this.tf = new ToolVerifier(this.messages.getString("CREATOR.GENERAL.StickName"));
        if (this.config.enableRedstone()) {
            this.redstoneHandler = new RedstoneHandler(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.redstoneHandler, (Plugin)this);
        }
        if (this.config.resourcePackEnabled()) {
            this.rPackHandler = new LoginResourcePackHandler(this, this.config.resourcePack());
            Bukkit.getPluginManager().registerEvents((Listener)this.rPackHandler, (Plugin)this);
        }
        if (this.config.allowStats()) {
            this.logger.myLogger(Level.INFO, "Enabling stats! Thanks, it really helps!");
            this.setupMetrics();
        } else {
            this.metrics = null;
            this.logger.myLogger(Level.INFO, "Stats disabled, not laoding stats :(... Please consider enabling it! I am a simple man, seeing higher user numbers helps me stay motivated!");
        }
        this.updateManager.setEnabled(this.getConfigLoader().autoDLUpdate(), this.getConfigLoader().announceUpdateCheck());
        if (this.commander != null) {
            this.commander.setCanGo(true);
        }
    }

    public static BigDoors get() {
        return instance;
    }

    @NotNull
    public ClassLoader getBigDoorsClassLoader() {
        return super.getClassLoader();
    }

    public boolean isEnabledSuccessfully() {
        return this.isEnabled;
    }

    public int getBuild() {
        return this.buildNumber;
    }

    public void onPlayerLogout(Player player) {
        WaitForCommand cw = this.getCommandWaiter(player);
        if (cw != null) {
            cw.abortSilently();
        }
        this.playerGUIs.remove(player.getUniqueId());
        ToolUser tu = this.getToolUser(player);
        if (tu != null) {
            tu.abortSilently();
        }
    }

    public String getPackageVersion() {
        return PACKAGE_VERSION;
    }

    public String canBreakBlock(UUID playerUUID, String playerName, Location loc) {
        return this.protCompatMan.canBreakBlock(playerUUID, playerName, loc);
    }

    public String canBreakBlocksBetweenLocs(UUID playerUUID, String playerName, World world, Location loc1, Location loc2) {
        return this.protCompatMan.canBreakBlocksBetweenLocs(playerUUID, playerName, world, loc1, loc2);
    }

    public void restart() {
        if (!this.validVersion) {
            return;
        }
        this.reloadConfig();
        this.onDisable();
        this.protCompatMan.restart();
        this.playerGUIs.forEach((key, value) -> value.close());
        this.playerGUIs.clear();
        if (this.redstoneHandler != null) {
            HandlerList.unregisterAll((Listener)this.redstoneHandler);
            this.redstoneHandler = null;
        }
        if (this.rPackHandler != null) {
            HandlerList.unregisterAll((Listener)this.rPackHandler);
            this.rPackHandler = null;
        }
        this.init();
        this.vaultManager.init();
        this.pbCache.reinit(this.config.cacheTimeout());
    }

    public void onDisable() {
        if (!this.validVersion) {
            return;
        }
        this.closeGUIs();
        this.commander.setCanGo(false);
        this.commander.stopMovers(true);
        for (Map.Entry<UUID, ToolUser> entry : this.toolUsers.entrySet()) {
            entry.getValue().abort();
        }
        this.toolUsers.clear();
        this.cmdWaiters.clear();
    }

    private void closeGUIs() {
        for (UUID uuid : this.playerGUIs.keySet()) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            player.closeInventory();
        }
        this.playerGUIs.clear();
    }

    private void setupMetrics() {
        if (this.metrics != null) {
            return;
        }
        this.metrics = new Metrics(this, 2887);
        this.metrics.addCustomChart(new AdvancedPie("doors_per_type", () -> {
            DoorType[] doorTypes = DoorType.values();
            HashMap<String, Integer> output = new HashMap<String, Integer>(doorTypes.length - 1);
            Map<DoorType, Integer> stats = this.db.getDatabaseStatistics();
            for (DoorType type : doorTypes) {
                output.put(DoorType.getFriendlyName(type), stats.getOrDefault((Object)type, 0));
            }
            return output;
        }));
    }

    public String getLoginMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.updateManager.updateAvailable()) {
            if (this.getConfigLoader().autoDLUpdate() && this.updateManager.hasUpdateBeenDownloaded()) {
                sb.append("[BigDoors] A new update (").append(this.updateManager.getNewestVersion()).append(") has been downloaded! ").append("Restart your server to apply the update!\n");
            } else if (this.updateManager.updateAvailable()) {
                sb.append("[BigDoors] A new update is available: ").append(this.updateManager.getNewestVersion()).append("\n");
            }
        }
        if (this.failureCommandHandler != null) {
            sb.append("[BigDoors] ").append(this.failureCommandHandler.getError()).append("\n");
        }
        this.loginMessages.forEach(str -> sb.append("[BigDoors] ").append((String)str).append("\n"));
        return sb.toString();
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public TimedCache<Long, HashMap<Long, Long>> getPBCache() {
        return this.pbCache;
    }

    public FallingBlockFactory getFABF() {
        return this.fabf;
    }

    public BigDoors getPlugin() {
        return this;
    }

    public AutoCloseScheduler getAutoCloseScheduler() {
        return this.autoCloseScheduler;
    }

    public FakePlayerCreator getFakePlayerCreator() {
        return this.fakePlayerCreator;
    }

    public Opener getDoorOpener(DoorType type) {
        switch (type) {
            case DOOR: {
                return this.doorOpener;
            }
            case DRAWBRIDGE: {
                return this.bridgeOpener;
            }
            case PORTCULLIS: {
                return this.portcullisOpener;
            }
            case SLIDINGDOOR: {
                return this.slidingDoorOpener;
            }
        }
        return null;
    }

    public ToolUser getToolUser(Player player) {
        return this.toolUsers.get(player.getUniqueId());
    }

    public void addToolUser(ToolUser toolUser) {
        this.toolUsers.put(toolUser.getPlayer().getUniqueId(), toolUser);
    }

    public void removeToolUser(ToolUser toolUser) {
        this.toolUsers.remove(toolUser.getPlayer().getUniqueId());
    }

    public GUI getGUIUser(Player player) {
        return this.playerGUIs.get(player.getUniqueId());
    }

    public void addGUIUser(GUI gui) {
        this.playerGUIs.put(gui.getPlayer().getUniqueId(), gui);
    }

    public void removeGUIUser(GUI gui) {
        this.playerGUIs.remove(gui.getPlayer().getUniqueId());
    }

    public WaitForCommand getCommandWaiter(Player player) {
        return this.cmdWaiters.get(player.getUniqueId());
    }

    public void addCommandWaiter(WaitForCommand cmdWaiter) {
        this.cmdWaiters.put(cmdWaiter.getPlayer().getUniqueId(), cmdWaiter);
    }

    public void removeCommandWaiter(WaitForCommand cmdWaiter) {
        this.cmdWaiters.remove(cmdWaiter.getPlayer().getUniqueId());
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public Commander getCommander() {
        return this.commander;
    }

    public MyLogger getMyLogger() {
        return this.logger;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public ConfigLoader getConfigLoader() {
        return this.config;
    }

    public VaultManager getVaultManager() {
        return this.vaultManager;
    }

    public ToolVerifier getTF() {
        return this.tf;
    }

    public String getLocale() {
        return this.locale == null ? "en_US" : this.locale;
    }

    public static MCVersion getMCVersion() {
        return MC_VERSION;
    }

    private void readConfigValues() {
        this.config = new ConfigLoader(this);
        this.locale = this.config.languageFile();
        if (this.config.unsafeMode()) {
            this.logger.warn("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            this.logger.warn("\u2551                                                       \u2551");
            this.logger.warn("\u2551                    !!  WARNING  !!                    \u2551");
            this.logger.warn("\u2551                                                       \u2551");
            this.logger.warn("\u2551                                                       \u2551");
            this.logger.warn("\u2551            You have enabled \"unsafe mode\"!            \u2551");
            this.logger.warn("\u2551                                                       \u2551");
            this.logger.warn("\u2551   THIS IS NOT SUPPORTED! USE THIS AT YOUR OWN RISK!   \u2551");
            this.logger.warn("\u2551                                                       \u2551");
            this.logger.warn("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        }
    }

    public static boolean isOnFlattenedVersion() {
        return IS_ON_FLATTENED_VERSION;
    }

    @NotNull
    private static MCVersion calculateMCVersion() {
        MCVersion[] values = MCVersion.values();
        MCVersion maxVersion = values[values.length - 1];
        try {
            String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            return MCVersion.valueOf(version);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            e.printStackTrace();
            Bukkit.getLogger().severe("Failed to figure out the current version from input: \"" + Bukkit.getServer().getClass().getPackage().getName() + "\"! We'll just assume you're using version " + (Object)((Object)maxVersion));
            return maxVersion;
        }
    }

    private boolean compatibleMCVer() throws Exception {
        String version;
        if (this.config.forceCodeGeneration()) {
            this.fabf = FallbackGeneratorManager.getFallingBlockFactory();
            return true;
        }
        try {
            version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        catch (ArrayIndexOutOfBoundsException useAVersionMentionedInTheDescriptionPleaseException) {
            useAVersionMentionedInTheDescriptionPleaseException.printStackTrace();
            return false;
        }
        String[] split = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        int minorVersion = Util.parseInt(split.length > 2 ? split[2] : null).orElse(0);
        this.fabf = null;
        switch (version) {
            case "v1_8_R1": 
            case "v1_8_R2": 
            case "v1_8_R3": 
            case "v1_9_R1": 
            case "v1_9_R2": 
            case "v1_10_R1": {
                return false;
            }
            case "v1_11_R1": {
                this.fabf = new FallingBlockFactory_V1_11_R1();
                break;
            }
            case "v1_12_R1": {
                this.fabf = new FallingBlockFactory_V1_12_R1();
                break;
            }
            case "v1_13_R1": {
                this.fabf = new FallingBlockFactory_V1_13_R1();
                break;
            }
            case "v1_13_R2": {
                if (minorVersion == 0) {
                    this.logger.severe("Failed to parse minor version from: \"" + Bukkit.getBukkitVersion() + "\"");
                    return false;
                }
                if (minorVersion == 1) {
                    this.fabf = new FallingBlockFactory_V1_13_R1_5();
                    break;
                }
                this.fabf = new FallingBlockFactory_V1_13_R2();
                break;
            }
            case "v1_14_R1": {
                this.fabf = new FallingBlockFactory_V1_14_R1();
                break;
            }
            case "v1_15_R1": {
                this.fabf = new FallingBlockFactory_V1_15_R1();
                break;
            }
            case "v1_16_R1": {
                this.fabf = new FallingBlockFactory_V1_16_R1();
                break;
            }
            case "v1_16_R2": {
                this.fabf = new FallingBlockFactory_V1_16_R2();
                break;
            }
            case "v1_16_R3": {
                this.fabf = new FallingBlockFactory_V1_16_R3();
                break;
            }
            case "v1_17_R1": {
                this.fabf = new FallingBlockFactory_V1_17_R1();
                break;
            }
            case "v1_18_R1": {
                this.fabf = new FallingBlockFactory_V1_18_R1();
                break;
            }
            case "v1_18_R2": {
                this.fabf = new FallingBlockFactory_V1_18_R2();
                break;
            }
            case "v1_19_R1": {
                if (minorVersion == 0) {
                    this.fabf = new FallingBlockFactory_V1_19_R1();
                    break;
                }
                this.fabf = new FallingBlockFactory_V1_19_R1_1();
                break;
            }
            case "v1_19_R2": {
                this.fabf = new FallingBlockFactory_V1_19_R2();
                break;
            }
            default: {
                if (!this.config.allowCodeGeneration()) break;
                this.fabf = FallbackGeneratorManager.getFallingBlockFactory();
            }
        }
        return this.fabf != null;
    }

    private int readBuildNumber() {
        int n;
        BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/build.number")));
        try {
            for (int idx = 0; idx != 2; ++idx) {
                reader.readLine();
            }
            n = Integer.parseInt(reader.readLine().replace("build.number=", ""));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return -1;
            }
        }
        reader.close();
        return n;
    }

    private void overrideVersion() {
        try {
            String version = this.getDescription().getVersion() + " (b" + this.buildNumber + ")";
            Field field = PluginDescriptionFile.class.getDeclaredField("version");
            field.setAccessible(true);
            field.set(this.getDescription(), version);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            this.getMyLogger().logMessage(Util.throwableToString(e), true, false);
        }
    }

    public boolean areChunksLoadedForDoor(Door door) {
        Opener opener = this.getDoorOpener(door.getType());
        return opener == null ? false : opener.chunksLoaded(door, ChunkUtils.ChunkLoadMode.VERIFY_LOADED) == ChunkUtils.ChunkLoadResult.PASS;
    }

    public DoorOpenResult toggleDoor(Door door, double time, boolean instantOpen) {
        Opener opener = this.getDoorOpener(door.getType());
        return opener == null ? DoorOpenResult.TYPEDISABLED : opener.openDoor(door, time, instantOpen);
    }

    public boolean toggleDoor(long doorUID, boolean instantOpen) {
        Door door = this.getCommander().getDoor(null, doorUID);
        return this.toggleDoor(door, 0.0, instantOpen) == DoorOpenResult.SUCCESS;
    }

    public boolean toggleDoor(long doorUID, double time) {
        Door door = this.getCommander().getDoor(null, doorUID);
        return this.toggleDoor(door, time, false) == DoorOpenResult.SUCCESS;
    }

    public boolean toggleDoor(long doorUID) {
        Door door = this.getCommander().getDoor(null, doorUID);
        return this.toggleDoor(door, 0.0, false) == DoorOpenResult.SUCCESS;
    }

    private boolean isOpen(Door door) {
        return door.isOpen();
    }

    public boolean isOpen(long doorUID) {
        Door door = this.getCommander().getDoor(null, doorUID);
        return this.isOpen(door);
    }

    public int getMinimumDoorDelay() {
        return 15;
    }

    private void initLegacyMaterials() {
        try {
            Class.forName("org.bukkit.craftbukkit." + BigDoors.get().getPackageVersion() + ".legacy.CraftLegacy");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public RedstoneHandler getRedstoneHandler() {
        return this.redstoneHandler;
    }

    static {
        PACKAGE_VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        BLACKLISTED_SERVERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("CatServer", "Mohist", "Magma", "Glowstone", "Akarin", "ArcLight")));
        BLACKLISTED_PLUGINS = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("Geyser-Spigot", "ViaRewind")));
        MC_VERSION = BigDoors.calculateMCVersion();
        IS_ON_FLATTENED_VERSION = MC_VERSION.isAtLeast(MCVersion.v1_13_R1);
    }

    public static enum MCVersion {
        v1_8_R1,
        v1_8_R2,
        v1_8_R3,
        v1_9_R1,
        v1_9_R2,
        v1_10_R1,
        v1_11_R1,
        v1_12_R1,
        v1_13_R1,
        v1_13_R2,
        v1_14_R1,
        v1_15_R1,
        v1_16_R1,
        v1_16_R2,
        v1_16_R3,
        v1_17_R1,
        v1_18_R1,
        v1_18_R2,
        v1_19_R1,
        v1_19_R2,
        v1_20_R1,
        v1_21_R1,
        v1_22_R1,
        v1_23_R1,
        v1_24_R1,
        v1_25_R1,
        v1_26_R1,
        v1_27_R1,
        v1_28_R1;


        public boolean isAtLeast(MCVersion test) {
            return this.ordinal() >= test.ordinal();
        }
    }
}

