/*
 * Decompiled with CFR 0.152.
 */
package nl.pim16aap2.bigDoors;

import java.util.HashMap;
import java.util.Map;
import nl.pim16aap2.bigDoors.BigDoors;
import nl.pim16aap2.bigDoors.Door;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AutoCloseScheduler {
    private final BigDoors plugin;
    private Map<Long, BukkitTask> timers;

    public AutoCloseScheduler(BigDoors plugin) {
        this.plugin = plugin;
        this.timers = new HashMap<Long, BukkitTask>();
    }

    public boolean isDoorWaiting(long doorUID) {
        return this.timers.containsKey(doorUID);
    }

    private void deleteTimer(long doorUID) {
        if (this.timers.containsKey(doorUID)) {
            this.timers.get(doorUID).cancel();
            this.timers.remove(doorUID);
        }
    }

    public void cancelTimer(long doorUID) {
        this.deleteTimer(doorUID);
    }

    public void scheduleAutoClose(final Door door, final double time, final boolean instantOpen) {
        if (door.getAutoClose() < 0 || !door.isOpen()) {
            return;
        }
        if (door.getAutoClose() > BigDoors.get().getConfigLoader().maxAutoCloseTimer()) {
            BigDoors.get().getMyLogger().warn("Aborted autoCloseTimer for door: " + door.getDoorUID() + ", because it's autoCloseTimer (" + door.getAutoClose() + ") exceeds the global limit (" + BigDoors.get().getConfigLoader().maxAutoCloseTimer() + ").");
            BigDoors.get().getMyLogger().warn("Either change the door's autoCloseTimer or increase the global limit in the config.");
            return;
        }
        this.deleteTimer(door.getDoorUID());
        int delay = Math.max(this.plugin.getMinimumDoorDelay(), door.getAutoClose() * 20);
        this.timers.put(door.getDoorUID(), new BukkitRunnable(){

            public void run() {
                if (door.isOpen()) {
                    if (AutoCloseScheduler.this.plugin.getCommander().isDoorBusy(door.getDoorUID())) {
                        AutoCloseScheduler.this.deleteTimer(door.getDoorUID());
                        this.cancel();
                    } else {
                        AutoCloseScheduler.this.plugin.getDoorOpener(door.getType()).openDoor(AutoCloseScheduler.this.plugin.getCommander().getDoor(null, door.getDoorUID()), time, instantOpen, false);
                    }
                }
                AutoCloseScheduler.this.deleteTimer(door.getDoorUID());
            }
        }.runTaskLater((Plugin)this.plugin, (long)delay));
    }
}

