/*
 * Decompiled with CFR 0.152.
 */
package tld.sima.armorstand.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import tld.sima.armorstand.Main;
import tld.sima.armorstand.events.created.ArmorstandMovedEvent;
import tld.sima.armorstand.utils.VectorEuler;

public class RotationClass {
    private final Main plugin = (Main)Main.getPlugin(Main.class);
    private List<UUID> seenStands;

    public void InsertionDegrees(UUID standuuid, double degrees) {
        this.seenStands = new ArrayList<UUID>();
        this.moveStand(standuuid, degrees, new Vector(0, 0, 0));
    }

    public void moveStand(UUID standuuid, double radians, Vector movement) {
        if (Bukkit.getEntity((UUID)standuuid) == null || radians == 0.0 && movement.equals((Object)new Vector(0, 0, 0))) {
            return;
        }
        Location parentLocation = Bukkit.getEntity((UUID)standuuid).getLocation().clone();
        if (this.plugin.getSmartParent().containsKey(standuuid)) {
            this.seenStands.add(standuuid);
            List<UUID> children = this.plugin.getSmartParent().get(standuuid);
            for (UUID child : children) {
                Location delta;
                Entity childEntity = Bukkit.getEntity((UUID)child);
                if (this.seenStands.contains(child) || childEntity == null) continue;
                if (radians != 0.0) {
                    Location childLocation = childEntity.getLocation();
                    Location vector = childLocation.clone().subtract(parentLocation);
                    VectorEuler euler = new VectorEuler(vector);
                    euler.addRadian(radians * Math.PI / 180.0);
                    Location a = parentLocation.clone().add(euler.getX(), childLocation.getY(), euler.getZ());
                    delta = a.subtract(childLocation);
                } else {
                    delta = new Location(childEntity.getWorld(), 0.0, 0.0, 0.0);
                }
                delta.add(movement);
                this.moveStand(child, radians, delta.toVector());
            }
        } else if (this.plugin.getParentMap().containsKey(standuuid)) {
            this.seenStands.add(standuuid);
            int radius = this.plugin.getParentMap().get(standuuid);
            List entities = Bukkit.getEntity((UUID)standuuid).getNearbyEntities((double)radius, (double)radius, (double)radius);
            for (Entity childEntity : entities) {
                Location delta;
                if (childEntity == null || this.seenStands.contains(childEntity.getUniqueId()) || !childEntity.getType().equals((Object)EntityType.ARMOR_STAND)) continue;
                UUID child = childEntity.getUniqueId();
                if (radians != 0.0) {
                    Location childLocation = childEntity.getLocation();
                    Location vector = childLocation.clone().subtract(parentLocation);
                    VectorEuler euler = new VectorEuler(vector);
                    euler.addRadian(radians * Math.PI / 180.0);
                    Location a = parentLocation.clone().add(euler.getX(), childLocation.getY(), euler.getZ());
                    delta = a.subtract(childLocation);
                } else {
                    delta = new Location(childEntity.getWorld(), 0.0, 0.0, 0.0);
                }
                delta.add(movement);
                this.moveStand(child, radians, delta.toVector());
            }
        }
        parentLocation.add(movement.getX(), 0.0, movement.getZ());
        parentLocation.setYaw(parentLocation.getYaw() + (float)radians);
        ArmorstandMovedEvent ame = new ArmorstandMovedEvent(Bukkit.getEntity((UUID)standuuid), parentLocation, radians != 0.0);
        this.plugin.getServer().getPluginManager().callEvent((Event)ame);
        if (!ame.isCancelled()) {
            Bukkit.getEntity((UUID)standuuid).teleport(parentLocation);
        }
    }
}

