/*
 * Decompiled with CFR 0.152.
 */
package tld.sima.armorstand.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;
import tld.sima.armorstand.Main;

public class CloneClass {
    private final Main plugin = (Main)Main.getPlugin(Main.class);
    private final HashSet<UUID> parentList = new HashSet();

    public UUID CloneStand(ArmorStand stand, Vector delta, UUID worldUUID) {
        boolean loadChunk = false;
        if (!stand.getLocation().getChunk().isLoaded()) {
            stand.getLocation().getChunk().load();
            loadChunk = true;
        }
        UUID uuid = stand.getUniqueId();
        Location newloc = stand.getLocation().clone().add(delta);
        newloc.setWorld(Bukkit.getWorld((UUID)worldUUID));
        ArmorStand newStand = (ArmorStand)newloc.getWorld().spawnEntity(newloc, EntityType.ARMOR_STAND);
        this.copyStandSettings(stand, newStand);
        if (this.plugin.getSmartParent().containsKey(uuid)) {
            this.parentList.add(uuid);
            Collection uuids = this.plugin.getSmartParent().get(uuid);
            ArrayList<UUID> newList = new ArrayList<UUID>();
            for (UUID childuuid : uuids) {
                Entity entity;
                if (this.parentList.contains(childuuid) || (entity = Bukkit.getEntity((UUID)childuuid)) == null) continue;
                newList.add(this.CloneStand((ArmorStand)entity, delta, worldUUID));
            }
            this.plugin.getSmartParent().put(newStand.getUniqueId(), newList);
        } else if (this.plugin.getParentMap().containsKey(uuid)) {
            this.parentList.add(uuid);
            double radius = this.plugin.getParentMap().get(uuid).intValue();
            List entities = stand.getNearbyEntities(radius, radius, radius);
            for (Entity child : entities) {
                if (this.parentList.contains(child.getUniqueId()) || !child.getType().equals((Object)EntityType.ARMOR_STAND)) continue;
                this.CloneStand((ArmorStand)child, delta, worldUUID);
            }
            this.plugin.getParentMap().put(newStand.getUniqueId(), (int)radius);
        }
        if (loadChunk) {
            stand.getLocation().getChunk().unload();
        }
        return newStand.getUniqueId();
    }

    private void copyStandSettings(ArmorStand oldStand, ArmorStand newStand) {
        newStand.setBasePlate(oldStand.hasBasePlate());
        newStand.setLeftLegPose(oldStand.getLeftLegPose());
        newStand.setRightLegPose(oldStand.getRightLegPose());
        newStand.setLeftArmPose(oldStand.getLeftArmPose());
        newStand.setRightArmPose(oldStand.getRightArmPose());
        newStand.setBodyPose(oldStand.getBodyPose());
        newStand.setHeadPose(oldStand.getHeadPose());
        newStand.setCustomName(oldStand.getCustomName());
        if (!newStand.getCustomName().equals("N/A")) {
            newStand.setCustomNameVisible(true);
        } else {
            newStand.setCustomNameVisible(false);
        }
        newStand.getEquipment().setItemInOffHand(oldStand.getEquipment().getItemInOffHand());
        newStand.getEquipment().setItemInMainHand(oldStand.getEquipment().getItemInMainHand());
        newStand.getEquipment().setBoots(oldStand.getEquipment().getBoots());
        newStand.getEquipment().setLeggings(oldStand.getEquipment().getLeggings());
        newStand.getEquipment().setChestplate(oldStand.getEquipment().getChestplate());
        newStand.getEquipment().setHelmet(oldStand.getEquipment().getHelmet());
        newStand.setFireTicks(oldStand.getFireTicks());
        newStand.setGlowing(oldStand.isGlowing());
        newStand.setGravity(oldStand.hasGravity());
        newStand.setSmall(oldStand.isSmall());
        newStand.setVisible(oldStand.isVisible());
        newStand.setArms(oldStand.hasArms());
    }
}

