/*
 * Decompiled with CFR 0.152.
 */
package tld.sima.armorstand.files;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import tld.sima.armorstand.Main;

public class StorageManager {
    private final Main plugin = (Main)Main.getPlugin(Main.class);
    private FileConfiguration storagecfg;
    private File storagefile;

    public void setup() {
        File tmp;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        String FileLocation = this.plugin.getDataFolder().toString() + File.separator + "Storage.yml";
        this.storagefile = tmp = new File(FileLocation);
        if (!this.storagefile.exists()) {
            try {
                this.storagefile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                Bukkit.getServer().getConsoleSender().sendMessage(net.md_5.bungee.api.ChatColor.RED + "Storage file unable to be created!");
            }
        }
        this.storagecfg = YamlConfiguration.loadConfiguration((File)this.storagefile);
        this.createStorageValues();
    }

    private void createStorageValues() {
        this.storagecfg.addDefault("Stands.parent.uuids", new ArrayList());
        this.storagecfg.options().copyDefaults(true);
        this.savecfg();
    }

    private boolean savecfg() {
        try {
            this.storagecfg.save(this.storagefile);
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Unable to save storage file!");
            return false;
        }
        return true;
    }

    public void scanList(Map<UUID, Integer> list) {
        ArrayList<String> strings = new ArrayList<String>();
        for (UUID uuid : list.keySet()) {
            if (Bukkit.getServer().getEntity(uuid) != null) {
                strings.add(uuid.toString());
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.DARK_RED + "Radius of " + (String)strings.get(strings.size() - 1) + ": " + ChatColor.WHITE + list.get(uuid));
                continue;
            }
            Bukkit.getServer().getConsoleSender().sendMessage("Ping");
        }
        ArrayList oldStrings = new ArrayList(this.storagecfg.getStringList("Stands.parent.uuids"));
        this.storagecfg.set("Stands.parent.uuids", new ArrayList(strings));
        for (String string : oldStrings) {
            if (!strings.contains(string)) {
                this.storagecfg.set("Stands." + string, null);
                continue;
            }
            this.storagecfg.set("Stands." + string + ".radius", (Object)list.get(UUID.fromString(string)));
            strings.remove(string);
        }
        for (String string : strings) {
            if (oldStrings.contains(string)) continue;
            this.storagecfg.set("Stands." + string + ".radius", (Object)list.get(UUID.fromString(string)));
        }
        this.savecfg();
    }

    public void checkParentUUID() {
        List check = this.storagecfg.getStringList("Stands.parent.uuids");
        for (String string : check) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.DARK_RED + string);
        }
    }

    public void removeUUID(UUID uuid) {
        List list = this.storagecfg.getStringList("Stands.parent.uuids");
        if (list.contains(uuid.toString())) {
            list.remove(uuid.toString());
            this.storagecfg.set("Stands.parent.uuids", (Object)list);
            this.storagecfg.set("Stands." + uuid.toString(), null);
            this.savecfg();
        }
    }

    public void inputUUID(UUID uuid, int radius) {
        List list = this.storagecfg.getStringList("Stands.parent.uuids");
        list.add(uuid.toString());
        this.storagecfg.set("Stands.parent.uuids", (Object)list);
        this.storagecfg.set("Stands." + uuid.toString() + ".radius", (Object)radius);
        this.savecfg();
    }

    public Map<UUID, Integer> getList() {
        List list = this.storagecfg.getStringList("Stands.parent.uuids");
        HashMap<UUID, Integer> returnList = new HashMap<UUID, Integer>();
        for (String string : list) {
            int radius = this.storagecfg.getInt("Stands." + string + ".radius");
            returnList.put(UUID.fromString(string), radius);
        }
        return returnList;
    }
}

