/*
 * Decompiled with CFR 0.152.
 */
package tld.sima.armorstand.files;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import tld.sima.armorstand.Main;

public class SmartParentStorage {
    private final Main plugin = (Main)Main.getPlugin(Main.class);
    private FileConfiguration maincfg;
    private File mainfile;

    public boolean setup(UUID uuid) {
        String fileName;
        File tmp;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        if (!(tmp = new File(fileName = this.plugin.getDataFolder().toString() + File.separator + "Storage" + File.separator + "SmartParent")).exists()) {
            tmp.mkdirs();
        }
        this.mainfile = new File(fileName, uuid.toString() + ".yml");
        if (!this.mainfile.exists()) {
            try {
                this.mainfile.createNewFile();
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "Config file created");
            }
            catch (IOException e) {
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.RED + "An error has occured creating the main config filefile");
                return false;
            }
        }
        this.maincfg = YamlConfiguration.loadConfiguration((File)this.mainfile);
        this.createMainConfigValues();
        return true;
    }

    private void createMainConfigValues() {
        this.maincfg.addDefault("Parent.UUID", (Object)"");
        this.maincfg.addDefault("Parent.List", Collections.singletonList(""));
        this.maincfg.options().copyDefaults(true);
        this.save();
    }

    public boolean load(File file) {
        this.mainfile = file;
        this.maincfg = YamlConfiguration.loadConfiguration((File)this.mainfile);
        return true;
    }

    private boolean save() {
        try {
            this.maincfg.save(this.mainfile);
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.RED + "unable to add default values to config.");
            return false;
        }
        return true;
    }

    public boolean saveList(List<UUID> list) {
        ArrayList<String> listAsString = new ArrayList<String>();
        for (UUID uuid : list) {
            listAsString.add(uuid.toString());
        }
        this.maincfg.set("Parent.List", listAsString);
        return this.save();
    }

    public boolean saveUUID(UUID uuid) {
        this.maincfg.set("Parent.UUID", (Object)uuid.toString());
        return this.save();
    }

    public boolean saveUUID(Entity entity) {
        return this.saveUUID(entity.getUniqueId());
    }

    public List<UUID> loadList() {
        List listAsString = this.maincfg.getStringList("Parent.List");
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (String string : listAsString) {
            list.add(UUID.fromString(string));
        }
        return list;
    }

    public UUID getUUID() {
        return UUID.fromString(this.maincfg.getString("Parent.UUID"));
    }
}

