/*
 * Decompiled with CFR 0.152.
 */
package tld.sima.armorstand.files;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import tld.sima.armorstand.Main;

public class DefaultSettings {
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private FileConfiguration maincfg;
    private File mainfile;

    public boolean setup() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.mainfile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!this.mainfile.exists()) {
            try {
                this.mainfile.createNewFile();
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "Config file created");
            }
            catch (IOException e) {
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.RED + "An error has occured creating the main config filefile");
                return false;
            }
        }
        this.maincfg = YamlConfiguration.loadConfiguration((File)this.mainfile);
        return this.createMainConfigValues();
    }

    private boolean createMainConfigValues() {
        this.maincfg.addDefault("Settings.removetool.type", (Object)Material.POISONOUS_POTATO.toString());
        this.maincfg.addDefault("Settings.clonetool.type", (Object)Material.STICK.toString());
        this.maincfg.addDefault("Settings.clonetool.name", (Object)"&AClone Tool");
        this.maincfg.addDefault("Settings.clonetool.item-description", (Object)"");
        this.maincfg.addDefault("Settings.parenttool.type", (Object)Material.SLIME_BALL.toString());
        this.maincfg.addDefault("Settings.parenttool.name", (Object)"&AParent Tool");
        this.maincfg.addDefault("Settings.parenttool.item-description", (Object)"");
        this.maincfg.options().copyDefaults(true);
        return this.save();
    }

    private boolean save() {
        try {
            this.maincfg.save(this.mainfile);
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.RED + "unable to add default values to config.");
            return false;
        }
        return true;
    }

    public ItemStack getRemoveTool() {
        Material material = Material.getMaterial((String)this.maincfg.getString("Settings.removetool.type"));
        if (material == null) {
            material = Material.POISONOUS_POTATO;
        }
        return new ItemStack(material);
    }

    public ItemStack getParentTool() {
        Material material = Material.getMaterial((String)this.maincfg.getString("Settings.parenttool.type"));
        if (material == null) {
            material = Material.SLIME_BALL;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.maincfg.getString("Settings.parenttool.name")));
        meta.setLore(Arrays.asList(this.maincfg.getString("Settings.parenttool.item-description").split("[|]")));
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getCloneTool() {
        Material material = Material.getMaterial((String)this.maincfg.getString("Settings.clonetool.type"));
        if (material == null) {
            material = Material.STICK;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.maincfg.getString("Settings.clonetool.name")));
        meta.setLore(Arrays.asList(this.maincfg.getString("Settings.clonetool.item-description")));
        item.setItemMeta(meta);
        return item;
    }
}

