/*
 * Decompiled with CFR 0.152.
 */
package tld.sima.armorstand.events.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import tld.sima.armorstand.Main;
import tld.sima.armorstand.conversations.RadiusConv;
import tld.sima.armorstand.inventories.MainMenuInventory;
import tld.sima.armorstand.inventories.ParentMenuInventory;

public class ParentMenuItemEvents {
    public static final Main plugin = (Main)Main.getPlugin(Main.class);

    public static void parseItem(ItemStack item, Player player, ArmorStand stand) {
        UUID standUUID = stand.getUniqueId();
        String itemName = item.getItemMeta().getDisplayName();
        if (itemName.contains("Set Radius")) {
            player.closeInventory();
            ConversationFactory cf = new ConversationFactory((Plugin)plugin);
            RadiusConv conversation = new RadiusConv();
            conversation.setData(player.getUniqueId(), standUUID, true);
            Conversation conv = cf.withFirstPrompt((Prompt)conversation).withLocalEcho(true).buildConversation((Conversable)player);
            conv.begin();
            plugin.replaceConversation(player.getUniqueId(), conv);
        } else if (itemName.contains("Radius Parent")) {
            if (plugin.getSmartParent().containsKey(standUUID)) {
                plugin.getSmartParent().remove(standUUID);
                plugin.getParentMap().put(standUUID, 1);
                ParentMenuInventory pmi = new ParentMenuInventory();
                pmi.openInventory(player, stand);
            } else if (plugin.getParentMap().containsKey(standUUID)) {
                PotionEffectType type = PotionEffectType.GLOWING;
                PotionEffect potion = new PotionEffect(type, 200, 1);
                int radius = plugin.getParentMap().get(standUUID);
                List entities = stand.getNearbyEntities((double)radius, (double)radius, (double)radius);
                for (Entity entity : entities) {
                    if (!(entity instanceof ArmorStand)) continue;
                    ((ArmorStand)entity).addPotionEffect(potion);
                }
            } else {
                plugin.getSmartParent().remove(standUUID);
                plugin.getParentMap().put(standUUID, 1);
                ParentMenuInventory pmi = new ParentMenuInventory();
                pmi.openInventory(player, stand);
            }
        } else if (itemName.contains("Smart Parent tool")) {
            if (!player.getInventory().contains(plugin.getSmartParentTool())) {
                player.getInventory().addItem(new ItemStack[]{plugin.getSmartParentTool()});
            }
            player.sendMessage(ChatColor.GOLD + "Added tool to inventory");
        } else if (itemName.contains("Remove this stand from being parent")) {
            plugin.getSmartParent().remove(standUUID);
            plugin.getParentMap().remove(standUUID);
            ParentMenuInventory pmi = new ParentMenuInventory();
            pmi.openInventory(player, stand);
        } else if (itemName.contains("Smart Parent")) {
            if (plugin.getSmartParent().containsKey(standUUID)) {
                PotionEffectType type = PotionEffectType.GLOWING;
                PotionEffect potion = new PotionEffect(type, 200, 1);
                List<UUID> uuids = plugin.getSmartParent().get(standUUID);
                for (UUID uuid : uuids) {
                    Entity entity = Bukkit.getEntity((UUID)uuid);
                    if (!(entity instanceof ArmorStand)) continue;
                    ((ArmorStand)entity).addPotionEffect(potion);
                }
            } else if (plugin.getParentMap().containsKey(standUUID)) {
                int radius = plugin.getParentMap().get(standUUID);
                List entities = stand.getNearbyEntities((double)radius, (double)radius, (double)radius);
                ArrayList<UUID> uuids = new ArrayList<UUID>();
                for (Entity entity : entities) {
                    if (!entity.getType().equals((Object)EntityType.ARMOR_STAND)) continue;
                    uuids.add(entity.getUniqueId());
                }
                plugin.getSmartParent().put(standUUID, uuids);
                ParentMenuInventory pmi = new ParentMenuInventory();
                pmi.openInventory(player, stand);
            } else {
                plugin.getSmartParent().put(standUUID, new ArrayList());
                ParentMenuInventory pmi = new ParentMenuInventory();
                pmi.openInventory(player, stand);
            }
        } else if (itemName.contains("Back")) {
            MainMenuInventory mmi = new MainMenuInventory();
            mmi.newInventory(player, stand);
        }
    }
}

