/*
 * Decompiled with CFR 0.152.
 */
package tld.sima.armorstand.events.listeners;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import tld.sima.armorstand.Main;
import tld.sima.armorstand.conversations.MoveStandToPlayerConv;
import tld.sima.armorstand.conversations.MovementConv;
import tld.sima.armorstand.conversations.NameConv;
import tld.sima.armorstand.conversations.RadiusConv;
import tld.sima.armorstand.conversations.RotationConv;
import tld.sima.armorstand.events.created.ArmorstandSelectedEvent;
import tld.sima.armorstand.inventories.MainMenuInventory;
import tld.sima.armorstand.inventories.OptionsMenuInventory;
import tld.sima.armorstand.utils.Pair;

public class OptionsMenuItemEvents {
    public static final Main plugin = (Main)Main.getPlugin(Main.class);

    public static void parseItem(String itemName, Player player, ArmorStand stand) {
        Object conv;
        StringPrompt conversation;
        ConversationFactory cf;
        if (itemName.contains("Back")) {
            ArmorstandSelectedEvent e = new ArmorstandSelectedEvent(player, stand);
            plugin.getServer().getPluginManager().callEvent((Event)e);
            if (!e.isCancelled()) {
                MainMenuInventory i = new MainMenuInventory();
                i.newInventory(player, stand);
            }
            return;
        }
        if (itemName.contains("Delete Stand")) {
            if (plugin.getParentMap().containsKey(stand.getUniqueId())) {
                plugin.getParentMap().remove(stand.getUniqueId());
            }
            player.closeInventory();
            stand.remove();
            player.sendMessage(ChatColor.GOLD + "Stand removed");
        } else if (itemName.contains("Position")) {
            player.closeInventory();
            cf = new ConversationFactory((Plugin)plugin);
            conversation = new MovementConv();
            conversation.setData(player.getUniqueId(), stand.getUniqueId(), false);
            conv = cf.withFirstPrompt((Prompt)conversation).withLocalEcho(true).buildConversation((Conversable)player);
            conv.begin();
            plugin.replaceConversation(player.getUniqueId(), (Conversation)conv);
        } else if (itemName.contains("Rotation")) {
            player.closeInventory();
            cf = new ConversationFactory((Plugin)plugin);
            RotationConv converstaion = new RotationConv();
            converstaion.setData(player.getUniqueId(), stand.getUniqueId(), false, "BODY");
            conv = cf.withFirstPrompt((Prompt)converstaion).withLocalEcho(true).buildConversation((Conversable)player);
            conv.begin();
            plugin.replaceConversation(player.getUniqueId(), (Conversation)conv);
        } else if (itemName.contains("Name")) {
            player.closeInventory();
            cf = new ConversationFactory((Plugin)plugin);
            conversation = new NameConv();
            conversation.setData(player.getUniqueId(), stand.getUniqueId());
            conv = cf.withFirstPrompt((Prompt)conversation).withLocalEcho(true).buildConversation((Conversable)player);
            conv.begin();
            plugin.replaceConversation(player.getUniqueId(), (Conversation)conv);
        } else if (itemName.contains("Set Radius")) {
            player.closeInventory();
            cf = new ConversationFactory((Plugin)plugin);
            conversation = new RadiusConv();
            conversation.setData(player.getUniqueId(), stand.getUniqueId(), false);
            conv = cf.withFirstPrompt((Prompt)conversation).withLocalEcho(true).buildConversation((Conversable)player);
            conv.begin();
            plugin.replaceConversation(player.getUniqueId(), (Conversation)conv);
        } else if (itemName.contains("Move Stand with Player")) {
            player.closeInventory();
            cf = new ConversationFactory((Plugin)plugin);
            conversation = new MoveStandToPlayerConv();
            conversation.setData(player.getUniqueId(), stand.getUniqueId(), false);
            conv = cf.withFirstPrompt((Prompt)conversation).withLocalEcho(true).buildConversation((Conversable)player);
            conv.begin();
            plugin.replaceConversation(player.getUniqueId(), (Conversation)conv);
        } else if (itemName.contains("Clone Stand")) {
            ItemStack tool = new ItemStack(Material.STICK);
            ItemMeta toolMeta = tool.getItemMeta();
            toolMeta.setDisplayName(ChatColor.GREEN + "Clone tool");
            tool.setItemMeta(toolMeta);
            if (!player.getInventory().contains(tool)) {
                player.getInventory().addItem(new ItemStack[]{tool});
            }
            plugin.setClonedStand(player.getUniqueId(), stand);
            player.closeInventory();
        } else if (itemName.contains("Special Clone")) {
            Location loc = stand.getLocation().clone();
            loc.add(0.0, 1.0, 0.0);
            ArmorStand newStand = (ArmorStand)Bukkit.getWorld((UUID)stand.getWorld().getUID()).spawnEntity(loc, EntityType.ARMOR_STAND);
            OptionsMenuItemEvents.copyStandSettings(stand, newStand);
            player.sendMessage(ChatColor.GOLD + "Stand cloned");
        }
        OptionsMenuInventory i = new OptionsMenuInventory();
        if (itemName.contains("Toggle Glow")) {
            boolean flag = false;
            for (Pair pair : plugin.getPairCollection()) {
                if (pair.getLeft() == null || !((ArmorStand)pair.getLeft()).getUniqueId().equals(stand.getUniqueId())) continue;
                flag = true;
                pair.setRight((Boolean)pair.getRight() == false);
                break;
            }
            if (!flag) {
                stand.setGlowing(!stand.isGlowing());
            }
            i.openInventory(player, stand);
        } else if (itemName.contains("Toggle Size")) {
            stand.setSmall(!stand.isSmall());
            i.openInventory(player, stand);
        } else if (itemName.contains("Toggle Invisibility")) {
            stand.setVisible(!stand.isVisible());
            i.openInventory(player, stand);
        } else if (itemName.contains("Toggle Fire")) {
            int fireTicks = stand.getFireTicks();
            if (fireTicks == -1 || fireTicks == 0) {
                stand.setFireTicks(0x7FFFFFFD);
                stand.setInvulnerable(true);
            } else {
                stand.setFireTicks(-1);
            }
            i.openInventory(player, stand);
        } else if (itemName.contains("Toggle Base")) {
            stand.setBasePlate(!stand.hasBasePlate());
            i.openInventory(player, stand);
        } else if (itemName.contains("Toggle Gravity")) {
            stand.setGravity(!stand.hasGravity());
            i.openInventory(player, stand);
        } else if (itemName.contains("Toggle Arms")) {
            stand.setArms(!stand.hasArms());
            i.openInventory(player, stand);
        } else if (itemName.contains("Set Parent")) {
            UUID uuid = stand.getUniqueId();
            if (!plugin.getParentMap().containsKey(uuid)) {
                int radius = 1;
                plugin.getParentMap().put(uuid, radius);
                stand.setVisible(false);
                stand.setCustomNameVisible(false);
                stand.setCustomName("N/A");
                player.getInventory().addItem(new ItemStack[]{stand.getEquipment().getHelmet()});
                player.getInventory().addItem(new ItemStack[]{stand.getEquipment().getChestplate()});
                player.getInventory().addItem(new ItemStack[]{stand.getEquipment().getLeggings()});
                player.getInventory().addItem(new ItemStack[]{stand.getEquipment().getBoots()});
                player.getInventory().addItem(new ItemStack[]{stand.getEquipment().getItemInMainHand()});
                player.getInventory().addItem(new ItemStack[]{stand.getEquipment().getItemInOffHand()});
                stand.getEquipment().setHelmet(new ItemStack(Material.AIR));
                stand.getEquipment().setChestplate(new ItemStack(Material.AIR));
                stand.getEquipment().setLeggings(new ItemStack(Material.AIR));
                stand.getEquipment().setBoots(new ItemStack(Material.AIR));
                stand.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
                stand.getEquipment().setItemInOffHand(new ItemStack(Material.AIR));
                stand.setGravity(false);
                stand.setBasePlate(false);
                stand.setArms(false);
                stand.setSmall(false);
            } else {
                stand.setVisible(true);
                plugin.getParentMap().remove(uuid);
            }
            i.openInventory(player, stand);
        }
    }

    private static void copyStandSettings(ArmorStand oldStand, ArmorStand newStand) {
        newStand.setBasePlate(oldStand.hasBasePlate());
        newStand.setLeftLegPose(oldStand.getLeftLegPose());
        newStand.setRightLegPose(oldStand.getRightLegPose());
        newStand.setLeftArmPose(oldStand.getLeftArmPose());
        newStand.setRightArmPose(oldStand.getRightArmPose());
        newStand.setBodyPose(oldStand.getBodyPose());
        newStand.setHeadPose(oldStand.getHeadPose());
        newStand.setCustomName(oldStand.getCustomName());
        if (!newStand.getCustomName().equals("N/A")) {
            newStand.setCustomNameVisible(true);
        } else {
            newStand.setCustomNameVisible(false);
        }
        newStand.getEquipment().setItemInOffHand(oldStand.getEquipment().getItemInOffHand());
        newStand.getEquipment().setItemInMainHand(oldStand.getEquipment().getItemInMainHand());
        newStand.getEquipment().setBoots(oldStand.getEquipment().getBoots());
        newStand.getEquipment().setLeggings(oldStand.getEquipment().getLeggings());
        newStand.getEquipment().setChestplate(oldStand.getEquipment().getChestplate());
        newStand.getEquipment().setHelmet(oldStand.getEquipment().getHelmet());
        newStand.setFireTicks(oldStand.getFireTicks());
        newStand.setGlowing(oldStand.isGlowing());
        newStand.setGravity(oldStand.hasGravity());
        newStand.setSmall(oldStand.isSmall());
        newStand.setVisible(oldStand.isVisible());
    }
}

