/*
 * Decompiled with CFR 0.152.
 */
package tld.sima.armorstand.events.listeners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import tld.sima.armorstand.Main;
import tld.sima.armorstand.conversations.MovementConv;
import tld.sima.armorstand.conversations.NameConv;
import tld.sima.armorstand.conversations.RotationConv;
import tld.sima.armorstand.events.created.ArmorstandClonedEvent;
import tld.sima.armorstand.events.created.ArmorstandRemovedEvent;
import tld.sima.armorstand.events.created.ArmorstandSelectedEvent;
import tld.sima.armorstand.inventories.MainMenuInventory;
import tld.sima.armorstand.utils.CloneClass;
import tld.sima.armorstand.utils.ToolType;

public class EventManager
implements Listener {
    private final Main plugin = (Main)Main.getPlugin(Main.class);
    Set<UUID> delay = new HashSet<UUID>();

    @EventHandler
    public void onLogin(PlayerLoginEvent event) {
        this.plugin.setupPlayerData(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void leftClicked(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof ArmorStand && event.getDamager() instanceof Player && (event.getDamager().hasPermission("Armorstand.atool") || event.getDamager().hasPermission("Armorstand.break") || event.getDamager().hasPermission("Armorstand.smartparenttool") || event.getDamager().isOp())) {
            Player player = (Player)event.getDamager();
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand.isSimilar(this.plugin.getRemoveTool()) && (player.hasPermission("Armorstand.break") || event.getDamager().isOp())) {
                event.setCancelled(true);
                ArmorStand stand = (ArmorStand)event.getEntity();
                UUID standUUID = stand.getUniqueId();
                ArmorstandRemovedEvent are = new ArmorstandRemovedEvent(standUUID);
                this.plugin.getServer().getPluginManager().callEvent((Event)are);
                this.plugin.getParentMap().remove(standUUID);
                this.plugin.getSmartParent().remove(standUUID);
                for (UUID uuid : this.plugin.getSmartParent().keySet()) {
                    this.plugin.getSmartParent().get(uuid).remove(standUUID);
                }
                stand.remove();
                return;
            }
            if (this.plugin.isArmorstandCustomTool(player.getUniqueId(), itemInHand) && (player.hasPermission("Armorstand.atool") || event.getDamager().isOp())) {
                event.setCancelled(true);
                ToolType type = this.plugin.getArmorstandToolType(player.getUniqueId());
                ArmorStand mainStand = (ArmorStand)event.getEntity();
                ArrayList<ArmorStand> affectedLists = new ArrayList<ArmorStand>();
                affectedLists.add(mainStand);
                double fuzzyRadius = this.plugin.getFuzzyToolRadius(player.getUniqueId());
                if (fuzzyRadius > 0.1) {
                    for (Entity entity : mainStand.getNearbyEntities(fuzzyRadius, fuzzyRadius * 2.0, fuzzyRadius)) {
                        if (!(entity instanceof ArmorStand)) continue;
                        affectedLists.add((ArmorStand)entity);
                    }
                }
                switch (type) {
                    case GRAVITY: {
                        boolean flag = !mainStand.hasGravity();
                        for (ArmorStand stand : affectedLists) {
                            stand.setGravity(flag);
                        }
                        break;
                    }
                    case SIZE: {
                        boolean flag = !mainStand.isSmall();
                        for (ArmorStand stand : affectedLists) {
                            stand.setSmall(flag);
                        }
                        break;
                    }
                    case INVISIBLE: {
                        boolean flag = !mainStand.isVisible();
                        for (ArmorStand stand : affectedLists) {
                            stand.setVisible(flag);
                        }
                        break;
                    }
                    case FIRE: {
                        int fireTicks = mainStand.getFireTicks();
                        boolean flag = fireTicks == -1 || fireTicks == 0;
                        for (ArmorStand stand : affectedLists) {
                            if (flag) {
                                stand.setFireTicks(0x7FFFFFFD);
                                stand.setInvulnerable(true);
                                continue;
                            }
                            stand.setFireTicks(-1);
                        }
                        break;
                    }
                    case BASE: {
                        boolean flag = !mainStand.hasBasePlate();
                        for (ArmorStand stand : affectedLists) {
                            stand.setBasePlate(flag);
                        }
                        break;
                    }
                    case ARMS: {
                        boolean flag = !mainStand.hasArms();
                        for (ArmorStand stand : affectedLists) {
                            stand.setArms(flag);
                        }
                        break;
                    }
                    case GLOW: {
                        boolean flag = !mainStand.isGlowing();
                        for (ArmorStand stand : affectedLists) {
                            stand.setGlowing(flag);
                        }
                        break;
                    }
                    case NAME: {
                        this.plugin.setPairedStand(player.getUniqueId(), mainStand);
                        ConversationFactory cf = new ConversationFactory((Plugin)this.plugin);
                        NameConv conversation = new NameConv();
                        conversation.setData(player.getUniqueId(), mainStand.getUniqueId());
                        Conversation conv = cf.withFirstPrompt((Prompt)conversation).withLocalEcho(true).buildConversation((Conversable)player);
                        conv.begin();
                        this.plugin.replaceConversation(player.getUniqueId(), conv);
                        break;
                    }
                    case ROTATION: {
                        this.plugin.setPairedStand(player.getUniqueId(), mainStand);
                        ConversationFactory cf = new ConversationFactory((Plugin)this.plugin);
                        RotationConv conversation = new RotationConv();
                        conversation.setData(player.getUniqueId(), mainStand.getUniqueId(), true, "BODY");
                        Conversation conv = cf.withFirstPrompt((Prompt)conversation).withLocalEcho(true).buildConversation((Conversable)player);
                        conv.begin();
                        this.plugin.replaceConversation(player.getUniqueId(), conv);
                        break;
                    }
                    case MOVE: {
                        this.plugin.setPairedStand(player.getUniqueId(), mainStand);
                        ConversationFactory cf = new ConversationFactory((Plugin)this.plugin);
                        MovementConv conversation = new MovementConv();
                        conversation.setData(player.getUniqueId(), mainStand.getUniqueId(), true);
                        Conversation conv = cf.withFirstPrompt((Prompt)conversation).withLocalEcho(true).buildConversation((Conversable)player);
                        conv.begin();
                        this.plugin.replaceConversation(player.getUniqueId(), conv);
                        break;
                    }
                }
                return;
            }
            if (itemInHand.isSimilar(this.plugin.getSmartParentTool()) && (player.hasPermission("Armorstand.smartparenttool") || event.getDamager().isOp())) {
                event.setCancelled(true);
                ArmorStand parentStand = this.plugin.getPairedStand(player.getUniqueId());
                if (parentStand == null) {
                    return;
                }
                ArmorStand entity = (ArmorStand)event.getEntity();
                if (this.plugin.getSmartParent().containsKey(parentStand.getUniqueId())) {
                    if (entity.getUniqueId().equals(parentStand.getUniqueId())) {
                        return;
                    }
                    List<UUID> list = this.plugin.getSmartParent().get(parentStand.getUniqueId());
                    if (list.contains(entity.getUniqueId())) {
                        list.remove(entity.getUniqueId());
                        this.plugin.getSmartParent().put(parentStand.getUniqueId(), list);
                        player.sendMessage(ChatColor.WHITE + "Stand " + ChatColor.RED + "removed" + ChatColor.WHITE + " from parent map");
                    } else {
                        list.add(entity.getUniqueId());
                        this.plugin.getSmartParent().put(parentStand.getUniqueId(), list);
                        PotionEffectType type = PotionEffectType.GLOWING;
                        PotionEffect potion = new PotionEffect(type, 60, 1);
                        entity.addPotionEffect(potion);
                        player.sendMessage(ChatColor.WHITE + "Stand " + ChatColor.GREEN + "added" + ChatColor.WHITE + " to parent map");
                    }
                }
                return;
            }
        }
        if (this.plugin.getProtectedStands().contains(event.getEntity().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof ArmorStand && this.plugin.getProtectedStands().contains(event.getEntity().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onStandDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof ArmorStand) {
            ArmorstandRemovedEvent e = new ArmorstandRemovedEvent(event.getEntity().getUniqueId());
            this.plugin.getServer().getPluginManager().callEvent((Event)e);
        }
    }

    @EventHandler
    public void onPlace(EntitySpawnEvent event) {
        if (event.getEntity() instanceof ArmorStand) {
            ArmorStand stand = (ArmorStand)event.getEntity();
            stand.setHeadPose(stand.getHeadPose().setX(0.0).setY(0.0).setZ(0.0));
            stand.setBodyPose(stand.getBodyPose().setX(0.0).setY(0.0).setZ(0.0));
            stand.setCustomNameVisible(false);
            stand.setGravity(false);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onRightClick(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && player.hasPermission("armorstand.clone") && player.getInventory().getItemInMainHand().isSimilar(this.plugin.getCloneTool()) && !this.delay.contains(player.getUniqueId())) {
            this.delay.add(player.getUniqueId());
            new BukkitRunnable(){

                public void run() {
                    EventManager.this.delay.remove(player.getUniqueId());
                }
            }.runTaskLater((Plugin)this.plugin, 10L);
            if (this.plugin.getClonedStand(player.getUniqueId()) != null) {
                ArmorStand oldStand = this.plugin.getClonedStand(player.getUniqueId());
                Location loc = event.getClickedBlock().getLocation().clone();
                loc.add(0.5, 1.0, 0.5);
                Vector delta = loc.clone().toVector().subtract(oldStand.getLocation().clone().toVector());
                UUID worldUUID = event.getClickedBlock().getWorld().getUID();
                ArmorstandClonedEvent e = new ArmorstandClonedEvent(player, oldStand, delta, worldUUID);
                this.plugin.getServer().getPluginManager().callEvent((Event)e);
                if (!e.isCancelled()) {
                    CloneClass cc = new CloneClass();
                    cc.CloneStand(oldStand, delta, worldUUID);
                    player.sendMessage(ChatColor.GREEN + "Armorstand(s) cloned!");
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onRightClickStand(PlayerInteractAtEntityEvent event) {
        Player player = event.getPlayer();
        if (event.getRightClicked() instanceof ArmorStand) {
            if (player.hasPermission("stand.interact") || player.hasPermission("armorstand.interact")) {
                event.setCancelled(true);
                ArmorStand stand = (ArmorStand)event.getRightClicked();
                ArmorstandSelectedEvent e = new ArmorstandSelectedEvent(player, stand);
                this.plugin.getServer().getPluginManager().callEvent((Event)e);
                if (!e.isCancelled()) {
                    MainMenuInventory i = new MainMenuInventory();
                    i.newInventory(player, stand);
                }
                this.plugin.setPairedStand(player.getUniqueId(), stand);
            } else if (this.plugin.getProtectedStands().contains(event.getRightClicked().getUniqueId())) {
                event.setCancelled(true);
            }
        }
    }
}

