/*
 * Decompiled with CFR 0.152.
 */
package tld.sima.armorstand;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.conversations.Conversation;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.RayTraceResult;
import tld.sima.armorstand.API;
import tld.sima.armorstand.commands.ToolCommandManager;
import tld.sima.armorstand.commands.WorldInteractionCommandManger;
import tld.sima.armorstand.events.listeners.EventManager;
import tld.sima.armorstand.events.listeners.InventoryEventManager;
import tld.sima.armorstand.files.ProtectedStands;
import tld.sima.armorstand.files.SmartParentStorage;
import tld.sima.armorstand.files.StorageManager;
import tld.sima.armorstand.utils.ItemHub;
import tld.sima.armorstand.utils.Pair;
import tld.sima.armorstand.utils.PlayerData;
import tld.sima.armorstand.utils.ToolType;

public class Main
extends JavaPlugin {
    private final Map<UUID, PlayerData> playerData = new HashMap<UUID, PlayerData>();
    private final Set<UUID> playersScanning = Collections.synchronizedSet(new LinkedHashSet());
    private Set<UUID> protectedStands;
    private ItemHub itemHub;
    private final Map<UUID, List<UUID>> smartParent = new HashMap<UUID, List<UUID>>();
    private Map<UUID, Integer> parentList;
    private StorageManager stmgr;
    private BukkitTask scanStand;
    private Map<UUID, Pair<ArmorStand, Boolean>> previousScannedStand;
    private API api;
    public boolean AnimationActive = false;

    public void onEnable() {
        File[] files;
        String fileName;
        File dir;
        this.getServer().getPluginManager().registerEvents((Listener)new EventManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryEventManager(), (Plugin)this);
        this.stmgr = new StorageManager();
        this.stmgr.setup();
        this.parentList = this.stmgr.getList();
        this.protectedStands = ProtectedStands.getList();
        if (Bukkit.getServer().getPluginManager().getPlugin("ArmorstandAnimationPlugin") != null) {
            this.AnimationActive = true;
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "Detected Armour stands animations.");
        }
        if (!(dir = new File(fileName = this.getDataFolder().toString() + File.separator + "Storage" + File.separator + "SmartParent")).exists()) {
            dir.mkdirs();
        }
        File[] fileArray = files = dir.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            SmartParentStorage sps = new SmartParentStorage();
            File file = fileArray[i];
            if (!sps.load(file)) continue;
            this.smartParent.put(sps.getUUID(), sps.loadList());
            StringBuilder builder = new StringBuilder();
            List<UUID> uuids = sps.loadList();
            if (uuids.size() > 0) {
                builder.append(ChatColor.GREEN).append("Child parents: ").append(ChatColor.WHITE).append(uuids.get(0));
                for (int i2 = 1; i2 < uuids.size(); ++i2) {
                    builder.append(", ").append(uuids.get(i2));
                }
            }
            Bukkit.getServer().getConsoleSender().sendMessage(builder.toString());
        }
        this.itemHub = new ItemHub();
        ToolCommandManager tcm = new ToolCommandManager();
        this.getCommand(tcm.cmd1).setExecutor((CommandExecutor)tcm);
        this.getCommand(tcm.cmd1).setTabCompleter((TabCompleter)tcm);
        WorldInteractionCommandManger wicm = new WorldInteractionCommandManger();
        this.getCommand(wicm.cmd1).setExecutor((CommandExecutor)wicm);
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.playerData.put(player.getUniqueId(), new PlayerData());
        }
        this.previousScannedStand = new HashMap<UUID, Pair<ArmorStand, Boolean>>();
        this.scanStand = new BukkitRunnable(){

            public void run() {
                Iterator iter = Main.this.playersScanning.iterator();
                HashSet<UUID> interactedStands = new HashSet<UUID>();
                while (iter.hasNext()) {
                    Entity e;
                    UUID pUUID = (UUID)iter.next();
                    Pair pair = (Pair)Main.this.previousScannedStand.get(pUUID);
                    Player p = (Player)Bukkit.getEntity((UUID)pUUID);
                    if (p == null) {
                        if (pair != null && pair.getLeft() != null) {
                            ((ArmorStand)pair.getLeft()).setGlowing(((Boolean)pair.getRight()).booleanValue());
                        }
                        Main.this.previousScannedStand.remove(pUUID);
                        iter.remove();
                        continue;
                    }
                    RayTraceResult rayTraceResult = p.getWorld().rayTraceEntities(p.getEyeLocation(), p.getEyeLocation().getDirection(), 4.0, entity -> entity instanceof ArmorStand);
                    if (rayTraceResult != null && (e = rayTraceResult.getHitEntity()) instanceof ArmorStand) {
                        if (interactedStands.contains(e.getUniqueId())) continue;
                        interactedStands.add(e.getUniqueId());
                        if (pair == null) {
                            Main.this.previousScannedStand.put(pUUID, new Pair<ArmorStand, Boolean>((ArmorStand)e, e.isGlowing()));
                            e.setGlowing(true);
                            continue;
                        }
                        if (((ArmorStand)pair.getLeft()).getUniqueId().equals(e.getUniqueId())) continue;
                        if (pair.getLeft() != null) {
                            ((ArmorStand)pair.getLeft()).setGlowing(((Boolean)pair.getRight()).booleanValue());
                        }
                        Main.this.previousScannedStand.put(pUUID, new Pair<ArmorStand, Boolean>((ArmorStand)e, e.isGlowing()));
                        e.setGlowing(true);
                        continue;
                    }
                    if (pair != null && pair.getLeft() != null) {
                        ((ArmorStand)pair.getLeft()).setGlowing(((Boolean)pair.getRight()).booleanValue());
                    }
                    Main.this.previousScannedStand.remove(pUUID);
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 5L);
        this.api = new API();
        this.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "Armorstand API Enabled.");
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.playerData.get(player.getUniqueId()).abandonConversation();
        }
        for (UUID uuid : this.smartParent.keySet()) {
            SmartParentStorage sps = new SmartParentStorage();
            sps.setup(uuid);
            sps.saveUUID(uuid);
            sps.saveList(this.smartParent.get(uuid));
        }
        ProtectedStands.saveList(this.protectedStands);
        this.stmgr.scanList(this.parentList);
        this.scanStand.cancel();
        this.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "Armorstand API Disabled.");
    }

    public Conversation getConv(UUID uuid) {
        return this.playerData.get(uuid).getCurrentConversation();
    }

    public void replaceConversation(UUID uuid, Conversation conversation) {
        this.playerData.get(uuid).replaceCurrentConversation(conversation);
    }

    public boolean addRemoveToPlayerScanningSet(UUID pUUID) {
        if (this.playersScanning.contains(pUUID)) {
            this.playersScanning.remove(pUUID);
            Pair<ArmorStand, Boolean> pair = this.previousScannedStand.get(pUUID);
            if (pair != null && pair.getLeft() != null) {
                pair.getLeft().setGlowing(pair.getRight().booleanValue());
            }
            this.previousScannedStand.remove(pUUID);
            return false;
        }
        this.playersScanning.add(pUUID);
        return true;
    }

    public Collection<Pair<ArmorStand, Boolean>> getPairCollection() {
        return this.previousScannedStand.values();
    }

    public ArmorStand getPairedStand(UUID uuid) {
        return this.playerData.get(uuid).getPairedStand();
    }

    public void setPairedStand(UUID uuid, ArmorStand stand) {
        this.playerData.get(uuid).setPairedStand(stand);
    }

    public Map<UUID, Integer> getParentMap() {
        return this.parentList;
    }

    public ArmorStand getClonedStand(UUID uuid) {
        return this.playerData.get(uuid).getClonedStand();
    }

    public void setClonedStand(UUID uuid, ArmorStand cloned) {
        this.playerData.get(uuid).setClonedStand(cloned);
    }

    public ItemStack getRemoveTool() {
        return this.itemHub.getRemoveTool();
    }

    public ItemStack getCloneTool() {
        return this.itemHub.getCloneTool();
    }

    public ItemStack getSmartParentTool() {
        return this.itemHub.getSmartParentTool();
    }

    public API getAPI() {
        return this.api;
    }

    public double getFuzzyToolRadius(UUID uuid) {
        return this.playerData.get(uuid).getCustomArmorstandTool().getFuzzyRadius();
    }

    public void setFuzzyToolRadius(UUID uuid, double radius) {
        this.playerData.get(uuid).setFuzzyRadius(radius);
    }

    public boolean isArmorstandCustomTool(UUID uuid, ItemStack item) {
        return this.playerData.get(uuid).getCustomArmorstandTool().isTool(item);
    }

    public ToolType getArmorstandToolType(UUID uuid) {
        return this.playerData.get(uuid).getToolType();
    }

    public void setArmorstandCustomTool(UUID uuid, ItemStack newTool) {
        this.playerData.get(uuid).getCustomArmorstandTool().setTool(newTool);
    }

    public void setArmorstandCustomToolType(UUID uuid, ToolType tooltype) {
        this.playerData.get(uuid).setToolType(tooltype);
    }

    public void setArmorstandTool(UUID uuid, ItemStack newTool, ToolType tooltype) {
        this.playerData.get(uuid).setArmorstandTool(newTool, tooltype);
    }

    public Map<UUID, List<UUID>> getSmartParent() {
        return this.smartParent;
    }

    public PlayerData getPlayerData(UUID uuid) {
        return this.playerData.get(uuid);
    }

    public void setupPlayerData(UUID uuid) {
        if (!this.playerData.containsKey(uuid)) {
            this.playerData.put(uuid, new PlayerData());
        }
    }

    public ItemStack createItem(ItemStack item, String disName, List<String> loreList) {
        ItemMeta itemM = item.getItemMeta();
        if (itemM != null) {
            if (!disName.equals("")) {
                itemM.setDisplayName(disName);
            }
            if (!loreList.isEmpty()) {
                itemM.setLore(loreList);
            }
            itemM.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            itemM.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemM.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            item.setItemMeta(itemM);
        }
        return item;
    }

    public Set<UUID> getProtectedStands() {
        return this.protectedStands;
    }
}

