/*
 * Decompiled with CFR 0.152.
 */
package co.tobiassteely.sleezy.Checks;

import co.tobiassteely.sleezy.API.ConfigAPI;
import co.tobiassteely.sleezy.API.PlaytimeAPI;
import co.tobiassteely.sleezy.Checks.IPCheck;
import co.tobiassteely.sleezy.Main;
import java.util.List;
import me.egg82.antivpn.APIException;
import me.egg82.antivpn.ExternalAPI;
import org.bukkit.entity.Player;

public class PlayerCheck {
    private Player p;
    private String ip;
    private ConfigAPI c = new ConfigAPI();
    private double threatLevel;

    public PlayerCheck(Player p, String ip) {
        this.p = p;
        this.ip = ip;
        this.threatLevel = this.checkPlayer();
    }

    public double checkPlayer() {
        IPCheck ipCheck;
        List<String> accounts;
        double totalThreatLevel = 0.0;
        double ipThreatLevel = 0.0;
        double joinThreatLevel = 0.0;
        if (((Boolean)this.c.get("config.yml", "verbose")).booleanValue()) {
            Main.getInstance().getLogger().info("VERBOSE: player " + this.p.getDisplayName() + " (" + this.p.getUniqueId() + ")");
            Main.getInstance().getLogger().info("VERBOSE: ip " + this.ip);
        }
        if ((accounts = (ipCheck = new IPCheck(this.p, this.ip)).getAccounts()).size() > (Integer)this.c.get("config.yml", "account-limit")) {
            ipThreatLevel = 1000.0;
            if (((Boolean)this.c.get("config.yml", "verbose")).booleanValue()) {
                Main.getInstance().getLogger().info("VERBOSE: ipThreatLevel (1) " + ipThreatLevel);
            }
        } else {
            ipThreatLevel += (double)(accounts.size() * accounts.size()) * (Double)this.c.get("settings.yml", "alt-multiplier");
            if (((Boolean)this.c.get("config.yml", "verbose")).booleanValue()) {
                Main.getInstance().getLogger().info("VERBOSE: ipThreatLevel (1) " + ipThreatLevel);
            }
            ipThreatLevel += ipCheck.VPNStatus() * (Double)this.c.get("settings.yml", "vpn-multiplier");
            ipThreatLevel -= 1.0;
            if (((Boolean)this.c.get("config.yml", "verbose")).booleanValue()) {
                Main.getInstance().getLogger().info("VERBOSE: ipThreatLevel (2) " + ipThreatLevel);
            }
        }
        PlaytimeAPI pt = new PlaytimeAPI(this.p, false);
        int playtime = (int)pt.getPlaytime().longValue() / 60000;
        int recentPlayers = Main.getInstance().jc.getPlayers();
        double multiplier = (Double)this.c.get("settings.yml", "join-multiplier");
        joinThreatLevel += multiplier * (double)(recentPlayers * recentPlayers) / (double)(playtime + 1);
        if (((Boolean)this.c.get("config.yml", "verbose")).booleanValue()) {
            Main.getInstance().getLogger().info("VERBOSE: ipThreatLevel(F) " + ipThreatLevel);
            Main.getInstance().getLogger().info("VERBOSE: recent players " + recentPlayers);
            Main.getInstance().getLogger().info("VERBOSE: joinThreatLevel(1) " + recentPlayers * recentPlayers);
            Main.getInstance().getLogger().info("VERBOSE: joinThreatLevel(F) " + joinThreatLevel);
            Main.getInstance().getLogger().info("VERBOSE: playtime " + playtime + "M");
            Main.getInstance().getLogger().info("VERBOSE: playtime " + pt.getPlaytime());
        }
        totalThreatLevel += ipThreatLevel;
        if ((totalThreatLevel += (double)((int)joinThreatLevel)) > (double)((Integer)this.c.get("settings.yml", "lockdown-level")).intValue()) {
            Main.getInstance().l.startLockdown((Integer)this.c.get("settings.yml", "lockdown-time"));
        }
        return totalThreatLevel;
    }

    public List<String> getAccounts() {
        IPCheck ipCheck = new IPCheck(this.p, this.ip);
        return ipCheck.getAccounts();
    }

    public double getThreatLevel() {
        return this.threatLevel;
    }

    public boolean hasVPN() {
        ExternalAPI api = ExternalAPI.getInstance();
        try {
            return api.cascade(this.ip);
        }
        catch (APIException ex) {
            System.out.println("Warn: Anti-VPN threw an error. (Cascade) Assuming player is not using VPN.");
            return false;
        }
    }

    public boolean isThreat() {
        return !(this.threatLevel > (double)((Integer)this.c.get("settings.yml", "threshold")).intValue());
    }
}

