/*
 * Decompiled with CFR 0.152.
 */
package co.tobiassteely.sleezy.API;

import co.tobiassteely.sleezy.Main;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlaytimeAPI {
    private static HashMap<Player, File> playerFiles = new HashMap();
    private static HashMap<Player, FileConfiguration> player = new HashMap();
    private static HashMap<Player, Long> joinTime = new HashMap();
    private Player p;
    private UUID u;

    public PlaytimeAPI(Player p, boolean isJoin) {
        this.p = p;
        this.u = p.getUniqueId();
        this.loadPlayer();
        if (isJoin) {
            joinTime.put(p, System.currentTimeMillis());
        }
    }

    public Long getPlaytime() {
        long join = joinTime.get(this.p);
        long playtime = ((Integer)player.get(this.p).get("playtime")).intValue();
        return playtime += System.currentTimeMillis() - join;
    }

    public FileConfiguration getPlayerConfig(Player p) {
        return player.get(p);
    }

    public boolean doesExist() {
        return playerFiles.get(this.p).exists();
    }

    public boolean loadFile() {
        try {
            player.get(this.p).load(playerFiles.get(this.p));
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            return false;
        }
    }

    public void create() {
        Main.getInstance().getLogger().info("Player does not exist, creating player: " + this.p.getDisplayName() + " (" + this.u + ")");
        playerFiles.get(this.p).getParentFile().mkdir();
        this.loadFile();
        this.set("playtime", 0);
        this.save();
    }

    public void loadPlayer() {
        playerFiles.put(this.p, new File(Main.getInstance().getDataFolder() + "/PlaytimeData/", this.u + ".yml"));
        Main.getInstance().getLogger().info("Loading player: " + this.p.getDisplayName() + " (" + this.u + ")");
        player.put(this.p, (FileConfiguration)new YamlConfiguration());
        if (!this.doesExist()) {
            this.create();
        } else {
            this.loadFile();
        }
    }

    public void save() {
        try {
            player.get(this.p).save(playerFiles.get(this.p));
            Main.getInstance().getLogger().info("Saving player: " + this.p.getDisplayName() + " (" + this.u + ")");
        }
        catch (IOException e) {
            Main.getInstance().getLogger().info("Failed to save player \"" + this.p.getDisplayName() + "\" (" + this.u + ")");
        }
    }

    public void set(String t, Object v) {
        player.get(this.p).set(t, v);
    }

    public Object get(String t) {
        return player.get(this.p).get(t);
    }

    public void reload() {
        player.put(this.p, (FileConfiguration)YamlConfiguration.loadConfiguration((File)playerFiles.get(this.p)));
    }

    public void unload() {
        long join = joinTime.get(this.p);
        long playtime = ((Integer)player.get(this.p).get("playtime")).intValue();
        this.set("playtime", playtime += System.currentTimeMillis() - join);
        this.save();
        playerFiles.remove(this.p);
        player.remove(this.p);
    }
}

