/*
 * Decompiled with CFR 0.152.
 */
package co.tobiassteely.sleezy.API;

import co.tobiassteely.sleezy.Main;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigAPI {
    private static HashMap<String, File> configFiles = new HashMap();
    private static HashMap<String, FileConfiguration> configs = new HashMap();

    public FileConfiguration getConfig(String c) {
        return configs.get(c);
    }

    public void loadConfig(String c) {
        configFiles.put(c, new File(Main.getInstance().getDataFolder(), c));
        if (!this.doesExist(c)) {
            configFiles.get(c).getParentFile().mkdirs();
            Main.getInstance().saveResource(c, false);
        }
        configs.put(c, (FileConfiguration)new YamlConfiguration());
        this.loadFile(c);
    }

    public List getList(String c, String t) {
        return configs.get(c).getStringList(t);
    }

    public void setList(String c, String t, String v) {
        List list = configs.get(c).getStringList(t);
        list.add(v);
        configs.get(c).set(t, (Object)list);
    }

    public void save(String c) {
        try {
            configs.get(c).save(configFiles.get(c));
        }
        catch (IOException e) {
            Main.getInstance().getLogger().info("Failed to save file \"" + c + " \"");
        }
    }

    public void reloadConfig(String c) {
        configs.put(c, (FileConfiguration)YamlConfiguration.loadConfiguration((File)configFiles.get(c)));
    }

    public void set(String c, String t, Object v) {
        configs.get(c).set(t, v);
    }

    public Object get(String c, String t) {
        return configs.get(c).get(t);
    }

    private boolean doesExist(String c) {
        return configFiles.get(c).exists();
    }

    private boolean loadFile(String c) {
        try {
            configs.get(c).load(configFiles.get(c));
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            return false;
        }
    }

    public void reloadAll() {
        for (Map.Entry<String, File> entry : configFiles.entrySet()) {
            this.loadFile(entry.getKey());
        }
    }
}

