/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.nbt;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import masecla.AutoPickupPlus.mlib.apis.CompatibilityAPI;
import masecla.AutoPickupPlus.mlib.apis.NMSAPI;
import masecla.AutoPickupPlus.mlib.nbt.tags.BooleanTag;
import masecla.AutoPickupPlus.mlib.nbt.tags.CompoundTag;
import masecla.AutoPickupPlus.mlib.nbt.tags.IntTag;
import masecla.AutoPickupPlus.mlib.nbt.tags.StringTag;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class TagReader {
    private Map<String, CompoundTag> knownTags = new HashMap<String, CompoundTag>();
    private NMSAPI nmsapi;
    private CompatibilityAPI compapi;
    private boolean isItem;
    private Object nmsObject;
    private static Method itemStack_getTag;
    private static Method entity_getTag;
    private static Method getInt;
    private static Method getString;
    private static Method getBoolean;
    private static boolean initialized;

    public TagReader(CompatibilityAPI compapi, NMSAPI nmsapi, ItemStack itemStack) {
        this.nmsapi = nmsapi;
        this.compapi = compapi;
        this.nmsObject = nmsapi.convertToNMSItemStack(itemStack);
        this.initializeMethods();
        this.isItem = true;
    }

    public TagReader(CompatibilityAPI compapi, NMSAPI nmsapi, Entity entity) {
        this.nmsapi = nmsapi;
        this.compapi = compapi;
        this.nmsObject = nmsapi.convertToNMSEntity(entity);
        this.initializeMethods();
        this.isItem = false;
    }

    public void initializeMethods() {
        if (!initialized) {
            initialized = true;
            try {
                Class<?> nbtTagCompoundClass = null;
                nbtTagCompoundClass = this.compapi.getServerVersion().getMajor() <= 16 ? this.nmsapi.getNMSClass("NBTTagCompound") : Class.forName("net.minecraft.nbt.NBTTagCompound");
                if (this.compapi.getServerVersion().getMajor() <= 17) {
                    getInt = nbtTagCompoundClass.getDeclaredMethod("getInt", String.class);
                    getString = nbtTagCompoundClass.getDeclaredMethod("getString", String.class);
                    getBoolean = nbtTagCompoundClass.getDeclaredMethod("getBoolean", String.class);
                } else {
                    getInt = nbtTagCompoundClass.getDeclaredMethod("h", String.class);
                    getString = nbtTagCompoundClass.getDeclaredMethod("l", String.class);
                    getBoolean = nbtTagCompoundClass.getDeclaredMethod("b", String.class);
                }
                Class<?> itemClass = null;
                itemClass = this.compapi.getServerVersion().getMajor() <= 16 ? this.nmsapi.getNMSClass("ItemStack") : Class.forName("net.minecraft.world.item.ItemStack");
                itemStack_getTag = this.compapi.getServerVersion().getMajor() <= 17 ? itemClass.getDeclaredMethod("getTag", new Class[0]) : (this.compapi.getServerVersion().getMajor() <= 18 ? (this.compapi.getServerVersion().getMinor() >= 2 ? itemClass.getDeclaredMethod("t", new Class[0]) : itemClass.getDeclaredMethod("s", new Class[0])) : itemClass.getDeclaredMethod("v", new Class[0]));
                Class<?> entityClass = null;
                entityClass = this.compapi.getServerVersion().getMajor() <= 16 ? this.nmsapi.getNMSClass("Entity") : Class.forName("net.minecraft.world.entity.Entity");
                entity_getTag = this.compapi.getServerVersion().getMajor() >= 8 && this.compapi.getServerVersion().getMajor() <= 15 ? entityClass.getDeclaredMethod("c", nbtTagCompoundClass) : (this.compapi.getServerVersion().getMajor() == 16 ? entityClass.getDeclaredMethod("a_", nbtTagCompoundClass) : (this.compapi.getServerVersion().getMajor() == 17 ? entityClass.getDeclaredMethod("d", nbtTagCompoundClass) : entityClass.getDeclaredMethod("f", nbtTagCompoundClass)));
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public IntTag getInt(String name) {
        if (this.nmsObject == null) {
            return null;
        }
        return (IntTag)this.knownTags.computeIfAbsent(name, c -> {
            try {
                if (this.isItem) {
                    Object compound = itemStack_getTag.invoke(this.nmsObject, new Object[0]);
                    if (compound == null) {
                        return new IntTag(name, null);
                    }
                    return new IntTag(name, (int)((Integer)getInt.invoke(compound, c)));
                }
                Class<?> nbtTagCompoundClass = this.nmsapi.getNMSClass("NBTTagCompound");
                Object compound = nbtTagCompoundClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                entity_getTag.invoke(this.nmsObject, compound);
                return new IntTag(name, (Integer)getInt.invoke(compound, c));
            }
            catch (Exception e) {
                e.printStackTrace();
                return new IntTag(name, null);
            }
        });
    }

    public StringTag getString(String name) {
        if (this.nmsObject == null) {
            return null;
        }
        return (StringTag)this.knownTags.computeIfAbsent(name, c -> {
            try {
                if (this.isItem) {
                    Object compound = itemStack_getTag.invoke(this.nmsObject, new Object[0]);
                    if (compound == null) {
                        return new StringTag(name, null);
                    }
                    return new StringTag(name, (String)getString.invoke(compound, c));
                }
                Class<?> nbtTagCompoundClass = this.nmsapi.getNMSClass("NBTTagCompound");
                Object compound = nbtTagCompoundClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                entity_getTag.invoke(this.nmsObject, compound);
                return new StringTag(name, (String)getString.invoke(compound, c));
            }
            catch (Exception e) {
                e.printStackTrace();
                return new StringTag(name, null);
            }
        });
    }

    public BooleanTag getBoolean(String name) {
        if (this.nmsObject == null) {
            return null;
        }
        return (BooleanTag)this.knownTags.computeIfAbsent(name, c -> {
            try {
                if (this.isItem) {
                    Object compound = itemStack_getTag.invoke(this.nmsObject, new Object[0]);
                    if (compound == null) {
                        return new BooleanTag(name, null);
                    }
                    return new BooleanTag(name, (boolean)((Boolean)getBoolean.invoke(compound, c)));
                }
                Class<?> nbtTagCompoundClass = this.nmsapi.getNMSClass("NBTTagCompound");
                Object compound = nbtTagCompoundClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                entity_getTag.invoke(this.nmsObject, compound);
                return new BooleanTag(name, (Boolean)getBoolean.invoke(compound, c));
            }
            catch (Exception e) {
                e.printStackTrace();
                return new BooleanTag(name, null);
            }
        });
    }
}

