/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.nbt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import masecla.AutoPickupPlus.mlib.apis.CompatibilityAPI;
import masecla.AutoPickupPlus.mlib.apis.NMSAPI;
import masecla.AutoPickupPlus.mlib.nbt.tags.BooleanTag;
import masecla.AutoPickupPlus.mlib.nbt.tags.IntTag;
import masecla.AutoPickupPlus.mlib.nbt.tags.StringTag;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class TagBuilder {
    private NMSAPI nmsapi;
    private CompatibilityAPI compapi;
    private List<BooleanTag> booleanTags = new ArrayList<BooleanTag>();
    private List<IntTag> intTags = new ArrayList<IntTag>();
    private List<StringTag> stringTags = new ArrayList<StringTag>();

    public TagBuilder(NMSAPI nmsapi, CompatibilityAPI compapi) {
        this.nmsapi = nmsapi;
        this.compapi = compapi;
    }

    public TagBuilder tagInt(String name, int value) {
        this.intTags.add(new IntTag(name, value));
        return this;
    }

    public TagBuilder tagString(String name, String value) {
        this.stringTags.add(new StringTag(name, value));
        return this;
    }

    public TagBuilder tagBoolean(String name, boolean value) {
        this.booleanTags.add(new BooleanTag(name, value));
        return this;
    }

    public TagBuilder unbreakable(boolean value) {
        return this.tagBoolean("Unbreakable", value);
    }

    public TagBuilder noAi(boolean value) {
        return this.tagBoolean("NoAI", value);
    }

    public TagBuilder silent(boolean value) {
        return this.tagBoolean("Silent", value);
    }

    public TagBuilder gravity(boolean value) {
        return this.tagBoolean("NoGravity", !value);
    }

    public TagBuilder invulnerable(boolean value) {
        return this.tagBoolean("Invulnerable", value);
    }

    public TagBuilder customModelData(int value) {
        return this.tagInt("CustomModelData", value);
    }

    public ItemStack applyOn(ItemStack is) {
        try {
            Object item = this.nmsapi.convertToNMSItemStack(is);
            Object compound = this.buildItemTag(item);
            if (this.compapi.getServerVersion().getMajor() <= 17) {
                item.getClass().getDeclaredMethod("setTag", compound.getClass()).invoke(item, compound);
            } else {
                item.getClass().getDeclaredMethod("c", compound.getClass()).invoke(item, compound);
            }
            return this.nmsapi.convertBackToItemStack(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            return is;
        }
    }

    public void applyOn(Entity entity) {
        try {
            Method entity_setTag;
            Method entity_getTag;
            Object nmsObject = this.nmsapi.convertToNMSEntity(entity);
            Class<?> nbtTagCompoundClass = null;
            nbtTagCompoundClass = this.compapi.getServerVersion().getMajor() <= 16 ? this.nmsapi.getNMSClass("NBTTagCompound") : Class.forName("net.minecraft.nbt.NBTTagCompound");
            Class<?> entityClass = null;
            entityClass = this.compapi.getServerVersion().getMajor() <= 16 ? this.nmsapi.getNMSClass("Entity") : Class.forName("net.minecraft.world.entity.Entity");
            if (this.compapi.getServerVersion().getMajor() >= 8 && this.compapi.getServerVersion().getMajor() <= 15) {
                entity_getTag = entityClass.getDeclaredMethod("c", nbtTagCompoundClass);
                entity_setTag = entityClass.getDeclaredMethod("f", nbtTagCompoundClass);
            } else if (this.compapi.getServerVersion().getMajor() == 16) {
                entity_getTag = entityClass.getDeclaredMethod("a_", nbtTagCompoundClass);
                entity_setTag = entityClass.getDeclaredMethod("load", nbtTagCompoundClass);
            } else if (this.compapi.getServerVersion().getMajor() == 17) {
                entity_getTag = entityClass.getDeclaredMethod("d", nbtTagCompoundClass);
                entity_setTag = entityClass.getDeclaredMethod("load", nbtTagCompoundClass);
            } else {
                entity_getTag = entityClass.getDeclaredMethod("f", nbtTagCompoundClass);
                entity_setTag = entityClass.getDeclaredMethod("g", nbtTagCompoundClass);
            }
            Object compound = nbtTagCompoundClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            entity_getTag.invoke(nmsObject, compound);
            Method stringApplier = null;
            Method intApplier = null;
            Method booleanApplier = null;
            if (this.compapi.getServerVersion().getMajor() <= 17) {
                stringApplier = compound.getClass().getDeclaredMethod("setString", String.class, String.class);
                intApplier = compound.getClass().getDeclaredMethod("setInt", String.class, Integer.TYPE);
                booleanApplier = compound.getClass().getDeclaredMethod("setBoolean", String.class, Boolean.TYPE);
            } else {
                stringApplier = compound.getClass().getDeclaredMethod("a", String.class, String.class);
                intApplier = compound.getClass().getDeclaredMethod("a", String.class, Integer.TYPE);
                booleanApplier = compound.getClass().getDeclaredMethod("a", String.class, Boolean.TYPE);
            }
            for (StringTag stringTag : this.stringTags) {
                stringApplier.invoke(compound, stringTag.getName(), stringTag.getValue());
            }
            for (IntTag intTag : this.intTags) {
                intApplier.invoke(compound, intTag.getName(), intTag.getValue());
            }
            for (BooleanTag booleanTag : this.booleanTags) {
                booleanApplier.invoke(compound, booleanTag.getName(), booleanTag.getValue());
            }
            entity_setTag.invoke(nmsObject, compound);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object buildItemTag(Object itemStack) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InstantiationException, ClassNotFoundException {
        Object compound;
        Class<?> nbtTagCompoundClass = null;
        nbtTagCompoundClass = this.compapi.getServerVersion().getMajor() <= 16 ? this.nmsapi.getNMSClass("NBTTagCompound") : Class.forName("net.minecraft.nbt.NBTTagCompound");
        Object possibleCompound = compound = nbtTagCompoundClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        possibleCompound = this.compapi.getServerVersion().getMajor() <= 17 ? itemStack.getClass().getDeclaredMethod("getTag", new Class[0]).invoke(itemStack, new Object[0]) : (this.compapi.getServerVersion().getMajor() <= 18 ? (this.compapi.getServerVersion().getMinor() >= 2 ? itemStack.getClass().getDeclaredMethod("t", new Class[0]).invoke(itemStack, new Object[0]) : itemStack.getClass().getDeclaredMethod("s", new Class[0]).invoke(itemStack, new Object[0])) : itemStack.getClass().getDeclaredMethod("v", new Class[0]).invoke(itemStack, new Object[0]));
        if (possibleCompound != null) {
            compound = possibleCompound;
        }
        Method stringApplier = null;
        Method intApplier = null;
        Method booleanApplier = null;
        if (this.compapi.getServerVersion().getMajor() <= 17) {
            stringApplier = compound.getClass().getDeclaredMethod("setString", String.class, String.class);
            intApplier = compound.getClass().getDeclaredMethod("setInt", String.class, Integer.TYPE);
            booleanApplier = compound.getClass().getDeclaredMethod("setBoolean", String.class, Boolean.TYPE);
        } else {
            stringApplier = compound.getClass().getDeclaredMethod("a", String.class, String.class);
            intApplier = compound.getClass().getDeclaredMethod("a", String.class, Integer.TYPE);
            booleanApplier = compound.getClass().getDeclaredMethod("a", String.class, Boolean.TYPE);
        }
        for (StringTag stringTag : this.stringTags) {
            stringApplier.invoke(compound, stringTag.getName(), stringTag.getValue());
        }
        for (IntTag intTag : this.intTags) {
            intApplier.invoke(compound, intTag.getName(), intTag.getValue());
        }
        for (BooleanTag booleanTag : this.booleanTags) {
            booleanApplier.invoke(compound, booleanTag.getName(), booleanTag.getValue());
        }
        return compound;
    }
}

