/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.main;

import java.io.File;
import masecla.AutoPickupPlus.mlib.apis.CompatibilityAPI;
import masecla.AutoPickupPlus.mlib.apis.ConfigurationAPI;
import masecla.AutoPickupPlus.mlib.apis.ContainerAPI;
import masecla.AutoPickupPlus.mlib.apis.InventoryAPI;
import masecla.AutoPickupPlus.mlib.apis.LoggerAPI;
import masecla.AutoPickupPlus.mlib.apis.MathAPI;
import masecla.AutoPickupPlus.mlib.apis.MessagesAPI;
import masecla.AutoPickupPlus.mlib.apis.NMSAPI;
import masecla.AutoPickupPlus.mlib.apis.PacketAPI;
import masecla.AutoPickupPlus.mlib.apis.ParticleAPI;
import masecla.AutoPickupPlus.mlib.apis.PermissionAPI;
import masecla.AutoPickupPlus.mlib.apis.PlaceholderAPI;
import masecla.AutoPickupPlus.mlib.apis.PluginManagerAPI;
import masecla.AutoPickupPlus.mlib.apis.RandomnessAPI;
import masecla.AutoPickupPlus.mlib.apis.SoundAPI;
import masecla.AutoPickupPlus.mlib.apis.StringAPI;
import masecla.AutoPickupPlus.mlib.apis.TimesAPI;
import masecla.AutoPickupPlus.mlib.apis.TitleAPI;
import masecla.AutoPickupPlus.mlib.apis.WebAPI;
import masecla.AutoPickupPlus.mlib.apis.WorldGuardAPI;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MLib {
    private NMSAPI nmsAPI;
    private PacketAPI packetAPI;
    private PermissionAPI permissionAPI;
    private PluginManagerAPI pluginManagerAPI;
    private StringAPI stringAPI;
    private TitleAPI titleAPI;
    private WorldGuardAPI worldGuardAPI;
    private LoggerAPI loggerApi;
    private ParticleAPI particleApi;
    private ConfigurationAPI configAPI;
    private PlaceholderAPI placeholderAPI;
    private InventoryAPI invapi;
    private MessagesAPI msgapi;
    private RandomnessAPI rndapi;
    private TimesAPI timeapi;
    private WebAPI webapi;
    private ContainerAPI contapi;
    private CompatibilityAPI compatibilityApi;
    private MathAPI mathapi;
    private JavaPlugin plugin;

    public MLib(JavaPlugin plugin) {
        this.plugin = plugin;
        this.pluginManagerAPI = new PluginManagerAPI();
        this.compatibilityApi = new CompatibilityAPI();
        this.rndapi = new RandomnessAPI();
        this.invapi = new InventoryAPI();
        this.timeapi = new TimesAPI();
        this.mathapi = new MathAPI();
        this.webapi = new WebAPI();
        this.stringAPI = new StringAPI(this.rndapi);
        this.loggerApi = new LoggerAPI(this);
        this.nmsAPI = new NMSAPI(this.compatibilityApi);
        this.packetAPI = new PacketAPI(this.nmsAPI, this.compatibilityApi);
        this.worldGuardAPI = new WorldGuardAPI(this.pluginManagerAPI);
        this.configAPI = new ConfigurationAPI(plugin, this.loggerApi, this);
        this.titleAPI = new TitleAPI(this.nmsAPI, this.packetAPI, this.compatibilityApi);
        this.permissionAPI = new PermissionAPI(plugin);
        this.placeholderAPI = new PlaceholderAPI(this.pluginManagerAPI, plugin, this.loggerApi);
        this.msgapi = new MessagesAPI(this.loggerApi, plugin, this);
        this.contapi = new ContainerAPI(plugin, this.mathapi, this.loggerApi, this.invapi);
        this.particleApi = new ParticleAPI(this.compatibilityApi, this.packetAPI, this.nmsAPI);
        this.showServerInformation();
    }

    private void showServerInformation() {
        CompatibilityAPI.Versions version = this.compatibilityApi.getServerVersion();
        String hash = this.compatibilityApi.calculateMappingsHash();
        hash = hash == null ? "unkn" : hash.substring(0, 6);
        this.loggerApi.information("Server version is most likely " + version.getBigMajor() + "." + version.getMajor() + "." + version.getMinor() + " (" + version.getVernumber() + ", " + version.getNMSVersion() + " :: " + hash + ")");
    }

    public PlaceholderAPI getPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public CompatibilityAPI getCompatibilityApi() {
        return this.compatibilityApi;
    }

    public ParticleAPI getParticleAPI() {
        return this.particleApi;
    }

    public MathAPI getMathAPI() {
        return this.mathapi;
    }

    public ContainerAPI getContainerAPI() {
        return this.contapi;
    }

    public RandomnessAPI getRandomnessAPI() {
        return this.rndapi;
    }

    public MessagesAPI getMessagesAPI() {
        return this.msgapi;
    }

    public SoundAPI getSoundAPI() {
        return new SoundAPI();
    }

    public TimesAPI getTimesAPI() {
        return this.timeapi;
    }

    public InventoryAPI getInventoryAPI() {
        return this.invapi;
    }

    public LoggerAPI getLoggerAPI() {
        return this.loggerApi;
    }

    public ConfigurationAPI getConfigurationAPI() {
        return this.configAPI;
    }

    public NMSAPI getNmsAPI() {
        return this.nmsAPI;
    }

    public PacketAPI getPacketAPI() {
        return this.packetAPI;
    }

    public PermissionAPI getPermissionAPI() {
        return this.permissionAPI;
    }

    public PluginManagerAPI getPluginManagerAPI() {
        return this.pluginManagerAPI;
    }

    public StringAPI getStringAPI() {
        return this.stringAPI;
    }

    public TitleAPI getTitleAPI() {
        return this.titleAPI;
    }

    public WorldGuardAPI getWorldGuardAPI() {
        return this.worldGuardAPI;
    }

    public WebAPI getWebAPI() {
        return this.webapi;
    }

    public void registerListener(Listener ... listeners) {
        for (Listener l : listeners) {
            this.getPlugin().getServer().getPluginManager().registerEvents(l, (Plugin)this.getPlugin());
        }
    }

    @Deprecated
    public void setCommandExecutor(String command, CommandExecutor commandExecutors) {
        this.getPlugin().getCommand(command).setExecutor(commandExecutors);
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Deprecated
    public void registerBiFunctionalInterface(String command, Object listeningCommandExecutor) {
        if (listeningCommandExecutor instanceof Listener && listeningCommandExecutor instanceof CommandExecutor) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)listeningCommandExecutor, (Plugin)this.plugin);
            this.plugin.getCommand(command).setExecutor((CommandExecutor)listeningCommandExecutor);
        }
    }

    @Deprecated
    public void rB(String c, Object a) {
        this.registerBiFunctionalInterface(c, a);
    }

    public boolean isDebug() {
        return new File(this.plugin.getDataFolder().getParent() + File.separator + "dev").exists();
    }
}

