/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.containers.generic;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import masecla.AutoPickupPlus.mlib.classes.Registerable;
import masecla.AutoPickupPlus.mlib.classes.Replaceable;
import masecla.AutoPickupPlus.mlib.main.MLib;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;

public abstract class GenericContainer
extends Registerable {
    public Set<UUID> openedFor = new HashSet<UUID>();

    public GenericContainer(MLib lib) {
        super(lib);
    }

    @Override
    public void register() {
        super.register();
        this.lib.getContainerAPI().registerContainer(this);
    }

    public Set<UUID> getOpenedFor() {
        if (this.openedFor != null) {
            return this.openedFor;
        }
        this.openedFor = new HashSet<UUID>();
        return this.openedFor;
    }

    public abstract int getSize(Player var1);

    public abstract boolean updateOnClick();

    public abstract int getUpdatingInterval();

    public abstract boolean requiresUpdating();

    public abstract Inventory getInventory(Player var1);

    @Deprecated
    public void openFor(Player player) {
        this.openedFor.add(player.getUniqueId());
        this.onOpen(player);
    }

    @Deprecated
    public void closeFor(InventoryCloseEvent event) {
        this.openedFor.remove(event.getPlayer().getUniqueId());
        this.onClose(event);
    }

    public abstract void onTopClick(InventoryClickEvent var1);

    public abstract void onBottomClick(InventoryClickEvent var1);

    public abstract void onDrag(InventoryDragEvent var1);

    public abstract void onDrop(PlayerDropItemEvent var1);

    public abstract void onClose(InventoryCloseEvent var1);

    public abstract void onOpen(Player var1);

    @Override
    public void fallbackCommand(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            this.lib.getContainerAPI().openFor((Player)sender, this.getClass());
        } else {
            this.lib.getMessagesAPI().sendMessage("only-player", sender, new Replaceable[0]);
        }
    }
}

