/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.containers.generic;

import java.util.HashMap;
import java.util.UUID;
import masecla.AutoPickupPlus.mlib.containers.generic.ImmutableContainer;
import masecla.AutoPickupPlus.mlib.main.MLib;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;

public abstract class AnimatableContainer
extends ImmutableContainer {
    private HashMap<UUID, Integer> frames = new HashMap();

    public AnimatableContainer(MLib lib) {
        super(lib);
    }

    @Override
    public int getUpdatingInterval() {
        return this.frameInterval();
    }

    @Override
    public boolean updateOnClick() {
        return false;
    }

    public abstract int frameInterval();

    @Override
    public boolean requiresUpdating() {
        return true;
    }

    public abstract int getMaxFrames();

    @Override
    public void onClose(InventoryCloseEvent event) {
        super.onClose(event);
        this.frames.remove(event.getPlayer().getUniqueId());
    }

    public boolean loop() {
        return false;
    }

    @Override
    public Inventory getInventory(Player p) {
        if (!this.loop()) {
            this.frames.put(p.getUniqueId(), this.frames.getOrDefault(p.getUniqueId(), 0) + 1);
            if (this.frames.get(p.getUniqueId()) == this.getMaxFrames() - 1) {
                p.closeInventory();
                return null;
            }
        } else {
            this.frames.put(p.getUniqueId(), (this.frames.getOrDefault(p.getUniqueId(), 0) + 1) % this.getMaxFrames());
        }
        return this.getFrame(p, this.frames.get(p.getUniqueId()));
    }

    public abstract Inventory getFrame(Player var1, int var2);
}

