/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.classes.messages;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import masecla.AutoPickupPlus.mlib.classes.MamlConfiguration;
import masecla.AutoPickupPlus.mlib.classes.Replaceable;
import masecla.AutoPickupPlus.mlib.main.MLib;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SendableMessage {
    private List<String> sends = new ArrayList<String>();
    private boolean wasList = false;
    private boolean centered;
    private MLib lib;
    private int CENTER_PX = 154;
    private final int CHAT_SIZE = 410;

    public SendableMessage(MamlConfiguration config, String path, String prefix, boolean centered) {
        String str;
        this.lib = config.getLib();
        if (!config.isSet(path)) {
            return;
        }
        this.centered = centered;
        Object obj = config.get(path);
        if (obj instanceof List) {
            this.sends.addAll((List)obj);
            this.wasList = true;
        } else if (obj instanceof String && (str = obj.toString()).length() != 0) {
            this.sends.add(prefix + str);
        }
    }

    public SendableMessage(MamlConfiguration config, String path, String prefix) {
        this(config, path, prefix, false);
    }

    public List<String> getMessages(OfflinePlayer sender, Replaceable ... repl) {
        this.apply(sender, repl);
        return this.sends;
    }

    public boolean wasList() {
        return this.wasList;
    }

    public String getMessagesAsString(String delimiter, Player p, Replaceable ... repl) {
        String result = "";
        for (String s : this.getMessages((OfflinePlayer)p, repl)) {
            result = result + s + delimiter;
        }
        result = result.substring(0, result.length() - delimiter.length());
        return result;
    }

    public String getMessagesAsString(Player p, Replaceable ... repl) {
        return this.getMessagesAsString("\n", p, repl);
    }

    private void apply(OfflinePlayer sender, Replaceable ... repl) {
        for (int i = 0; i < this.sends.size(); ++i) {
            String toTransform = this.sends.get(i);
            for (Replaceable cr : repl) {
                toTransform = toTransform.replace(cr.getToReplace(), cr.getWith());
            }
            toTransform = net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)toTransform);
            this.sends.set(i, toTransform);
        }
        this.sends = this.lib.getPlaceholderAPI().applyOn(this.sends, sender);
    }

    public void sendToPlayer(CommandSender sender, Replaceable ... repl) {
        for (String cr : this.sends) {
            this.parseAndSend(sender, cr, repl);
        }
    }

    private void parseAndSend(CommandSender sender, String single, Replaceable ... repl) {
        List<String> toParse = this.splitBy(single, MessageTag.tagRegex());
        if (toParse.size() == 1) {
            String s = single;
            s = net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)s);
            for (Replaceable cr : repl) {
                s = s.replace(cr.getToReplace(), cr.getWith());
            }
            s = sender instanceof OfflinePlayer ? this.lib.getPlaceholderAPI().applyOn(s, (OfflinePlayer)sender) : this.lib.getPlaceholderAPI().applyOn(s, null);
            if (this.centered) {
                sender.sendMessage(this.getSpaceCompensation(s) + s);
            } else {
                sender.sendMessage(s);
            }
            return;
        }
        toParse = this.megaSplit(toParse);
        ArrayList<TextComponent> componentList = new ArrayList<TextComponent>();
        TextComponent prev = null;
        for (int i = 0; i < toParse.size(); ++i) {
            String cAdd = "";
            if (prev != null) {
                cAdd = ChatColor.getLastColors((String)prev.toLegacyText().trim());
            }
            TextComponent toAdd = null;
            toAdd = new MessageTag(toParse.get(i), cAdd, this.lib).asComponent(sender, repl);
            if (toAdd != null && (prev != null || toAdd.toPlainText().length() >= 2)) {
                componentList.add(toAdd);
            }
            prev = toAdd;
        }
        if (sender instanceof Player) {
            BaseComponent[] componentArray = new BaseComponent[componentList.size()];
            componentArray = componentList.toArray(componentArray);
            componentArray = this.ensureLineEndings(componentArray);
            try {
                if (this.lib.getCompatibilityApi().getServerVersion().getMajor() > 16) {
                    ((Player)sender).spigot().sendMessage(componentArray);
                } else if (this.lib.getCompatibilityApi().getServerVersion().getMajor() > 11) {
                    TextComponent toSend = new TextComponent();
                    componentList.forEach(arg_0 -> ((TextComponent)toSend).addExtra(arg_0));
                    Object bsc = this.lib.getNmsAPI().getNMSClass("IChatBaseComponent$ChatSerializer").getDeclaredMethod("a", String.class).invoke(null, ComponentSerializer.toString((BaseComponent)toSend));
                    if (this.lib.getCompatibilityApi().getServerVersion().getMajor() < 16) {
                        Object packet = this.lib.getNmsAPI().getNMSClass("PacketPlayOutChat").getConstructor(this.lib.getNmsAPI().getNMSClass("IChatBaseComponent")).newInstance(bsc);
                        this.lib.getPacketAPI().sendPacket((Player)sender, packet);
                    } else {
                        Class<?> en = this.lib.getNmsAPI().getNMSClass("ChatMessageType");
                        Object packet = this.lib.getNmsAPI().getNMSClass("PacketPlayOutChat").getConstructor(this.lib.getNmsAPI().getNMSClass("IChatBaseComponent"), this.lib.getNmsAPI().getNMSClass("ChatMessageType"), UUID.class).newInstance(bsc, Enum.valueOf(en, "CHAT"), ((Player)sender).getUniqueId());
                        this.lib.getPacketAPI().sendPacket((Player)sender, packet);
                    }
                } else if (this.lib.getCompatibilityApi().getServerVersion().getMajor() <= 11) {
                    ((Player)sender).spigot().sendMessage(componentArray);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            TextComponent res = new TextComponent();
            componentList.forEach(arg_0 -> ((TextComponent)res).addExtra(arg_0));
            sender.sendMessage(res.toLegacyText());
        }
    }

    public List<String> megaSplit(List<String> s) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < s.size(); ++i) {
            if (i % 2 == 0) {
                String[] splitt = s.get(i).split(" ");
                int j = 0;
                while (j < splitt.length) {
                    int n = j++;
                    splitt[n] = splitt[n] + " ";
                }
                for (String cr : splitt) {
                    result.add(cr);
                }
                continue;
            }
            result.add(s.get(i));
        }
        return result;
    }

    public List<String> splitBy(String s, String regex) {
        Matcher m = Pattern.compile(regex).matcher(s);
        ArrayList<String> result = new ArrayList<String>();
        int startPos = 0;
        boolean found = false;
        while (m.find()) {
            found = true;
            result.add(s.substring(startPos, m.start()));
            result.add(m.group());
            startPos = m.end();
        }
        if (found) {
            if (startPos != s.length()) {
                result.add(s.substring(startPos));
            }
        } else {
            result.add(s);
        }
        return result;
    }

    public BaseComponent[] ensureLineEndings(BaseComponent ... baseComponents) {
        int currentLength = 0;
        ArrayList<BaseComponent> result = new ArrayList<BaseComponent>();
        ArrayList<BaseComponent> currentBatch = new ArrayList<BaseComponent>();
        for (int i = 0; i < baseComponents.length; ++i) {
            BaseComponent cr = baseComponents[i];
            currentBatch.add(cr);
            if ((currentLength += this.getLength(cr)) <= 410 || i == baseComponents.length - 1) continue;
            if (this.centered) {
                result.add(this.getSpaceCompensation(currentBatch));
            }
            currentBatch.add((BaseComponent)new TextComponent("\n "));
            result.addAll(currentBatch);
            currentBatch.clear();
            currentLength = 0;
        }
        if (currentBatch.size() != 0) {
            if (this.centered) {
                result.add(this.getSpaceCompensation(currentBatch));
            }
            result.addAll(currentBatch);
        }
        BaseComponent[] res = new BaseComponent[result.size()];
        res = result.toArray(res);
        return res;
    }

    public int getLength(BaseComponent component) {
        String message = component.toPlainText();
        int messagePxSize = 0;
        boolean bold = component.isBold();
        for (char c : message.toCharArray()) {
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += bold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        return messagePxSize;
    }

    public BaseComponent getSpaceCompensation(List<BaseComponent> messagesBatch) {
        int messagePxSize = 0;
        for (BaseComponent cr : messagesBatch) {
            messagePxSize += this.getLength(cr);
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = this.CENTER_PX - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return new TextComponent(sb.toString());
    }

    private String getSpaceCompensation(String message) {
        message = net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        char colorCodeCharacter = '\u00a7';
        for (char c : message.toCharArray()) {
            if (c == colorCodeCharacter) {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = this.CENTER_PX - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static class MessageTag {
        private TagType type;
        private String value;
        private String hoverText;
        private String insideText;
        private boolean isTag = false;
        private MLib lib;

        public MessageTag(String tagCode, String extraColors, MLib lib) {
            this.lib = lib;
            try {
                String regex = MessageTag.tagRegex();
                Pattern toUse = Pattern.compile(regex);
                Matcher inside = toUse.matcher(tagCode);
                if (inside.find()) {
                    this.isTag = true;
                    this.type = TagType.matchType(inside.group(1));
                    this.value = inside.group(2);
                    this.hoverText = inside.group(3);
                    this.insideText = extraColors + inside.group(4);
                } else {
                    this.insideText = extraColors + tagCode;
                    this.isTag = false;
                }
            }
            catch (Exception e) {
                this.insideText = tagCode;
                this.isTag = false;
            }
        }

        public TagType getType() {
            return this.type;
        }

        public void setType(TagType type) {
            this.type = type;
        }

        public static String tagRegex() {
            return "\\[(run|suggest|url|hover) value=[\\\"']([^\\\"\\']*)[\\\"'](?: text=[\\\"']([^\\\"\\']*)[\\\"'])?\\](.*?)\\[\\/\\1]";
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getHoverText() {
            return this.hoverText;
        }

        public void setHoverText(String hoverText) {
            this.hoverText = hoverText;
        }

        public String getInsideText() {
            return this.insideText;
        }

        public void setInsideText(String insideText) {
            this.insideText = insideText;
        }

        public TextComponent asComponent(CommandSender p, Replaceable ... repl) {
            this.value = this.applyEverything(this.value, p, repl);
            this.hoverText = this.applyEverything(this.hoverText, p, repl);
            this.insideText = this.applyEverything(this.insideText, p, repl);
            TextComponent cmp = new TextComponent(this.insideText);
            if (!this.isTag) {
                return cmp;
            }
            if (this.type.equals((Object)TagType.HOVER)) {
                cmp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(this.value)}));
            }
            if (this.type.equals((Object)TagType.RUN)) {
                cmp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.value));
                cmp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(this.hoverText)}));
            }
            if (this.type.equals((Object)TagType.SUGGEST)) {
                cmp.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, this.value));
                cmp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(this.hoverText)}));
            }
            if (this.type.equals((Object)TagType.URL)) {
                cmp.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.value));
                cmp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(this.hoverText)}));
            }
            return cmp;
        }

        private String applyEverything(String s, CommandSender sender, Replaceable ... repl) {
            if (s == null) {
                return "NULL";
            }
            s = net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)s);
            for (Replaceable cr : repl) {
                s = s.replace(cr.getToReplace(), cr.getWith());
            }
            s = sender instanceof OfflinePlayer ? this.lib.getPlaceholderAPI().applyOn(s, (OfflinePlayer)sender) : this.lib.getPlaceholderAPI().applyOn(s, null);
            return s;
        }

        public static enum TagType {
            HOVER("hover"),
            SUGGEST("suggest"),
            URL("url"),
            RUN("run"),
            UNKNOWN("unknown");

            private String tag;

            private TagType(String tag) {
                this.tag = tag;
            }

            public String getTag() {
                return this.tag;
            }

            public static TagType matchType(String type) {
                for (TagType cr : TagType.values()) {
                    if (!cr.getTag().equals(type)) continue;
                    return cr;
                }
                return UNKNOWN;
            }
        }
    }

    public static enum DefaultFontInfo {
        A('A', 5),
        a('a', 5),
        B('B', 5),
        b('b', 5),
        C('C', 5),
        c('c', 5),
        D('D', 5),
        d('d', 5),
        E('E', 5),
        e('e', 5),
        F('F', 5),
        f('f', 4),
        G('G', 5),
        g('g', 5),
        H('H', 5),
        h('h', 5),
        I('I', 3),
        i('i', 1),
        J('J', 5),
        j('j', 5),
        K('K', 5),
        k('k', 4),
        L('L', 5),
        l('l', 1),
        M('M', 5),
        m('m', 5),
        N('N', 5),
        n('n', 5),
        O('O', 5),
        o('o', 5),
        P('P', 5),
        p('p', 5),
        Q('Q', 5),
        q('q', 5),
        R('R', 5),
        r('r', 5),
        S('S', 5),
        s('s', 5),
        T('T', 5),
        t('t', 4),
        U('U', 5),
        u('u', 5),
        V('V', 5),
        v('v', 5),
        W('W', 5),
        w('w', 5),
        X('X', 5),
        x('x', 5),
        Y('Y', 5),
        y('y', 5),
        Z('Z', 5),
        z('z', 5),
        NUM_1('1', 5),
        NUM_2('2', 5),
        NUM_3('3', 5),
        NUM_4('4', 5),
        NUM_5('5', 5),
        NUM_6('6', 5),
        NUM_7('7', 5),
        NUM_8('8', 5),
        NUM_9('9', 5),
        NUM_0('0', 5),
        EXCLAMATION_POINT('!', 1),
        AT_SYMBOL('@', 6),
        NUM_SIGN('#', 5),
        DOLLAR_SIGN('$', 5),
        PERCENT('%', 5),
        UP_ARROW('^', 5),
        AMPERSAND('&', 5),
        ASTERISK('*', 5),
        LEFT_PARENTHESIS('(', 4),
        RIGHT_PERENTHESIS(')', 4),
        MINUS('-', 5),
        UNDERSCORE('_', 5),
        PLUS_SIGN('+', 5),
        EQUALS_SIGN('=', 5),
        LEFT_CURL_BRACE('{', 4),
        RIGHT_CURL_BRACE('}', 4),
        LEFT_BRACKET('[', 3),
        RIGHT_BRACKET(']', 3),
        COLON(':', 1),
        SEMI_COLON(';', 1),
        DOUBLE_QUOTE('\"', 3),
        SINGLE_QUOTE('\'', 1),
        LEFT_ARROW('<', 4),
        RIGHT_ARROW('>', 4),
        QUESTION_MARK('?', 5),
        SLASH('/', 5),
        BACK_SLASH('\\', 5),
        LINE('|', 1),
        TILDE('~', 5),
        TICK('`', 2),
        PERIOD('.', 1),
        COMMA(',', 1),
        SPACE(' ', 3),
        DEFAULT('a', 4);

        private char character;
        private int length;

        private DefaultFontInfo(char character, int length) {
            this.character = character;
            this.length = length;
        }

        public char getCharacter() {
            return this.character;
        }

        public int getLength() {
            return this.length;
        }

        public int getBoldLength() {
            if (this == SPACE) {
                return this.getLength();
            }
            return this.length + 1;
        }

        public static DefaultFontInfo getDefaultFontInfo(char c) {
            for (DefaultFontInfo dFI : DefaultFontInfo.values()) {
                if (dFI.getCharacter() != c) continue;
                return dFI;
            }
            return DEFAULT;
        }
    }
}

