/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.classes.builders;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import masecla.AutoPickupPlus.mlib.apis.CompatibilityAPI;
import masecla.AutoPickupPlus.mlib.classes.Replaceable;
import masecla.AutoPickupPlus.mlib.main.MLib;
import masecla.AutoPickupPlus.mlib.nbt.TagBuilder;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;

public class ItemBuilder {
    @NonNull
    private Material item;
    private String name;
    private int amount = 1;
    private byte data = 0;
    private short damage = 0;
    private List<String> lore = new ArrayList<String>();
    private List<ItemFlag> flags = new ArrayList<ItemFlag>();
    private Map<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
    private boolean fromMessages = false;
    private Map<String, Object> nbtTags = new HashMap<String, Object>();
    private List<Replaceable> replaceables = new ArrayList<Replaceable>();
    private List<Function<ItemMeta, ItemMeta>> metaModifiers = new ArrayList<Function<ItemMeta, ItemMeta>>();
    private boolean unbreakable;
    private Object skullInfo = null;
    private boolean isUrl = false;

    public ItemBuilder lore(String ... line) {
        for (String cr : line) {
            this.lore.add(cr);
        }
        return this;
    }

    public ItemBuilder data(int data) {
        this.data = (byte)data;
        return this;
    }

    public ItemBuilder damage(int damage) {
        this.damage = (short)damage;
        return this;
    }

    public ItemBuilder messages() {
        this.fromMessages = !this.fromMessages;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ItemStack build(MLib lib, Player playerInstance) {
        ItemStack result = null;
        if (lib.getCompatibilityApi().getServerVersion().higherThanOr(CompatibilityAPI.Versions.v1_13)) {
            result = new ItemStack(this.item, this.amount);
            if (this.damage != 0) {
                result.setDurability(this.damage);
            }
            if (this.data != 0) {
                result.setData(new MaterialData(this.item, this.data));
            }
        } else {
            result = new ItemStack(this.item, this.amount, this.damage, Byte.valueOf(this.data));
        }
        ItemMeta meta = result.getItemMeta();
        if (this.name != null) {
            if (this.fromMessages) {
                this.name = lib.getMessagesAPI().getPluginMessage(this.name, playerInstance, this.replaceables.toArray(new Replaceable[0]));
            } else {
                for (Replaceable replaceable : this.replaceables) {
                    this.name = this.name.replace(replaceable.getToReplace(), replaceable.getWith());
                }
                this.name = lib.getPlaceholderAPI().applyOn(this.name, (OfflinePlayer)playerInstance);
            }
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.name));
        }
        if (this.lore != null && this.lore.size() != 0) {
            if (this.fromMessages) {
                ArrayList messagedLore = new ArrayList();
                for (String loreName : this.lore) {
                    messagedLore.addAll(lib.getMessagesAPI().getPluginListMessage(loreName, (OfflinePlayer)playerInstance, this.replaceables.toArray(new Replaceable[0])));
                }
                this.lore = messagedLore.stream().flatMap(c -> Arrays.stream(c.split("\n"))).collect(Collectors.toList());
            } else {
                this.lore = this.lore.stream().filter(c -> c != null).map(c -> ChatColor.translateAlternateColorCodes((char)'&', (String)c)).map(c -> {
                    for (Replaceable rpl : this.replaceables) {
                        c = c.replace(rpl.getToReplace(), rpl.getWith());
                    }
                    c = lib.getPlaceholderAPI().applyOn((String)c, (OfflinePlayer)playerInstance);
                    return c;
                }).flatMap(c -> Arrays.stream(c.split("\n"))).collect(Collectors.toList());
            }
            meta.setLore(this.lore);
        }
        if (this.enchants.size() != 0) {
            for (Map.Entry entry : this.enchants.entrySet()) {
                meta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
        }
        if (this.flags.size() != 0) {
            this.flags.forEach(xva$0 -> meta.addItemFlags(new ItemFlag[]{xva$0}));
        }
        if (this.unbreakable) {
            meta.spigot().setUnbreakable(this.unbreakable);
        }
        if (this.skullInfo != null) {
            block32: {
                SkullMeta skullMeta = (SkullMeta)meta;
                if (this.skullInfo instanceof String && this.skullInfo.equals("%player%") && playerInstance != null) {
                    this.skullInfo = playerInstance;
                }
                if (this.skullInfo instanceof OfflinePlayer) {
                    if (((OfflinePlayer)this.skullInfo).isOnline()) {
                        try {
                            Player player = Bukkit.getPlayer((UUID)((OfflinePlayer)this.skullInfo).getUniqueId());
                            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
                            GameProfile profile = (GameProfile)handle.getClass().getMethod("getProfile", new Class[0]).invoke(handle, new Object[0]);
                            this.skullInfo = ((Property)profile.getProperties().get((Object)"textures").stream().findFirst().orElseGet(null)).getValue();
                        }
                        catch (Exception exception) {
                            if (lib.getCompatibilityApi().getServerVersion().higherThanOr(CompatibilityAPI.Versions.v1_12_2)) {
                                skullMeta.setOwningPlayer((OfflinePlayer)this.skullInfo);
                                break block32;
                            }
                            skullMeta.setOwner(((OfflinePlayer)this.skullInfo).getName());
                        }
                    } else if (lib.getCompatibilityApi().getServerVersion().higherThanOr(CompatibilityAPI.Versions.v1_12_2)) {
                        skullMeta.setOwningPlayer((OfflinePlayer)this.skullInfo);
                    } else {
                        skullMeta.setOwner(((OfflinePlayer)this.skullInfo).getName());
                    }
                }
            }
            if (this.skullInfo instanceof String) {
                void var6_16;
                String string = (String)this.skullInfo;
                if (this.isUrl) {
                    String json = "{\"textures\":{\"SKIN\":{\"url\":\"http://textures.minecraft.net/texture/" + this.skullInfo + "\"}}}";
                    String string2 = Base64.getEncoder().encodeToString(json.getBytes());
                }
                GameProfile profile = new GameProfile(UUID.randomUUID(), "");
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", (String)var6_16));
                Field profileField = null;
                try {
                    profileField = meta.getClass().getDeclaredField("profile");
                    profileField.setAccessible(true);
                    profileField.set(meta, profile);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        for (Function function : this.metaModifiers) {
            meta = (ItemMeta)function.apply(meta);
        }
        result.setItemMeta(meta);
        if (this.nbtTags.size() != 0) {
            TagBuilder builder = lib.getNmsAPI().write();
            this.nbtTags.forEach((c, v) -> {
                if (v instanceof String) {
                    builder.tagString((String)c, (String)v);
                } else if (v instanceof Integer) {
                    builder.tagInt((String)c, (Integer)v);
                } else if (v instanceof Boolean) {
                    builder.tagBoolean((String)c, (Boolean)v);
                }
            });
            result = builder.applyOn(result);
        }
        return result;
    }

    public ItemStack build(MLib lib) {
        return this.build(lib, null);
    }

    public ItemBuilder tagInt(String name, int value) {
        this.nbtTags.put(name, value);
        return this;
    }

    public ItemBuilder tagString(String name, String value) {
        this.nbtTags.put(name, value);
        return this;
    }

    public ItemBuilder tagBoolean(String name, boolean value) {
        this.nbtTags.put(name, value);
        return this;
    }

    public ItemBuilder transformMeta(Function<ItemMeta, ItemMeta> function) {
        this.metaModifiers.add(function);
        return this;
    }

    public ItemBuilder skull(String base64) {
        this.setInternalSkull();
        this.skullInfo = base64;
        return this;
    }

    public ItemBuilder skullUrl(String minecraftUrl) {
        this.setInternalSkull();
        this.isUrl = true;
        this.skullInfo = minecraftUrl;
        return this;
    }

    public ItemBuilder skull(OfflinePlayer player) {
        this.setInternalSkull();
        this.skullInfo = player;
        return this;
    }

    private void setInternalSkull() {
        this.item = Material.matchMaterial((String)"SKULL_ITEM");
        if (this.item == null) {
            this.item = Material.matchMaterial((String)"PLAYER_HEAD");
        } else {
            this.data = (byte)3;
        }
    }

    public ItemBuilder empty() {
        this.name = "";
        this.lore = new ArrayList<String>();
        this.fromMessages = false;
        return this;
    }

    public ItemBuilder replaceable(Replaceable replaceable) {
        this.replaceables.add(replaceable);
        return this;
    }

    public ItemBuilder replaceable(String text, String replace) {
        this.replaceables.add(new Replaceable(text, replace));
        return this;
    }

    public ItemBuilder replaceable(String text, int replace) {
        return this.replaceable(text, Integer.toString(replace));
    }

    public ItemBuilder replaceable(String text, Object replace) {
        return this.replaceable(text, replace.toString());
    }

    public ItemBuilder replaceable(Replaceable ... replaceables) {
        Arrays.stream(replaceables).forEach(this.replaceables::add);
        return this;
    }

    public ItemBuilder rpl(Replaceable replaceable) {
        this.replaceables.add(replaceable);
        return this;
    }

    public ItemBuilder rpl(String text, String replace) {
        this.replaceables.add(new Replaceable(text, replace));
        return this;
    }

    public ItemBuilder rpl(String text, int replace) {
        return this.rpl(text, Integer.toString(replace));
    }

    public ItemBuilder rpl(String text, Object replace) {
        return this.rpl(text, replace.toString());
    }

    public ItemBuilder rpl(Replaceable ... replaceables) {
        Arrays.stream(replaceables).forEach(this.replaceables::add);
        return this;
    }

    public ItemBuilder enchant(Enchantment enchantment, int level) {
        this.enchants.put(enchantment, level);
        return this;
    }

    public ItemBuilder unbreakable() {
        this.unbreakable = true;
        return this;
    }

    public ItemBuilder unbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public ItemBuilder glow() {
        this.enchant(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
        return this.hideEnchants();
    }

    public ItemBuilder glow(boolean glow) {
        if (!glow) {
            return this;
        }
        return this.glow();
    }

    public ItemBuilder flag(ItemFlag flag) {
        this.flags.add(flag);
        return this;
    }

    public ItemBuilder hideEnchants() {
        return this.flag(ItemFlag.HIDE_ENCHANTS);
    }

    public ItemBuilder hideAll() {
        for (ItemFlag cr : ItemFlag.values()) {
            this.flag(cr);
        }
        return this;
    }

    public ItemBuilder mnl(String messages) {
        this.messages();
        this.name(messages + "-name");
        return this.lore(messages + "-lore");
    }

    public ItemBuilder item(@NonNull Material item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.item = item;
        return this;
    }

    public ItemBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.amount = amount;
        return this;
    }

    public ItemBuilder data(byte data) {
        this.data = data;
        return this;
    }

    public ItemBuilder damage(short damage) {
        this.damage = damage;
        return this;
    }

    public ItemBuilder lore(List<String> lore) {
        this.lore = lore;
        return this;
    }

    public ItemBuilder flags(List<ItemFlag> flags) {
        this.flags = flags;
        return this;
    }

    public ItemBuilder enchants(Map<Enchantment, Integer> enchants) {
        this.enchants = enchants;
        return this;
    }

    public ItemBuilder nbtTags(Map<String, Object> nbtTags) {
        this.nbtTags = nbtTags;
        return this;
    }

    public ItemBuilder metaModifiers(List<Function<ItemMeta, ItemMeta>> metaModifiers) {
        this.metaModifiers = metaModifiers;
        return this;
    }

    public ItemBuilder(@NonNull Material item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.item = item;
    }

    public ItemBuilder() {
    }
}

