/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.classes.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import masecla.AutoPickupPlus.mlib.classes.Replaceable;
import masecla.AutoPickupPlus.mlib.classes.builders.ItemBuilder;
import masecla.AutoPickupPlus.mlib.main.MLib;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryBuilder {
    private String title = null;
    private Map<Integer, Object> placedItems = new HashMap<Integer, Object>();
    private int size;
    private boolean fromMessages = false;
    private List<Replaceable> replaceables = new ArrayList<Replaceable>();

    public InventoryBuilder messages() {
        this.fromMessages = !this.fromMessages;
        return this;
    }

    public Inventory build(MLib lib, Player p) {
        Inventory result = null;
        this.fixSize();
        if (this.title != null) {
            if (this.fromMessages) {
                this.title = lib.getMessagesAPI().getPluginMessage(this.title, p, this.replaceables.toArray(new Replaceable[0]));
            }
            this.title = ChatColor.translateAlternateColorCodes((char)'&', (String)this.title);
            result = Bukkit.createInventory(null, (int)this.size, (String)this.title);
        } else {
            result = Bukkit.createInventory(null, (int)this.size);
        }
        for (Map.Entry<Integer, Object> entry : this.placedItems.entrySet()) {
            int index = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ItemStack) {
                result.setItem(index, (ItemStack)value);
                continue;
            }
            if (!(value instanceof ItemBuilder)) continue;
            result.setItem(index, ((ItemBuilder)value).build(lib, p));
        }
        return result;
    }

    public InventoryBuilder size(Rows size) {
        this.size = size.count();
        return this;
    }

    public Inventory build(MLib lib) {
        return this.build(lib, null);
    }

    private void fixSize() {
        if (this.size % 9 != 0) {
            this.size = (this.size / 9 + 1) * 9;
        }
    }

    public InventoryBuilder setItem(int index, ItemStack is) {
        this.placedItems.put(index, is);
        return this;
    }

    public InventoryBuilder setItem(int index, ItemBuilder builder) {
        this.placedItems.put(index, builder);
        return this;
    }

    public InventoryBuilder setItem(int x, int y, ItemStack is) {
        return this.setItem(y * 9 + x, is);
    }

    public InventoryBuilder setItem(int x, int y, ItemBuilder builder) {
        return this.setItem(y * 9 + x, builder);
    }

    public InventoryBuilder border(ItemStack is) {
        int i;
        for (i = 0; i < this.size / 9; ++i) {
            this.setItem(i * 9, is);
            this.setItem(i * 9 + 8, is);
        }
        for (i = 0; i < 5; ++i) {
            this.setItem(i, is);
            this.setItem(9 - i, is);
            this.setItem(i + this.size - 9, is);
            this.setItem(this.size - i - 1, is);
        }
        return this;
    }

    public InventoryBuilder border(ItemBuilder is) {
        int i;
        for (i = 0; i < this.size / 9; ++i) {
            this.setItem(i * 9, is);
            this.setItem(i * 9 + 8, is);
        }
        for (i = 0; i < 5; ++i) {
            this.setItem(i, is);
            this.setItem(9 - i, is);
            this.setItem(i + this.size - 9, is);
            this.setItem(this.size - i - 1, is);
        }
        return this;
    }

    public InventoryBuilder onAllSlots(Function<Integer, ItemBuilder> fnc) {
        for (int i = 0; i < this.size; ++i) {
            this.setItem(i, fnc.apply(i));
        }
        return this;
    }

    public InventoryBuilder onEmptySlots(Function<Integer, ItemBuilder> fnc) {
        for (int i = 0; i < this.size; ++i) {
            if (this.placedItems.containsKey(i)) continue;
            this.setItem(i, fnc.apply(i));
        }
        return this;
    }

    public InventoryBuilder replaceable(Replaceable replaceable) {
        this.replaceables.add(replaceable);
        return this;
    }

    public InventoryBuilder replaceable(String text, String replace) {
        this.replaceables.add(new Replaceable(text, replace));
        return this;
    }

    public InventoryBuilder replaceable(Replaceable ... replaceables) {
        Arrays.stream(replaceables).forEach(this.replaceables::add);
        return this;
    }

    public InventoryBuilder title(String title) {
        this.title = title;
        return this;
    }

    public InventoryBuilder placedItems(Map<Integer, Object> placedItems) {
        this.placedItems = placedItems;
        return this;
    }

    public InventoryBuilder size(int size) {
        this.size = size;
        return this;
    }

    public static enum Rows {
        ONE(9),
        TWO(18),
        THREE(27),
        FOUR(36),
        FIVE(45),
        SIX(54);

        private int count;

        public int count() {
            return this.count;
        }

        private Rows(int count) {
            this.count = count;
        }
    }
}

