/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.classes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import masecla.AutoPickupPlus.mlib.annotations.RegisterableInfo;
import masecla.AutoPickupPlus.mlib.annotations.SubcommandInfo;
import masecla.AutoPickupPlus.mlib.classes.Replaceable;
import masecla.AutoPickupPlus.mlib.main.MLib;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public abstract class Registerable
implements Listener {
    protected MLib lib;

    public Registerable(MLib lib) {
        this.lib = lib;
    }

    private void executeCommand(CommandSender sender, String[] args) {
        ArrayList<Method> eligible = new ArrayList<Method>();
        for (Method m : this.getClass().getMethods()) {
            eligible.add(m);
        }
        eligible.removeIf(c -> !c.isAnnotationPresent(SubcommandInfo.class));
        eligible.removeIf(this::hasDirtyTypes);
        eligible.removeIf(c -> !this.worksFor((Method)c, args));
        Method m = this.findCorrect(eligible, args);
        if (m != null) {
            this.applyFor(sender, m, args);
        }
    }

    public void fallbackCommand(CommandSender sender, String[] args) {
    }

    private boolean worksFor(Method m, String[] args) {
        int i;
        SubcommandInfo info = m.getAnnotation(SubcommandInfo.class);
        if (info == null) {
            return false;
        }
        if (m.getParameterCount() == 1 && args.length == 0 && info.subcommand().equals("")) {
            return true;
        }
        ArrayList<String> possiblePaths = new ArrayList<String>();
        possiblePaths.add(info.subcommand());
        for (String subc : info.aliases()) {
            possiblePaths.add(subc);
        }
        int supposedLength = info.subcommand().split(" ").length;
        String foundPath = null;
        for (String path : possiblePaths) {
            if (path.equals("")) {
                foundPath = "";
                break;
            }
            String[] pathPieces = path.split(" ");
            if (pathPieces.length != supposedLength && (info.subcommand().startsWith(path) || path.startsWith(info.subcommand()))) {
                this.lib.getLoggerAPI().error("Detected that in fact, \"" + path + "\" is a nested invalid alias for \"" + info.subcommand() + "\". Skipping!");
                continue;
            }
            if (pathPieces.length > args.length) continue;
            boolean foundMismatch = false;
            for (i = 0; i < pathPieces.length; ++i) {
                if (pathPieces[i].equalsIgnoreCase(args[i])) continue;
                foundMismatch = true;
                break;
            }
            if (foundMismatch) continue;
            foundPath = path;
            break;
        }
        if (foundPath == null) {
            return false;
        }
        ArrayList<String> actualArgs = new ArrayList<String>();
        int pathLength = foundPath.split(" ").length;
        if (foundPath.length() == 0) {
            --pathLength;
        }
        for (int i2 = pathLength; i2 < args.length; ++i2) {
            actualArgs.add(args[i2]);
        }
        int argsNeeded = m.getParameterCount() - 1;
        Parameter[] params = m.getParameters();
        for (i = 1; i < params.length - 1; ++i) {
            if (!params[i].getType().equals(String[].class)) continue;
            this.lib.getLoggerAPI().error("Method " + m.getName() + " has a String... or String[] as an argument other than the last one!");
            return false;
        }
        boolean endsInVarargs = false;
        if (params.length > 1) {
            endsInVarargs = params[params.length - 1].getType().equals(String[].class);
        }
        if (endsInVarargs) {
            return argsNeeded <= actualArgs.size();
        }
        return argsNeeded == actualArgs.size();
    }

    private void applyFor(CommandSender sender, Method m, String[] args) {
        if (m.getName().equals("fallbackCommand") && m.getParameterTypes().length == 2) {
            try {
                m.invoke((Object)this, sender, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        if (!m.isAnnotationPresent(SubcommandInfo.class)) {
            return;
        }
        SubcommandInfo info = m.getAnnotation(SubcommandInfo.class);
        if (info.permission().length() >= 1 && !sender.hasPermission(info.permission())) {
            this.lib.getMessagesAPI().sendMessage(info.message(), sender, new Replaceable[0]);
            return;
        }
        boolean isPlayer = m.getParameters()[0].getType().equals(Player.class);
        if (isPlayer && !(sender instanceof Player)) {
            this.lib.getMessagesAPI().sendMessage(info.onlyPlayerMessage(), sender, new Replaceable[0]);
            return;
        }
        ArrayList<Object> actualArgs = new ArrayList<Object>();
        actualArgs.add(sender);
        int subCommandOffset = info.subcommand().split(" ").length;
        if (info.subcommand().length() == 0) {
            --subCommandOffset;
        }
        if (subCommandOffset < 0) {
            subCommandOffset = 0;
        }
        boolean endsInVarargs = false;
        Parameter[] params = m.getParameters();
        if (params.length > 1) {
            endsInVarargs = params[params.length - 1].getType().equals(String[].class);
        }
        if (!endsInVarargs) {
            for (int i = subCommandOffset; i < args.length; ++i) {
                actualArgs.add(args[i]);
            }
        } else {
            int nonVarargs = params.length - 2;
            for (int i = subCommandOffset; i < subCommandOffset + nonVarargs; ++i) {
                actualArgs.add(args[i]);
            }
            ArrayList<String> remainingArgs = new ArrayList<String>();
            for (int i = subCommandOffset + nonVarargs; i < args.length; ++i) {
                remainingArgs.add(args[i]);
            }
            actualArgs.add(remainingArgs.toArray(new String[0]));
        }
        try {
            m.invoke((Object)this, actualArgs.toArray(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Method findCorrect(List<Method> methods, final String[] args) {
        List<Method> cr = methods;
        Collections.sort(cr, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return Registerable.this.getPriority(o1, args) - Registerable.this.getPriority(o2, args);
            }
        });
        if (cr.size() != 0) {
            return cr.get(0);
        }
        try {
            return this.getClass().getMethod("fallbackCommand", CommandSender.class, String[].class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.lib.getLoggerAPI().error("Fallback command not found for " + this.getClass().getName() + "!", true);
            return null;
        }
    }

    private int getPriority(Method m, String[] args) {
        if (args.length == m.getParameterCount() - 1) {
            int priority = 100;
            int i = 0;
            for (String cr : m.getAnnotation(SubcommandInfo.class).subcommand().split(" ")) {
                if (args[i].equalsIgnoreCase(cr)) {
                    --priority;
                }
                ++i;
            }
            return priority;
        }
        return m.getParameterCount() + 1000;
    }

    private boolean hasDirtyTypes(Method m) {
        ArrayList<Class> allowedTypes = new ArrayList<Class>();
        allowedTypes.add(String.class);
        allowedTypes.add(String[].class);
        allowedTypes.add(CommandSender.class);
        allowedTypes.add(Player.class);
        for (Parameter cr : m.getParameters()) {
            if (allowedTypes.contains(cr.getType())) continue;
            return true;
        }
        return false;
    }

    public void register() {
        for (Method m : this.getClass().getMethods()) {
            if (!m.isAnnotationPresent(EventHandler.class)) continue;
            this.lib.registerListener(this);
            break;
        }
        if (this.getClass().isAnnotationPresent(RegisterableInfo.class)) {
            String command = this.getClass().getAnnotation(RegisterableInfo.class).command();
            PluginCommand commandObject = this.lib.getPlugin().getCommand(command);
            if (commandObject != null) {
                commandObject.setExecutor(new CommandExecutor(){

                    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
                        Registerable.this.executeCommand(sender, args);
                        return true;
                    }
                });
            } else {
                this.lib.getLoggerAPI().warn("Command " + command + " was not registered in plugin.yml! (Offender: " + this.getClass().getName() + ")", true);
            }
        }
    }
}

