/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.classes;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import masecla.AutoPickupPlus.mlib.main.MLib;
import org.bukkit.Color;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class MamlConfiguration {
    private YamlConfiguration config;
    private boolean requiresSaving = false;
    private MLib lib;

    public MamlConfiguration(MLib lib, YamlConfiguration config) {
        this.config = config;
        this.lib = lib;
    }

    public boolean requiresSaving() {
        return this.requiresSaving;
    }

    public void markAsSaved() {
        this.requiresSaving = false;
    }

    public void markAsNeedingSave() {
        this.requiresSaving = true;
    }

    public MamlConfiguration(MLib lib) {
        this.config = new YamlConfiguration();
        this.lib = lib;
    }

    public boolean contains(String path) {
        return this.config.contains(path);
    }

    public ConfigurationSection createSection(String path) {
        return this.config.createSection(path);
    }

    public ConfigurationSection createSection(String path, Map<?, ?> map) {
        return this.config.createSection(path, map);
    }

    public Object get(String path) {
        return this.get(path, null);
    }

    public Object get(String path, Object def) {
        if (this.isSet(path)) {
            return this.injectMLib(this.lib.getConfigurationAPI().getFromConfig(this, path));
        }
        return this.injectMLib(def);
    }

    public Object injectMLib(Object obj) {
        if (obj == null) {
            return null;
        }
        for (Field f : obj.getClass().getDeclaredFields()) {
            if (!f.getType().equals(MLib.class)) continue;
            try {
                f.setAccessible(true);
                f.set(obj, this.lib);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            break;
        }
        return obj;
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.config.getBoolean(path, def);
    }

    public List<Boolean> getBooleanList(String path) {
        return this.config.getBooleanList(path);
    }

    public List<Byte> getByteList(String path) {
        return this.config.getByteList(path);
    }

    public List<Character> getCharacterList(String path) {
        return this.config.getCharacterList(path);
    }

    public Color getColor(String path) {
        return this.config.getColor(path);
    }

    public Color getColor(String path, Color def) {
        return this.config.getColor(path, def);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public String getCurrentPath() {
        return this.config.getCurrentPath();
    }

    public ConfigurationSection getDefaultSection() {
        return this.config.getDefaultSection();
    }

    public double getDouble(String path) {
        return this.config.getDouble(path);
    }

    public double getDouble(String path, double def) {
        return this.config.getDouble(path, def);
    }

    public List<Double> getDoubleList(String path) {
        return this.config.getDoubleList(path);
    }

    public List<Float> getFloatList(String path) {
        return this.config.getFloatList(path);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public int getInt(String path, int def) {
        return this.config.getInt(path, def);
    }

    public List<Integer> getIntegerList(String path) {
        return this.config.getIntegerList(path);
    }

    public ItemStack getItemStack(String path) {
        return this.config.getItemStack(path);
    }

    public ItemStack getItemStack(String path, ItemStack def) {
        return this.config.getItemStack(path, def);
    }

    @SafeVarargs
    public final Set<String> getKeys(boolean deep, Predicate<String> ... match) {
        Stream<Object> result = this.config.getKeys(deep).stream();
        for (Predicate<String> cr : match) {
            result = result.filter(cr);
        }
        return result.collect(Collectors.toSet());
    }

    public List<?> getList(String path) {
        return this.config.getList(path);
    }

    public List<?> getList(String path, List<?> def) {
        return this.config.getList(path, def);
    }

    public long getLong(String path) {
        return this.config.getLong(path);
    }

    public long getLong(String path, long def) {
        return this.config.getLong(path, def);
    }

    public List<Long> getLongList(String path) {
        return this.config.getLongList(path);
    }

    public List<Map<?, ?>> getMapList(String path) {
        return this.config.getMapList(path);
    }

    public String getName() {
        return this.config.getName();
    }

    public OfflinePlayer getOfflinePlayer(String path) {
        return this.config.getOfflinePlayer(path);
    }

    public OfflinePlayer getOfflinePlayer(String path, OfflinePlayer def) {
        return this.config.getOfflinePlayer(path, def);
    }

    public Configuration getRoot() {
        return this.config.getRoot();
    }

    public List<Short> getShortList(String path) {
        return this.config.getShortList(path);
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public String getString(String path, String def) {
        return this.config.getString(path, def);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public List<String> getStringList(String path, List<String> def) {
        if (this.config.isSet(path)) {
            return this.config.getStringList(path);
        }
        return def;
    }

    public Map<String, Object> getValues(boolean deep) {
        return this.config.getValues(deep);
    }

    public Vector getVector(String path) {
        return this.config.getVector(path);
    }

    public Vector getVector(String path, Vector def) {
        return this.config.getVector(path, def);
    }

    public boolean isBoolean(String path) {
        return this.config.isBoolean(path);
    }

    public boolean isColor(String path) {
        return this.config.isColor(path);
    }

    public boolean isConfigurationSection(String path) {
        return this.config.isConfigurationSection(path);
    }

    public boolean isDouble(String path) {
        return this.config.isDouble(path);
    }

    public boolean isInt(String path) {
        return this.config.isInt(path);
    }

    public boolean isItemStack(String path) {
        return this.config.isItemStack(path);
    }

    public boolean isList(String path) {
        return this.config.isList(path);
    }

    public boolean isLong(String path) {
        return this.config.isLong(path);
    }

    public boolean isOfflinePlayer(String path) {
        return this.config.isOfflinePlayer(path);
    }

    public boolean isSet(String path) {
        return this.config.isSet(path);
    }

    public boolean isString(String path) {
        return this.config.isString(path);
    }

    public boolean isVector(String path) {
        return this.config.isVector(path);
    }

    public void set(String path, Object value) {
        this.requiresSaving = true;
        try {
            this.lib.getConfigurationAPI().serializeToConfig(this, path, value);
        }
        catch (Exception e) {
            this.lib.getLoggerAPI().error("Failed while parsing -> " + path + " (" + value.getClass().getName() + ")");
            e.printStackTrace();
        }
    }

    public void unset(String path) {
        this.requiresSaving = true;
        this.config.set(path, null);
    }

    public void addDefault(String path, Object value) {
        this.config.addDefault(path, value);
    }

    public void addDefaults(Configuration defaults) {
        this.config.addDefaults(defaults);
    }

    public void addDefaults(Map<String, Object> defaults) {
        this.config.addDefaults(defaults);
    }

    public void load(File fl) {
        try {
            this.config.load(fl);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void save(File file) {
        try {
            this.config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(Reader inputStreamReader) throws IOException, InvalidConfigurationException {
        this.config.load(inputStreamReader);
    }

    public void loadFromString(String string) throws InvalidConfigurationException {
        this.config.loadFromString(string);
    }

    public String saveToString() {
        return this.config.saveToString();
    }

    public MLib getLib() {
        return this.lib;
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }
}

