/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.classes;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CooldownList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 5558610273726212402L;
    private long secondsCooldown;
    private long lastCleansing = 0L;
    private Map<E, Integer> cooldownTimes = new HashMap<E, Integer>();

    public CooldownList(TimeUnit unit, int count) {
        this.secondsCooldown = unit.toSeconds(count);
    }

    private void cleanseMap() {
        if (Instant.now().getEpochSecond() - this.lastCleansing < 20L) {
            return;
        }
        this.lastCleansing = Instant.now().getEpochSecond();
        HashSet toRemove = new HashSet();
        this.cooldownTimes.forEach((? super K c, ? super V v) -> {
            if (Instant.now().getEpochSecond() - (long)v.intValue() > this.secondsCooldown) {
                toRemove.add(c);
            }
        });
        toRemove.forEach(this.cooldownTimes::remove);
    }

    @Override
    public boolean add(E e) {
        this.cleanseMap();
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.cleanseMap();
        super.add(index, element);
    }

    @Override
    public boolean contains(Object o) {
        boolean actuallyContains = super.contains(o);
        if (!actuallyContains) {
            return false;
        }
        return Instant.now().getEpochSecond() - (long)this.cooldownTimes.get(o).intValue() < this.secondsCooldown;
    }
}

