/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.apis;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;

public class TimesAPI {
    private final int SECONDS_YEAR = 31536000;
    private final int SECONDS_MONTH = 2592000;
    private final int SECONDS_DAY = 86400;
    private final int SECONDS_HOUR = 3600;
    private final int SECONDS_MINUTE = 60;

    public String generateTime(long secs) {
        if (secs == 0L) {
            return "0 seconds";
        }
        ArrayList<String> timeUnits = new ArrayList<String>();
        long years = secs / 31536000L;
        long months = (secs %= 31536000L) / 2592000L;
        long days = (secs %= 2592000L) / 86400L;
        long hours = (secs %= 86400L) / 3600L;
        long minutes = (secs %= 3600L) / 60L;
        secs %= 60L;
        if (years > 0L) {
            timeUnits.add(years + " " + this.singOrPl(years, "year", "years"));
        }
        if (months > 0L) {
            timeUnits.add(months + " " + this.singOrPl(months, "month", "months"));
        }
        if (days > 0L) {
            timeUnits.add(days + " " + this.singOrPl(days, "day", "days"));
        }
        if (hours > 0L) {
            timeUnits.add(hours + " " + this.singOrPl(hours, "hour", "hours"));
        }
        if (minutes > 0L) {
            timeUnits.add(minutes + " " + this.singOrPl(minutes, "minute", "minutes"));
        }
        if (secs > 0L) {
            timeUnits.add(secs + " " + this.singOrPl(secs, "second", "seconds"));
        }
        if (timeUnits.size() == 1) {
            return (String)timeUnits.get(0);
        }
        if (timeUnits.size() == 2) {
            return (String)timeUnits.get(0) + " and " + (String)timeUnits.get(1);
        }
        String ret = "";
        for (int i = 0; i < timeUnits.size(); ++i) {
            ret = i == timeUnits.size() - 1 ? ret + "and " + (String)timeUnits.get(i) : (i == timeUnits.size() - 2 ? ret + (String)timeUnits.get(i) + " " : ret + (String)timeUnits.get(i) + ", ");
        }
        return ret;
    }

    private String singOrPl(long qty, String singular, String plural) {
        if (qty == 1L) {
            return singular;
        }
        return plural;
    }

    public int timeToSeconds(String arg) {
        int currentTime = 0;
        String curr = "";
        try {
            for (int i = 0; i < arg.length(); ++i) {
                Character a = Character.valueOf(arg.charAt(i));
                if (Character.isLetter(a.charValue())) {
                    if (a.charValue() == 's') {
                        currentTime += Integer.parseInt(curr);
                    } else if (a.charValue() == 'm') {
                        currentTime += Integer.parseInt(curr) * 60;
                    } else if (a.charValue() == 'h') {
                        currentTime += Integer.parseInt(curr) * 3600;
                    } else if (a.charValue() == 'd') {
                        currentTime += Integer.parseInt(curr) * 86400;
                    } else if (a.charValue() == 'w') {
                        currentTime += Integer.parseInt(curr) * 604800;
                    }
                    curr = "";
                    continue;
                }
                curr = curr + a.toString();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return currentTime;
    }

    public String generateDateString() {
        Date dt = new Date(Instant.now().getEpochSecond() * 1000L);
        SimpleDateFormat frm = new SimpleDateFormat("dd-MM-yyyy HH:mm");
        return frm.format(dt);
    }

    public String generateDateString(long milliseconds) {
        Date dt = new Date(milliseconds);
        SimpleDateFormat frm = new SimpleDateFormat("dd-MM-yyyy HH:mm");
        return frm.format(dt);
    }

    public long generateUnixTimestampFromDateString(String date) {
        try {
            return new SimpleDateFormat("dd-MM-yyyy HH:mm").parse(date).getTime();
        }
        catch (ParseException e) {
            return Instant.now().getEpochSecond() * 1000L;
        }
    }
}

