/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.apis;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import masecla.AutoPickupPlus.mlib.apis.LoggerAPI;
import masecla.AutoPickupPlus.mlib.apis.PluginManagerAPI;
import masecla.AutoPickupPlus.mlib.classes.RegisterablePlaceholder;
import masecla.AutoPickupPlus.mlib.classes.messages.MVDWWrapper;
import masecla.AutoPickupPlus.mlib.classes.messages.PAPIWrapper;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.java.JavaPlugin;

public class PlaceholderAPI {
    private LoggerAPI log;
    private MVDWWrapper mvdwWrapper = null;
    private PAPIWrapper papiWrapper = null;
    private HashMap<String, RegisterablePlaceholder> registered = new HashMap();

    public PlaceholderAPI(PluginManagerAPI pma, JavaPlugin pl, LoggerAPI log) {
        this.log = log;
        int count = 0;
        if (pma.isPluginInstalled("MVdWPlaceholderAPI")) {
            ++count;
            this.mvdwWrapper = new MVDWWrapper(pl, this);
            log.information("Found MVdWPlaceholderAPI, hooking into it.");
        }
        if (pma.isPluginInstalled("PlaceholderAPI")) {
            ++count;
            log.information("Found PlaceholderAPI, hooking into it.");
            this.papiWrapper = new PAPIWrapper(pl, this);
        }
        if (count == 0) {
            log.warn("You no placeholder container found! (PAPI, MVdWPAPI). The internal one will be used!");
        }
        if (count == 2) {
            log.warn("You have both PlaceholderAPI & MVdWPlaceholderAPI installed. Watch out for that, it might cause issues");
        }
    }

    public HashMap<String, RegisterablePlaceholder> getRegistered() {
        return this.registered;
    }

    @Deprecated
    public void queueRegistration(RegisterablePlaceholder regg) {
        this.registered.put(regg.getIdentifier(), regg);
        this.log.information("Registered placeholder %" + regg.getFullIdentifier() + "% (class " + regg.getClass().getName() + ")");
        if (this.mvdwWrapper != null) {
            this.mvdwWrapper.registerMvDWPlaceholder(regg);
        }
    }

    protected void register(RegisterablePlaceholder regg) {
        this.registered.put(regg.getIdentifier(), regg);
        this.log.information("Registered placeholder %" + regg.getFullIdentifier() + "% (class " + regg.getClass().getName() + ")");
        if (this.mvdwWrapper != null) {
            this.mvdwWrapper.registerMvDWPlaceholder(regg);
        }
    }

    public String applyOn(String s, OfflinePlayer p) {
        try {
            Class<?> papi;
            if (this.papiWrapper != null && s.contains("%")) {
                papi = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                s = (String)papi.getMethod("setPlaceholders", OfflinePlayer.class, String.class).invoke(null, p, s);
            }
            if (this.mvdwWrapper != null) {
                papi = Class.forName("be.maximvdw.placeholderapi.PlaceholderAPI");
                s = (String)papi.getMethod("replacePlaceholders", OfflinePlayer.class, String.class).invoke(null, p, s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (RegisterablePlaceholder c : this.registered.values()) {
            if (!this.containsPlaceholder(s, c)) continue;
            s = s.replace(c.getCurledIdentifier(), c.getPlaceholder(p, c.getIdentifier()));
        }
        return s;
    }

    public List<String> applyOn(List<String> s, OfflinePlayer p) {
        for (int i = 0; i < s.size(); ++i) {
            s.set(i, this.applyOn(s.get(i), p));
        }
        return s;
    }

    private boolean containsPlaceholder(String s, RegisterablePlaceholder plc) {
        return Pattern.matches("%" + plc.getFullIdentifier() + "\\w*%", s);
    }
}

