/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.apis;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import masecla.AutoPickupPlus.mlib.apis.CompatibilityAPI;
import masecla.AutoPickupPlus.mlib.nbt.TagBuilder;
import masecla.AutoPickupPlus.mlib.nbt.TagReader;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class NMSAPI {
    private Map<String, Class<?>> nmsClasses = new HashMap();
    private CompatibilityAPI compapi;

    public NMSAPI(CompatibilityAPI compapi) {
        this.compapi = compapi;
    }

    public Class<?> getNMSClass(String name) {
        return this.nmsClasses.computeIfAbsent(name, c -> {
            String version = this.compapi.getNMSVersion();
            try {
                return Class.forName("net.minecraft.server." + version + "." + c);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        });
    }

    public Class<?> getNMSBukkitClass(String name) {
        return this.nmsClasses.computeIfAbsent(name, c -> {
            String version = this.compapi.getNMSVersion();
            try {
                return Class.forName("org.bukkit.craftbukkit." + version + "." + c);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        });
    }

    public Object convertToNMSItemStack(ItemStack is) {
        try {
            return this.getNMSBukkitClass("inventory.CraftItemStack").getDeclaredMethod("asNMSCopy", ItemStack.class).invoke(null, is);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    public Object convertToNMSEntity(Entity entity) {
        try {
            Class<?> craftEntityClass = this.getNMSBukkitClass("entity.CraftEntity");
            return craftEntityClass.getDeclaredMethod("getHandle", new Class[0]).invoke(craftEntityClass.cast(entity), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    public ItemStack convertBackToItemStack(Object obj) {
        try {
            Class<?> itemClass = null;
            itemClass = this.compapi.getServerVersion().getMajor() <= 16 ? this.getNMSClass("ItemStack") : Class.forName("net.minecraft.world.item.ItemStack");
            return (ItemStack)this.getNMSBukkitClass("inventory.CraftItemStack").getDeclaredMethod("asBukkitCopy", itemClass).invoke(null, obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public TagBuilder write() {
        return new TagBuilder(this, this.compapi);
    }

    public TagReader read(ItemStack item) {
        return new TagReader(this.compapi, this, item);
    }

    public TagReader read(Entity entity) {
        return new TagReader(this.compapi, this, entity);
    }

    @Deprecated
    public ItemStack applyNBTTagString(ItemStack obj, String tagName, String tagValue) {
        try {
            Object nmsResult = this.convertToNMSItemStack(obj);
            Object compound = this.getNMSClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
            if (((Boolean)nmsResult.getClass().getDeclaredMethod("hasTag", new Class[0]).invoke(nmsResult, new Object[0])).booleanValue()) {
                compound = nmsResult.getClass().getDeclaredMethod("getTag", new Class[0]).invoke(nmsResult, new Object[0]);
            }
            compound.getClass().getDeclaredMethod("setString", String.class, String.class).invoke(compound, tagName, tagValue);
            nmsResult.getClass().getDeclaredMethod("setTag", compound.getClass()).invoke(nmsResult, compound);
            return this.convertBackToItemStack(nmsResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public String getNBTTagValueString(ItemStack obj, String tagName) {
        try {
            Object nmsResult = this.convertToNMSItemStack(obj);
            Object compound = this.getNMSClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
            if (((Boolean)nmsResult.getClass().getDeclaredMethod("hasTag", new Class[0]).invoke(nmsResult, new Object[0])).booleanValue()) {
                compound = nmsResult.getClass().getDeclaredMethod("getTag", new Class[0]).invoke(nmsResult, new Object[0]);
            }
            return (String)compound.getClass().getDeclaredMethod("getString", String.class).invoke(compound, tagName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public ItemStack applyNBTTagInt(ItemStack obj, String tagName, int tagValue) {
        try {
            Object nmsResult = this.convertToNMSItemStack(obj);
            Object compound = this.getNMSClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
            if (((Boolean)nmsResult.getClass().getDeclaredMethod("hasTag", new Class[0]).invoke(nmsResult, new Object[0])).booleanValue()) {
                compound = nmsResult.getClass().getDeclaredMethod("getTag", new Class[0]).invoke(nmsResult, new Object[0]);
            }
            compound.getClass().getDeclaredMethod("setInt", String.class, Integer.TYPE).invoke(compound, tagName, tagValue);
            nmsResult.getClass().getDeclaredMethod("setTag", compound.getClass()).invoke(nmsResult, compound);
            return this.convertBackToItemStack(nmsResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public int getNBTTagValueInt(ItemStack obj, String tagName) {
        try {
            Object nmsResult = this.convertToNMSItemStack(obj);
            Object compound = this.getNMSClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
            if (((Boolean)nmsResult.getClass().getDeclaredMethod("hasTag", new Class[0]).invoke(nmsResult, new Object[0])).booleanValue()) {
                compound = nmsResult.getClass().getDeclaredMethod("getTag", new Class[0]).invoke(nmsResult, new Object[0]);
            }
            return (Integer)compound.getClass().getDeclaredMethod("getInt", String.class).invoke(compound, tagName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Deprecated
    public ItemStack removeNBTTag(ItemStack obj, String tagName) {
        try {
            Object nmsResult = this.convertToNMSItemStack(obj);
            Object compound = this.getNMSClass("NBTTagCompound").getConstructor(new Class[0]).newInstance(new Object[0]);
            if (((Boolean)nmsResult.getClass().getDeclaredMethod("hasTag", new Class[0]).invoke(nmsResult, new Object[0])).booleanValue()) {
                compound = nmsResult.getClass().getDeclaredMethod("getTag", new Class[0]).invoke(nmsResult, new Object[0]);
            }
            compound.getClass().getDeclaredMethod("remove", String.class).invoke(compound, tagName);
            nmsResult.getClass().getDeclaredMethod("setTag", compound.getClass()).invoke(nmsResult, compound);
            return this.convertBackToItemStack(nmsResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

