/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.apis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class InventoryAPI {
    public String toBase64(Inventory inventory) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(inventory.getSize());
            for (int i = 0; i < inventory.getSize(); ++i) {
                dataOutput.writeObject((Object)inventory.getItem(i));
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public Inventory fromBase64(String data) throws IOException, ClassNotFoundException, IllegalArgumentException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
        BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
        Inventory inventory = Bukkit.getServer().createInventory(null, dataInput.readInt());
        for (int i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, (ItemStack)dataInput.readObject());
        }
        dataInput.close();
        return inventory;
    }

    public String itemStackArrayToBase64(ItemStack[] items) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(items.length);
            for (int i = 0; i < items.length; ++i) {
                dataOutput.writeObject((Object)items[i]);
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public ItemStack[] itemStackArrayFromBase64(String data) throws IOException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack[] items = new ItemStack[dataInput.readInt()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (ItemStack)dataInput.readObject();
            }
            dataInput.close();
            return items;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }

    public Inventory changeName(Inventory inv, String name) {
        Inventory res = Bukkit.createInventory((InventoryHolder)inv.getHolder(), (int)inv.getSize(), (String)ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) == null) continue;
            res.setItem(i, inv.getItem(i));
        }
        return res;
    }

    public boolean isEmpty(Inventory inv) {
        for (ItemStack is : inv.getContents()) {
            if (is == null || is.getType().equals((Object)Material.AIR)) continue;
            return false;
        }
        return true;
    }

    public void updateInventoryView(InventoryView toupdate, InventoryView content) {
        for (int i = 0; i < Math.min(toupdate.getTopInventory().getSize(), content.getTopInventory().getSize()); ++i) {
            toupdate.setItem(i, content.getItem(i));
        }
    }

    public void updateInventoryView(InventoryView toupdate, Inventory content) {
        int i = 0;
        while (i < Math.min(toupdate.getTopInventory().getSize(), content.getSize())) {
            int s = i++;
            toupdate.setItem(s, content.getItem(s));
        }
    }
}

