/*
 * Decompiled with CFR 0.152.
 */
package masecla.AutoPickupPlus.mlib.apis;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import masecla.AutoPickupPlus.mlib.annotations.IgnoreOnSerialization;
import masecla.AutoPickupPlus.mlib.apis.LoggerAPI;
import masecla.AutoPickupPlus.mlib.classes.MamlConfiguration;
import masecla.AutoPickupPlus.mlib.main.MLib;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigurationAPI {
    private HashMap<String, MamlConfiguration> localConfigs = new HashMap();
    private HashMap<String, File> configFiles = new HashMap();
    private JavaPlugin plugin;
    private LoggerAPI logapi;
    private MLib lib;
    private String version;

    public void requiresConfiguration(String configName) {
        File fl;
        if (!configName.endsWith(".yml")) {
            configName = configName + ".yml";
        }
        if (!(fl = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + configName)).exists()) {
            this.plugin.saveResource(configName, true);
        }
        MamlConfiguration cnf = new MamlConfiguration(this.lib);
        cnf.load(fl);
        this.localConfigs.put(configName, cnf);
        this.configFiles.put(configName, fl);
    }

    public void reloadAll() throws IOException {
        this.configFiles.keySet().forEach(this::reloadConfig);
    }

    public void requireAll() {
        ArrayList<String> required = new ArrayList<String>();
        try {
            CodeSource src = this.plugin.getClass().getProtectionDomain().getCodeSource();
            if (src != null) {
                ZipEntry e;
                URL jar = src.getLocation();
                ZipInputStream zip = new ZipInputStream(jar.openStream());
                while ((e = zip.getNextEntry()) != null) {
                    String name = e.getName();
                    if (!name.endsWith(".yml") || name.contains(File.separator) || name.equals("plugin.yml") || name.equals("messages.yml") || name.equals("auth_internal.yml")) continue;
                    required.add(name);
                    this.logapi.information("Executed setup for config: " + name);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        required.forEach(this::requiresConfiguration);
    }

    private void savingTask() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, this::saveAll, 0L, 20L);
    }

    public void saveAll() {
        this.localConfigs.forEach((c, v) -> {
            if (v.requiresSaving()) {
                this.updateFile((String)c);
                v.markAsSaved();
            }
        });
    }

    public void updateFile(String configName) {
        if (!configName.endsWith(".yml")) {
            configName = configName + ".yml";
        }
        this.localConfigs.get(configName).save(this.configFiles.get(configName));
    }

    public void saveConfig(String configName) {
    }

    public void saveConfig() {
    }

    public MamlConfiguration getConfig(String configName) {
        MamlConfiguration config;
        if (!configName.endsWith(".yml")) {
            configName = configName + ".yml";
        }
        if ((config = this.localConfigs.get(configName)) == null) {
            this.lib.getLoggerAPI().warn("Config " + configName + " was accessed without initialization! You either forgot to create the file, or you forgot to call lib.getConfigurationAPI().requireAll();");
        }
        return config;
    }

    public MamlConfiguration getConfig() {
        return this.getConfig("config");
    }

    public void reloadConfig(String configName) {
        this.localConfigs.get(configName).load(this.configFiles.get(configName));
    }

    public void reloadConfig() {
        this.reloadConfig("config");
    }

    public ConfigurationAPI(JavaPlugin plugin, LoggerAPI logapi, MLib lib) {
        this.plugin = plugin;
        this.logapi = logapi;
        this.lib = lib;
        this.version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        this.savingTask();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ConfigurationAPI.this.saveAll();
            }
        });
    }

    private boolean isPrimitive(Class<?> obj) {
        List<Class> primitives = Arrays.asList(Integer.class, Double.class, Byte.class, Boolean.class, Float.class, Long.class, Short.class, String.class, Character.class, Integer.TYPE, Double.TYPE, Boolean.TYPE, Float.TYPE, Character.TYPE, Long.TYPE, Byte.TYPE, Short.TYPE, ConfigurationSection.class);
        return primitives.contains(obj);
    }

    private boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    private boolean isList(Object obj) {
        return obj instanceof List;
    }

    private boolean isJavaSet(Object obj) {
        return obj instanceof Set;
    }

    public void serializeToConfig(MamlConfiguration config, String path, Object obj) throws Exception {
        this.serializeToConfig(config, path, obj, 0);
    }

    private static String removeLastDot(String s) {
        return s.substring(0, s.lastIndexOf(46));
    }

    private void serializeToConfig(MamlConfiguration config, String path, Object obj, int layer) throws Exception {
        block28: {
            block33: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block27: {
                                    if (obj == null) {
                                        this.logapi.warn("Tried saving a null value to config " + path, true);
                                        return;
                                    }
                                    if (obj.getClass().equals(MLib.class)) {
                                        String clazz = ConfigurationAPI.removeLastDot(ConfigurationAPI.removeLastDot(path)) + ".classname";
                                        this.logapi.warn("Some class is attempting to serialize MLib! Offender: " + config.getString(clazz), true);
                                        return;
                                    }
                                    if (layer == 0) {
                                        config.getConfig().set(path, null);
                                    }
                                    if (layer > 300) {
                                        this.logapi.error("FATAL: Somehow you ended up serializing about 300 layers! Unless this is somehow intentional please report it!");
                                        return;
                                    }
                                    config.markAsNeedingSave();
                                    if (this.isPrimitive(obj.getClass())) {
                                        config.getConfig().set(path, obj);
                                        return;
                                    }
                                    String s = obj.getClass().getName();
                                    s.replace(this.version, "$${VERSION}$$");
                                    config.set(path + ".classname", this.unwrapImmutables(s));
                                    if (!this.isList(obj)) break block27;
                                    List list = (List)obj;
                                    int i = 0;
                                    for (Object cr : list) {
                                        this.serializeToConfig(config, path + ".entries.entry" + i, cr, layer + 1);
                                        ++i;
                                    }
                                    break block28;
                                }
                                if (!this.isJavaSet(obj)) break block29;
                                Set list = (Set)obj;
                                int i = 0;
                                for (Object cr : list) {
                                    this.serializeToConfig(config, path + ".entries.entry" + i, cr, layer + 1);
                                    ++i;
                                }
                                break block28;
                            }
                            if (!this.isMap(obj)) break block30;
                            Map list = (Map)obj;
                            int i = 0;
                            for (Map.Entry cr : list.entrySet()) {
                                this.serializeToConfig(config, path + ".entries.entry" + i + ".key", cr.getKey(), layer + 1);
                                this.serializeToConfig(config, path + ".entries.entry" + i + ".value", cr.getValue(), layer + 1);
                                ++i;
                            }
                            break block28;
                        }
                        if (!obj.getClass().isEnum()) break block31;
                        this.serializeToConfig(config, path + ".value", ((Enum)obj).toString(), layer + 1);
                        break block28;
                    }
                    if (!obj.getClass().equals(Location.class)) break block32;
                    Location l = (Location)obj;
                    this.serializeToConfig(config, path + ".x", l.getX(), layer + 1);
                    this.serializeToConfig(config, path + ".y", l.getY(), layer + 1);
                    this.serializeToConfig(config, path + ".z", l.getZ(), layer + 1);
                    this.serializeToConfig(config, path + ".world", l.getWorld().getName(), layer + 1);
                    this.serializeToConfig(config, path + ".yaw", l.getYaw(), layer + 1);
                    this.serializeToConfig(config, path + ".pitch", l.getPitch(), layer + 1);
                    break block28;
                }
                if (!(obj instanceof Property)) break block33;
                Property p = (Property)obj;
                if (p.getName() != null) {
                    this.serializeToConfig(config, path + ".name", p.getName(), layer + 1);
                }
                if (p.getValue() != null) {
                    this.serializeToConfig(config, path + ".value", p.getValue(), layer + 1);
                }
                if (p.getSignature() == null) break block28;
                this.serializeToConfig(config, path + ".signature", p.getSignature(), layer + 1);
                break block28;
            }
            if (obj instanceof PropertyMap) {
                PropertyMap p = (PropertyMap)obj;
                int index = 0;
                for (String cr : p.keySet()) {
                    for (Property property : p.get((Object)cr)) {
                        this.serializeToConfig(config, path + ".entries.entry" + index + ".key", cr, layer + 1);
                        this.serializeToConfig(config, path + ".entries.entry" + index + ".value", property, layer + 1);
                        ++index;
                    }
                }
            } else if (obj instanceof GameProfile) {
                GameProfile p = (GameProfile)obj;
                this.serializeToConfig(config, path + ".name", p.getName(), layer + 1);
                this.serializeToConfig(config, path + ".id", p.getId(), layer + 1);
                this.serializeToConfig(config, path + ".properties", p.getProperties(), layer + 1);
            } else if (this.isWrappedProfile(obj.getClass().getName())) {
                GameProfile profile = this.unwrapGameProfile(obj);
                this.serializeToConfig(config, path + ".profile", profile, layer + 1);
            } else if (obj instanceof World) {
                this.serializeToConfig(config, path + ".value", ((World)obj).getName(), layer + 1);
            } else if (obj.getClass().equals(UUID.class)) {
                this.serializeToConfig(config, path + ".value", obj + "", layer + 1);
            } else if (this.isSerializable(obj.getClass())) {
                Class<?> toUse = this.getSerializableClass(obj.getClass());
                config.set(path + ".classname", toUse.getName());
                Map props = ((ConfigurationSerializable)obj).serialize();
                this.serializeToConfig(config, path + ".properties", props);
            } else {
                Set<Field> fields = this.getFields(obj);
                for (Field f : fields) {
                    try {
                        this.serializeToConfig(config, path + ".fields." + f.getName(), f.get(obj), layer + 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Object getFromConfig(MamlConfiguration config, String path) {
        if (!config.isSet(path + ".classname")) {
            return config.getConfig().get(path);
        }
        try {
            String className = config.getString(path + ".classname").replace("$${VERSION}$$", this.version);
            if (this.isWrappedProfile(className)) {
                GameProfile profile = (GameProfile)this.getFromConfig(config, path + ".profile");
                return this.createWrappedProfile(profile);
            }
            Class<?> cls = Class.forName(className);
            if (cls.isEnum()) {
                String whichOne = (String)this.getFromConfig(config, path + ".value");
                for (Object obj : cls.getEnumConstants()) {
                    if (!obj.toString().equals(whichOne)) continue;
                    return obj;
                }
                return null;
            }
            if (cls.equals(Location.class)) {
                double x = (Double)this.getFromConfig(config, path + ".x");
                double y = (Double)this.getFromConfig(config, path + ".y");
                double z = (Double)this.getFromConfig(config, path + ".z");
                float yaw = (float)((Double)this.getFromConfig(config, path + ".yaw")).doubleValue();
                float pitch = (float)((Double)this.getFromConfig(config, path + ".pitch")).doubleValue();
                World world = Bukkit.getWorld((String)((String)this.getFromConfig(config, path + ".world")));
                return new Location(world, x, y, z, yaw, pitch);
            }
            if (World.class.isAssignableFrom(cls)) {
                String worldName = (String)this.getFromConfig(config, path + ".value");
                return Bukkit.getWorld((String)worldName);
            }
            if (cls.equals(UUID.class)) {
                String value = (String)this.getFromConfig(config, path + ".value");
                return UUID.fromString(value);
            }
            if (cls.equals(Property.class)) {
                String name = (String)this.getFromConfig(config, path + ".name");
                String value = (String)this.getFromConfig(config, path + ".value");
                String signature = (String)this.getFromConfig(config, path + ".signature");
                return new Property(name, value, signature);
            }
            if (cls.equals(PropertyMap.class)) {
                PropertyMap map = new PropertyMap();
                int i = 0;
                while (config.isSet(path + ".entries.entry" + i + ".key")) {
                    String key = (String)this.getFromConfig(config, path + ".entries.entry" + i + ".key");
                    Property value = (Property)this.getFromConfig(config, path + ".entries.entry" + i + ".value");
                    map.put((Object)key, (Object)value);
                    ++i;
                }
                return map;
            }
            if (cls.equals(GameProfile.class)) {
                String name = (String)this.getFromConfig(config, path + ".name");
                UUID id = (UUID)this.getFromConfig(config, path + ".id");
                PropertyMap properties = (PropertyMap)this.getFromConfig(config, path + ".properties");
                GameProfile profile = new GameProfile(id, name);
                profile.getProperties().putAll((Multimap)properties);
                return profile;
            }
            if (this.isSerializable(cls)) {
                try {
                    Object obj = cls.getMethod("deserialize", Map.class).invoke(null, (Map)this.getFromConfig(config, path + ".properties"));
                    return obj;
                }
                catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            Object obj = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.isList(obj)) {
                List field = (List)obj;
                int i = 0;
                while (config.isSet(path + ".entries.entry" + i)) {
                    field.add(this.getFromConfig(config, path + ".entries.entry" + i));
                    ++i;
                }
                return field;
            }
            if (this.isJavaSet(obj)) {
                Set field = (Set)obj;
                int i = 0;
                while (config.isSet(path + ".entries.entry" + i)) {
                    field.add(this.getFromConfig(config, path + ".entries.entry" + i));
                    ++i;
                }
                return field;
            }
            if (this.isMap(obj)) {
                Map field = (Map)obj;
                int i = 0;
                while (config.isSet(path + ".entries.entry" + i)) {
                    field.put(this.getFromConfig(config, path + ".entries.entry" + i + ".key"), this.getFromConfig(config, path + ".entries.entry" + i + ".value"));
                    ++i;
                }
                return field;
            }
            Set<Field> fields = this.getFields(obj);
            for (Field f : fields) {
                f.setAccessible(true);
                String fieldPath = path + ".fields." + f.getName();
                if (!config.isSet(fieldPath)) continue;
                f.set(obj, this.getFromConfig(config, fieldPath));
            }
            return obj;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<Field> getFields(Object obj) {
        HashSet<Field> fields = new HashSet<Field>();
        Class<?> currentClass = obj.getClass();
        while (!currentClass.equals(Object.class)) {
            for (Field f : currentClass.getDeclaredFields()) {
                if (f.isAnnotationPresent(IgnoreOnSerialization.class) || Modifier.isTransient(f.getModifiers()) || f.getType().equals(MLib.class)) continue;
                f.setAccessible(true);
                fields.add(f);
            }
            currentClass = currentClass.getSuperclass();
        }
        return fields;
    }

    public String unwrapImmutables(String s) {
        if (s.equals("com.google.common.collect.RegularImmutableMap")) {
            return "java.util.HashMap";
        }
        if (s.equals("com.google.common.collect.SingletonImmutableBiMap")) {
            return "java.util.HashMap";
        }
        if (s.equals("com.google.common.collect.LinkedHashMultimap")) {
            return "java.util.HashMap";
        }
        if (s.equals("com.google.common.collect.SingletonImmutableList")) {
            return "java.util.ArrayList";
        }
        if (s.equals("com.google.common.collect.RegularImmutableList")) {
            return "java.util.ArrayList";
        }
        return s;
    }

    public boolean isSerializable(Class<?> clazz) {
        if (clazz.isAnnotationPresent(DelegateDeserialization.class)) {
            return true;
        }
        for (Class<?> cr : clazz.getInterfaces()) {
            if (!cr.equals(ConfigurationSerializable.class)) continue;
            return true;
        }
        return false;
    }

    public Class<?> getSerializableClass(Class<?> clazz) {
        if (clazz.isAnnotationPresent(DelegateDeserialization.class)) {
            return clazz.getAnnotation(DelegateDeserialization.class).value();
        }
        return clazz;
    }

    public boolean isWrappedProfile(String className) {
        if (className.equals("com.destroystokyo.paper.profile.CraftPlayerProfile")) {
            return true;
        }
        Class<?> clazz = null;
        try {
            clazz = this.lib.getNmsAPI().getNMSBukkitClass("profile.CraftPlayerProfile");
        }
        catch (Exception e) {
            return false;
        }
        if (clazz == null) {
            return false;
        }
        return className.equals(clazz.getName());
    }

    public Object createWrappedProfile(GameProfile profile) {
        boolean isPaper = false;
        try {
            Class.forName("com.destroystokyo.paper.profile.CraftPlayerProfile");
            isPaper = true;
        }
        catch (ClassNotFoundException e) {
            isPaper = false;
        }
        Class<?> clazz = null;
        clazz = isPaper ? Class.forName("com.destroystokyo.paper.profile.CraftPlayerProfile") : this.lib.getNmsAPI().getNMSBukkitClass("profile.CraftPlayerProfile");
        return clazz.getConstructor(GameProfile.class).newInstance(profile);
    }

    public GameProfile unwrapGameProfile(Object obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        if (obj.getClass().getName().equals("com.destroystokyo.paper.profile.CraftPlayerProfile")) {
            return (GameProfile)obj.getClass().getMethod("getGameProfile", new Class[0]).invoke(obj, new Object[0]);
        }
        if (obj.getClass().equals(this.lib.getNmsAPI().getNMSBukkitClass("profile.CraftPlayerProfile"))) {
            return (GameProfile)obj.getClass().getMethod("buildGameProfile", new Class[0]).invoke(obj, new Object[0]);
        }
        return null;
    }

    public boolean isMojangGameProfile(Class<?> clazz) {
        return clazz.equals(GameProfile.class);
    }
}

