/*
 * Decompiled with CFR 0.152.
 */
package cl.mastercode.DamageIndicator.util;

import cl.mastercode.DamageIndicator.DIMain;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class CompatUtil {
    public static ItemStack RED_INK = null;
    public static int MINOR_VERSION = 8;

    public static void onEnable() {
        MINOR_VERSION = CompatUtil._getMinorVersion();
        RED_INK = MINOR_VERSION >= 13 ? (MINOR_VERSION == 13 ? new ItemStack(Material.valueOf((String)"ROSE_RED")) : new ItemStack(Material.RED_DYE)) : new ItemStack(Material.valueOf((String)"INK_SACK"), 1, 1);
    }

    public static boolean isCanSetCollidable() {
        return MINOR_VERSION > 8;
    }

    public static boolean is113orHigher() {
        return CompatUtil._getMinorVersion() > 13;
    }

    public static double getMaxHealth(LivingEntity livingEntity) {
        if (MINOR_VERSION > 8) {
            return livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        }
        return livingEntity.getMaxHealth();
    }

    private static int _getMinorVersion() {
        String ver = Bukkit.getServer().getClass().getPackage().getName().substring(Bukkit.getServer().getClass().getPackage().getName().lastIndexOf(".") + 1);
        int verInt = -1;
        try {
            verInt = Integer.parseInt(ver.split("_")[1]);
        }
        catch (IllegalArgumentException e) {
            Bukkit.getScheduler().runTask((Plugin)DIMain.getPlugin(DIMain.class), () -> {
                ((DIMain)DIMain.getPlugin(DIMain.class)).getLogger().warning("An error occurred getting server version, please contact developer.");
                ((DIMain)DIMain.getPlugin(DIMain.class)).getLogger().warning("Detected version " + ver);
                Bukkit.getPluginManager().disablePlugin((Plugin)DIMain.getPlugin(DIMain.class));
            });
        }
        return verInt;
    }

    public static ArmorStand buildArmorStand(Location location, double distance, FixedMetadataValue fixedMetadataValue, String name) {
        ArmorStand armorStand = MINOR_VERSION >= 11 ? CompatUtil.modernEntitySpawn(location, distance, fixedMetadataValue) : CompatUtil.legacyEntitySpawn(location, distance, fixedMetadataValue);
        armorStand.setCustomName(name);
        armorStand.setCustomNameVisible(true);
        return armorStand;
    }

    private static ArmorStand modernEntitySpawn(Location location, double distance, FixedMetadataValue fixedMetadataValue) {
        return (ArmorStand)location.getWorld().spawn(location.clone().add(0.0, (double)location.getWorld().getMaxHeight() - location.getY(), 0.0), ArmorStand.class, stand -> CompatUtil.setStandProperties(stand, location, distance, fixedMetadataValue));
    }

    private static ArmorStand legacyEntitySpawn(Location location, double distance, FixedMetadataValue fixedMetadataValue) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        CompatUtil.setStandProperties(armorStand, location, distance, fixedMetadataValue);
        return armorStand;
    }

    private static void setStandProperties(ArmorStand armorStand, Location location, double distance, FixedMetadataValue fixedMetadataValue) {
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setMarker(true);
        armorStand.setSmall(true);
        armorStand.setCustomNameVisible(false);
        armorStand.setMetadata("Mastercode-DamageIndicator", (MetadataValue)fixedMetadataValue);
        if (CompatUtil.isCanSetCollidable()) {
            armorStand.setCollidable(false);
            armorStand.setInvulnerable(true);
        }
        armorStand.teleport(location.clone().add(0.0, distance, 0.0));
        armorStand.setRemoveWhenFarAway(true);
    }
}

