/*
 * Decompiled with CFR 0.152.
 */
package cl.mastercode.DamageIndicator.listener;

import cl.mastercode.DamageIndicator.DIMain;
import cl.mastercode.DamageIndicator.hook.HookManager;
import cl.mastercode.DamageIndicator.util.CompatUtil;
import cl.mastercode.DamageIndicator.util.ConfigUtil;
import cl.mastercode.DamageIndicator.util.EntityHider;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class DamageIndicatorListener
implements Listener {
    private static final String DISABLED_DI = "DI-DISABLED-DI";
    private final DIMain plugin;
    private final Map<ArmorStand, Long> armorStands = new LinkedHashMap<ArmorStand, Long>();
    private final Set<EntityType> disabledEntities = new HashSet<EntityType>();
    private final Set<CreatureSpawnEvent.SpawnReason> disabledSpawnReasons = new HashSet<CreatureSpawnEvent.SpawnReason>();
    private final Set<EntityDamageEvent.DamageCause> disabledDamageCauses = new HashSet<EntityDamageEvent.DamageCause>();
    private final FixedMetadataValue armorStandMeta;
    private boolean enabled = true;
    private boolean enablePlayer = true;
    private boolean enableMonster = true;
    private boolean enableAnimal = true;
    private boolean sneaking = false;
    private final HookManager hookManager;
    private EntityHider hider;

    public DamageIndicatorListener(DIMain plugin, HookManager hookManager) {
        this.plugin = plugin;
        this.hookManager = hookManager;
        this.armorStandMeta = new FixedMetadataValue((Plugin)plugin, (Object)0);
        this.reload();
    }

    public void reload() {
        this.disabledEntities.clear();
        this.disabledSpawnReasons.clear();
        this.enabled = this.plugin.getConfig().getBoolean("Damage Indicator.Enabled");
        this.enablePlayer = this.plugin.getConfig().getBoolean("Damage Indicator.Player");
        this.enableMonster = this.plugin.getConfig().getBoolean("Damage Indicator.Monster");
        this.enableAnimal = this.plugin.getConfig().getBoolean("Damage Indicator.Animals");
        this.sneaking = this.plugin.getConfig().getBoolean("Damage Indicator.Sneaking");
        if (Bukkit.getPluginManager().isPluginEnabled("ProtocolLib")) {
            this.hider = new EntityHider((Plugin)this.plugin, EntityHider.Policy.BLACKLIST);
        }
        this.plugin.getConfig().getStringList("Damage Indicator.Disabled Entities").stream().map(entity -> {
            try {
                return EntityType.valueOf((String)entity.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(DIMain.class.getName()).log(Level.WARNING, entity.toUpperCase() + " is not a valid EntityType.");
                return null;
            }
        }).filter(Objects::nonNull).forEach(this.disabledEntities::add);
        this.plugin.getConfig().getStringList("Damage Indicator.Disabled Spawn Reasons").stream().map(reason -> {
            try {
                return CreatureSpawnEvent.SpawnReason.valueOf((String)reason.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(DIMain.class.getName()).log(Level.WARNING, reason.toUpperCase() + " is not a valid SpawnReason.");
                return null;
            }
        }).filter(Objects::nonNull).forEach(this.disabledSpawnReasons::add);
        this.plugin.getConfig().getStringList("Damage Indicator.Disabled Damage Causes").stream().map(cause -> {
            try {
                return EntityDamageEvent.DamageCause.valueOf((String)cause);
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(DIMain.class.getName()).log(Level.WARNING, cause.toUpperCase() + " is not a valid DamageCause.");
                return null;
            }
        }).filter(Objects::nonNull).forEach(this.disabledDamageCauses::add);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        if (e.isCancelled()) {
            if (this.plugin.isDamageIndicator((Entity)e.getEntity())) {
                e.setCancelled(false);
            }
            return;
        }
        if (!this.isSpawnArmorStand((Entity)e.getEntity(), null, 0.1)) {
            return;
        }
        if (this.disabledSpawnReasons.contains(e.getSpawnReason())) {
            e.getEntity().setMetadata(DISABLED_DI, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)1));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void oneEntitySpawn(EntitySpawnEvent e) {
        if (e.isCancelled() && e.getEntity() instanceof ArmorStand && this.plugin.isDamageIndicator(e.getEntity())) {
            e.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChunkUnload(ChunkUnloadEvent event) {
        for (Entity entity : event.getChunk().getEntities()) {
            ArmorStand as;
            if (!entity.getType().equals((Object)EntityType.ARMOR_STAND) || !this.plugin.isDamageIndicator((Entity)(as = (ArmorStand)entity))) continue;
            this.armorStands.remove(as);
            as.remove();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChunkLoad(ChunkLoadEvent event) {
        for (Entity entity : event.getChunk().getEntities()) {
            ArmorStand as;
            if (!entity.getType().equals((Object)EntityType.ARMOR_STAND) || !this.plugin.isDamageIndicator((Entity)(as = (ArmorStand)entity))) continue;
            this.armorStands.remove(as);
            as.remove();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityRegainHealth(EntityRegainHealthEvent e) {
        Player player;
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (e.getEntity() instanceof Player && (player = (Player)e.getEntity()).isSneaking() && !this.sneaking) {
            return;
        }
        if (((LivingEntity)e.getEntity()).getHealth() == CompatUtil.getMaxHealth((LivingEntity)e.getEntity())) {
            return;
        }
        if (!e.isCancelled()) {
            this.handleArmorStand((LivingEntity)e.getEntity(), e.getAmount());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamageEvent(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!(e.getEntity() instanceof LivingEntity)) {
            return;
        }
        this.handleArmorStand((LivingEntity)e.getEntity(), e.getCause(), e.getFinalDamage(), this.hookManager.isCritic(e));
    }

    private String damageFormat(double damage) {
        DecimalFormat df;
        try {
            df = new DecimalFormat(Objects.requireNonNull(this.plugin.getConfig().getString("Damage Indicator.Format.Decimal", "#.##")));
        }
        catch (Exception ex) {
            df = new DecimalFormat("#.##");
        }
        return df.format(damage);
    }

    private void handleArmorStand(LivingEntity entity, double health) {
        if (this.isSpawnArmorStand((Entity)entity, null, health)) {
            this.spawnArmorStand(entity.getLocation(), ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("Damage Indicator.Format.EntityRegain").replace("%health%", this.damageFormat(health))));
        }
    }

    private void handleArmorStand(LivingEntity entity, EntityDamageEvent.DamageCause damageCause, double damage, boolean crit) {
        if (this.isSpawnArmorStand((Entity)entity, damageCause, damage)) {
            if (!crit) {
                this.spawnArmorStand(entity.getLocation(), ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("Damage Indicator.Format.EntityDamage").replace("%damage%", this.damageFormat(damage))));
            } else {
                this.spawnArmorStand(entity.getLocation(), ChatColor.translateAlternateColorCodes((char)'&', (String)(this.plugin.getConfig().getString("Damage Indicator.Format.EntityDamage").replace("%damage%", this.damageFormat(damage)) + "&r \u2727")));
            }
        }
    }

    public ArmorStand spawnArmorStand(Location loc, String name) {
        ArmorStand armorStand = CompatUtil.buildArmorStand(loc, this.plugin.getConfig().getDouble("Damage Indicator.Distance"), this.armorStandMeta, name);
        if (this.hider != null) {
            Bukkit.getOnlinePlayers().stream().filter(op -> !this.plugin.getStorageProvider().showArmorStand((Player)op)).forEach(op -> this.hider.hideEntity((Player)op, (Entity)armorStand));
        }
        this.armorStands.put(armorStand, System.currentTimeMillis());
        return armorStand;
    }

    private boolean isSpawnArmorStand(Entity entity, EntityDamageEvent.DamageCause damageCause, double damage) {
        return ConfigUtil.isShowIndicator(entity, damageCause, damage, DISABLED_DI, this.enabled, this.enablePlayer, this.sneaking, this.enableMonster, this.enableAnimal, this.disabledEntities, this.disabledDamageCauses);
    }

    public Map<ArmorStand, Long> getArmorStands() {
        return this.armorStands;
    }
}

