/*
 * Decompiled with CFR 0.152.
 */
package cl.mastercode.DamageIndicator.listener;

import cl.mastercode.DamageIndicator.DIMain;
import cl.mastercode.DamageIndicator.util.CompatUtil;
import cl.mastercode.DamageIndicator.util.ConfigUtil;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class BloodListener
implements Listener {
    private static final String BLOOD_NAME = "di-blood";
    private static final String DISABLED_BLOOD = "DI-DISABLED-BLOOD";
    private final DIMain plugin;
    private final Map<Item, Long> bloodItems = new LinkedHashMap<Item, Long>();
    private final Set<EntityType> disabledEntities = new HashSet<EntityType>();
    private final Set<CreatureSpawnEvent.SpawnReason> disabledSpawnReasons = new HashSet<CreatureSpawnEvent.SpawnReason>();
    private final Set<EntityDamageEvent.DamageCause> disabledDamageCauses = new HashSet<EntityDamageEvent.DamageCause>();
    private final Random random = new Random();
    private boolean enabled = true;
    private boolean enablePlayer = true;
    private boolean enableMonster = true;
    private boolean enableAnimal = true;
    private boolean sneaking = true;
    private Method playEffect;

    public BloodListener(DIMain plugin) {
        this.plugin = plugin;
        if (!CompatUtil.is113orHigher()) {
            try {
                this.playEffect = World.Spigot.class.getMethod("playEffect", Location.class, Effect.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        } else {
            this.playEffect = null;
        }
        this.reload();
    }

    public void reload() {
        this.disabledEntities.clear();
        this.disabledSpawnReasons.clear();
        this.enabled = this.plugin.getConfig().getBoolean("Blood.Enabled");
        this.enablePlayer = this.plugin.getConfig().getBoolean("Blood.Player");
        this.enableMonster = this.plugin.getConfig().getBoolean("Blood.Monster");
        this.enableAnimal = this.plugin.getConfig().getBoolean("Blood.Animals");
        this.sneaking = this.plugin.getConfig().getBoolean("Blood.Sneaking");
        this.plugin.getConfig().getStringList("Blood.Disabled Entities").stream().map(entity -> {
            try {
                return EntityType.valueOf((String)entity.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(DIMain.class.getName()).log(Level.WARNING, entity.toUpperCase() + " is not a valid EntityType.");
                return null;
            }
        }).filter(Objects::nonNull).forEach(this.disabledEntities::add);
        this.plugin.getConfig().getStringList("Blood.Disabled Spawn Reasons").stream().map(reason -> {
            try {
                return CreatureSpawnEvent.SpawnReason.valueOf((String)reason.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(DIMain.class.getName()).log(Level.WARNING, reason.toUpperCase() + " is not a valid SpawnReason.");
                return null;
            }
        }).filter(Objects::nonNull).forEach(this.disabledSpawnReasons::add);
        this.plugin.getConfig().getStringList("Blood.Disabled Damage Causes").stream().map(cause -> {
            try {
                return EntityDamageEvent.DamageCause.valueOf((String)cause);
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(DIMain.class.getName()).log(Level.WARNING, cause.toUpperCase() + " is not a valid DamageCause.");
                return null;
            }
        }).filter(Objects::nonNull).forEach(this.disabledDamageCauses::add);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!this.showBlood((Entity)e.getEntity(), null, 0.1)) {
            return;
        }
        if (this.disabledSpawnReasons.contains(e.getSpawnReason())) {
            e.getEntity().setMetadata(DISABLED_BLOOD, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)1));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamage(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!this.showBlood(entity, e.getCause(), e.getFinalDamage())) {
            return;
        }
        if (CompatUtil.is113orHigher()) {
            e.getEntity().getWorld().spawnParticle(Particle.REDSTONE, ((LivingEntity)e.getEntity()).getEyeLocation(), 7, 0.5, 1.0, 0.5, (Object)new Particle.DustOptions(Color.RED, 3.0f));
        } else if (CompatUtil.MINOR_VERSION == 8) {
            try {
                if (this.playEffect != null) {
                    this.playEffect.invoke((Object)e.getEntity().getWorld().spigot(), ((LivingEntity)e.getEntity()).getEyeLocation(), Effect.valueOf((String)"COLOURED_DUST"), 0, 0, Float.valueOf(0.4f), Float.valueOf(0.3f), Float.valueOf(0.4f), 0, 8, 16);
                }
            }
            catch (ReflectiveOperationException e1) {
                e1.printStackTrace();
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                e.getEntity().getNearbyEntities(20.0, 20.0, 20.0).stream().filter(nearbyEntity -> nearbyEntity instanceof Player).map(nearbyEntity -> (Player)nearbyEntity).forEach(player -> player.spawnParticle(Particle.REDSTONE, ((LivingEntity)e.getEntity()).getEyeLocation().clone().add(this.random.nextDouble(), this.random.nextDouble(), this.random.nextDouble()), 0, 255.0, 0.0, 0.0, 1.0));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemPickup(EntityPickupItemEvent e) {
        this.checkBloodItem(e.getItem(), (Cancellable)e);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemPickup(PlayerPickupItemEvent e) {
        this.checkBloodItem(e.getItem(), (Cancellable)e);
    }

    @EventHandler
    public void onInventoryPickup(InventoryPickupItemEvent e) {
        this.checkBloodItem(e.getItem(), (Cancellable)e);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent e) {
        if (!this.showBlood((Entity)e.getEntity(), e.getEntity().getLastDamageCause() != null ? e.getEntity().getLastDamageCause().getCause() : null, 0.1)) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            e.getEntity().getWorld().playEffect(e.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_BLOCK);
        }
        e.getEntity().getWorld().playEffect(e.getEntity().getLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_WIRE, 2);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        if (!this.enablePlayer) {
            return;
        }
        for (int i = 0; i < 14; ++i) {
            ItemStack is = new ItemStack(CompatUtil.RED_INK);
            ItemMeta meta = is.getItemMeta();
            meta.setDisplayName(BLOOD_NAME + i);
            is.setItemMeta(meta);
            Item item = e.getEntity().getWorld().dropItemNaturally(e.getEntity().getLocation(), is);
            item.setPickupDelay(Integer.MAX_VALUE);
            item.setVelocity(new Vector(this.random.nextDouble() * 0.1, 0.4, this.random.nextDouble() * 0.1));
            this.bloodItems.put(item, System.currentTimeMillis());
        }
    }

    private boolean showBlood(Entity entity, EntityDamageEvent.DamageCause damageCause, double damage) {
        return ConfigUtil.isShowIndicator(entity, damageCause, damage, DISABLED_BLOOD, this.enabled, this.enablePlayer, this.sneaking, this.enableMonster, this.enableAnimal, this.disabledEntities, this.disabledDamageCauses);
    }

    private void checkBloodItem(Item item, Cancellable cancellable) {
        ItemMeta itemMeta;
        if (this.bloodItems.containsKey(item)) {
            cancellable.setCancelled(true);
            return;
        }
        ItemStack itemStack = item.getItemStack();
        if (item.getPickupDelay() == Integer.MAX_VALUE && itemStack.hasItemMeta() && (itemMeta = itemStack.getItemMeta()).hasDisplayName() && itemMeta.getDisplayName().equals(BLOOD_NAME)) {
            item.remove();
        }
    }

    public Map<Item, Long> getBloodItems() {
        return this.bloodItems;
    }
}

