/*
 * Decompiled with CFR 0.152.
 */
package cl.mastercode.DamageIndicator.command;

import cl.mastercode.DamageIndicator.DIMain;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class CommandHandler
implements CommandExecutor {
    private final DIMain plugin;

    public CommandHandler(DIMain plugin) {
        this.plugin = plugin;
    }

    private boolean isPlayer(CommandSender sender) {
        if (sender instanceof Player) {
            return true;
        }
        sender.sendMessage(ChatColor.RED + "Only a Player can use this command");
        return false;
    }

    private boolean checkPermissions(CommandSender sender, String permission) {
        if (sender.hasPermission(permission)) {
            return true;
        }
        sender.sendMessage(ChatColor.RED + "You don't have permission to use this command this!");
        return false;
    }

    private boolean checkArguments(CommandSender sender, int args, int num) {
        if (args != num) {
            sender.sendMessage(ChatColor.RED + "Invalid number of arguments");
            return false;
        }
        return true;
    }

    private int getInt(CommandSender sender, String text) {
        try {
            int amount = Integer.parseInt(text);
            return amount;
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED + "Invalid given amount");
            return -1;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String string, String[] strings) {
        this.onCommand(sender, strings);
        return true;
    }

    private void onCommand(CommandSender sender, String[] strings) {
        if (strings.length >= 1) {
            switch (strings[0]) {
                case "reload": {
                    if (!this.checkPermissions(sender, "damageindicator.admin")) break;
                    this.plugin.reload();
                    sender.sendMessage(ChatColor.GREEN + "Reloaded config!");
                    break;
                }
                case "clear": {
                    int range;
                    if (!this.isPlayer(sender) || !this.checkPermissions(sender, "damageindicator.clear") && !this.checkPermissions(sender, "damageindicator.admin") || !this.checkArguments(sender, strings.length, 2) || (range = this.getInt(sender, strings[1])) < 0) break;
                    int c = 0;
                    c = ((Player)sender).getNearbyEntities((double)range, (double)range, (double)range).stream().filter(entity -> entity instanceof ArmorStand && this.plugin.isDamageIndicator((Entity)entity, false)).peek(Entity::remove).map(_i -> 1).reduce(c, Integer::sum);
                    sender.sendMessage(ChatColor.GREEN + c + " Damage Indicators were removed");
                    break;
                }
                case "clearall": {
                    if (!this.isPlayer(sender) || !this.checkPermissions(sender, "damageindicator.admin")) break;
                    int c = 0;
                    c = ((Player)sender).getLocation().getWorld().getEntitiesByClass(ArmorStand.class).stream().filter(this.plugin::isDamageIndicator).peek(Entity::remove).map(_i -> 1).reduce(c, Integer::sum);
                    sender.sendMessage(ChatColor.GREEN + c + " Damage Indicators were removed in " + ((Player)sender).getLocation().getWorld().getName());
                    break;
                }
                case "toggle": {
                    if (this.isPlayer(sender)) {
                        boolean status = !this.plugin.getStorageProvider().showArmorStand((Player)sender);
                        this.plugin.getStorageProvider().setShowArmorStand((Player)sender, status);
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(status ? this.plugin.getConfig().getString("Messages.Damage Indicator.Enabled", "") : this.plugin.getConfig().getString("Messages.Damage Indicator.Disabled", ""))));
                        break;
                    }
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cThis command can't be executed from console."));
                }
            }
            return;
        }
        sender.sendMessage(ChatColor.DARK_AQUA + "<===== Damage Indicator " + Bukkit.getServer().getPluginManager().getPlugin("DamageIndicator").getDescription().getVersion() + " =====>");
        sender.sendMessage(ChatColor.DARK_AQUA + "/di reload");
        sender.sendMessage(ChatColor.DARK_AQUA + "/di clear <range> " + ChatColor.AQUA + "#remove the damage indicators in the range");
        sender.sendMessage(ChatColor.DARK_AQUA + "/di clearall " + ChatColor.AQUA + "#remove the damage indicators in the world (may cause lag)");
        sender.sendMessage(ChatColor.DARK_AQUA + "/di toggle " + ChatColor.AQUA + "#enable/disable damage indicators for you");
    }
}

