/*
 * Decompiled with CFR 0.152.
 */
package cl.mastercode.DamageIndicator;

import cl.mastercode.DamageIndicator.command.CommandHandler;
import cl.mastercode.DamageIndicator.hook.HookManager;
import cl.mastercode.DamageIndicator.listener.BloodListener;
import cl.mastercode.DamageIndicator.listener.DamageIndicatorListener;
import cl.mastercode.DamageIndicator.storage.SimpleStorageProvider;
import cl.mastercode.DamageIndicator.storage.StorageProvider;
import cl.mastercode.DamageIndicator.util.CompatUtil;
import cl.mastercode.DamageIndicator.util.ConfigUpdateHandler;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DIMain
extends JavaPlugin {
    private DamageIndicatorListener damageIndicatorListener;
    private BloodListener bloodListener;
    private StorageProvider storageProvider = null;

    public void reload() {
        new ConfigUpdateHandler(this).updateConfig();
        this.reloadConfig();
        if (this.storageProvider == null) {
            this.storageProvider = new SimpleStorageProvider();
        }
        if (this.damageIndicatorListener != null) {
            this.damageIndicatorListener.getArmorStands().forEach((armor, time) -> armor.remove());
            this.damageIndicatorListener.getArmorStands().clear();
            this.damageIndicatorListener.reload();
        } else if (this.getConfig().getBoolean("Damage Indicator.Enabled")) {
            this.damageIndicatorListener = new DamageIndicatorListener(this, new HookManager(this));
            Bukkit.getPluginManager().registerEvents((Listener)this.damageIndicatorListener, (Plugin)this);
        }
        if (this.bloodListener != null) {
            this.bloodListener.getBloodItems().forEach((item, time) -> item.remove());
            this.bloodListener.getBloodItems().clear();
            this.bloodListener.reload();
        } else if (this.getConfig().getBoolean("Blood.Enabled")) {
            this.bloodListener = new BloodListener(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.bloodListener, (Plugin)this);
        }
    }

    public void onEnable() {
        this.reload();
        this.getCommand("damageindicator").setExecutor((CommandExecutor)new CommandHandler(this));
        this.startTasks();
        CompatUtil.onEnable();
    }

    public void onDisable() {
        if (this.damageIndicatorListener != null) {
            this.damageIndicatorListener.getArmorStands().forEach((armor, time) -> armor.remove());
        }
        if (this.bloodListener != null) {
            this.bloodListener.getBloodItems().forEach((item, time) -> item.remove());
        }
    }

    private void startTasks() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            Map.Entry<ArmorStand, Long> ent;
            if (this.damageIndicatorListener != null) {
                Iterator<Map.Entry<ArmorStand, Long>> asit = this.damageIndicatorListener.getArmorStands().entrySet().iterator();
                while (asit.hasNext()) {
                    ent = asit.next();
                    if (ent.getValue() + 1500L <= System.currentTimeMillis()) {
                        ent.getKey().remove();
                        asit.remove();
                        continue;
                    }
                    ent.getKey().teleport(ent.getKey().getLocation().clone().add(0.0, 0.07, 0.0));
                }
            }
            if (this.bloodListener != null) {
                Iterator<Map.Entry<Item, Long>> bit = this.bloodListener.getBloodItems().entrySet().iterator();
                while (bit.hasNext()) {
                    ent = bit.next();
                    if (ent.getValue() + 2000L > System.currentTimeMillis()) continue;
                    ((Item)ent.getKey()).remove();
                    bit.remove();
                }
            }
        }, 0L, 1L);
    }

    public boolean isDamageIndicator(Entity entity) {
        return this.isDamageIndicator(entity, true);
    }

    public boolean isDamageIndicator(Entity entity, boolean strict) {
        if (!(entity instanceof ArmorStand)) {
            return false;
        }
        ArmorStand as = (ArmorStand)entity;
        return as.hasMetadata("Mastercode-DamageIndicator") || !strict && as.isMarker() && !as.isVisible() && as.isCustomNameVisible() && !as.hasGravity();
    }

    public StorageProvider getStorageProvider() {
        return this.storageProvider;
    }

    public void setStorageProvider(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }
}

