/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.GPFlagsConfig;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static boolean isRunningMinecraft(int major, int minor) {
        return Util.isRunningMinecraft(major, minor, 0);
    }

    public static boolean isRunningMinecraft(int major, int minor, int revision) {
        int rev;
        String[] version = Util.getMinecraftVersion().split("\\.");
        int maj = Integer.parseInt(version[0]);
        int min = Integer.parseInt(version[1]);
        try {
            rev = Integer.parseInt(version[2]);
        }
        catch (Exception ignore) {
            rev = 0;
        }
        return maj > major || min > minor || min == minor && rev >= revision;
    }

    public static String getMinecraftVersion() {
        return Bukkit.getBukkitVersion().split("-")[0];
    }

    private static String getPrefix() {
        return Util.getColString(GPFlags.getInstance().getFlagsDataStore().getMessage(Messages.Prefix, new String[0]));
    }

    public static void disableFlight(Player player) {
        if (player.isFlying() && !Util.canFly(player)) {
            Location loc = player.getLocation();
            Block block = loc.getBlock();
            while (block.getY() > 2 && !block.getType().isSolid() && block.getType() != Material.WATER) {
                block = block.getRelative(BlockFace.DOWN);
            }
            player.setAllowFlight(false);
            if (loc.getY() - (double)block.getY() >= 4.0) {
                GPFlags.getInstance().getPlayerListener().addFallingPlayer(player);
            }
            Util.sendMessage((CommandSender)player, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
        }
        if (player.getAllowFlight() && !Util.canFly(player)) {
            player.setAllowFlight(false);
            Util.sendMessage((CommandSender)player, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
        }
    }

    public static boolean canFly(Player player) {
        GameMode mode = player.getGameMode();
        return mode == GameMode.SPECTATOR || mode == GameMode.CREATIVE || player.hasPermission("gpflags.bypass.fly");
    }

    public static ItemStack getItemFromVehicle(Vehicle vehicle) {
        Material material = null;
        if (vehicle instanceof Boat) {
            switch (((Boat)vehicle).getWoodType()) {
                case BIRCH: {
                    material = Material.BIRCH_BOAT;
                    break;
                }
                case ACACIA: {
                    material = Material.ACACIA_BOAT;
                    break;
                }
                case JUNGLE: {
                    material = Material.JUNGLE_BOAT;
                    break;
                }
                case REDWOOD: {
                    material = Material.SPRUCE_BOAT;
                    break;
                }
                case DARK_OAK: {
                    material = Material.DARK_OAK_BOAT;
                    break;
                }
                default: {
                    material = Material.OAK_BOAT;
                    break;
                }
            }
        } else if (vehicle instanceof RideableMinecart) {
            material = Material.MINECART;
        } else if (vehicle instanceof StorageMinecart) {
            material = Material.CHEST_MINECART;
        } else if (vehicle instanceof CommandMinecart) {
            material = Material.COMMAND_BLOCK_MINECART;
        } else if (vehicle instanceof ExplosiveMinecart) {
            material = Material.TNT_MINECART;
        } else if (vehicle instanceof HopperMinecart) {
            material = Material.HOPPER_MINECART;
        } else if (vehicle instanceof PoweredMinecart) {
            material = Material.FURNACE_MINECART;
        }
        if (material != null) {
            return new ItemStack(material);
        }
        return null;
    }

    public static boolean isAVehicle(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case MINECART: 
            case CHEST_MINECART: 
            case COMMAND_BLOCK_MINECART: 
            case FURNACE_MINECART: 
            case HOPPER_MINECART: 
            case TNT_MINECART: 
            case BIRCH_BOAT: 
            case ACACIA_BOAT: 
            case DARK_OAK_BOAT: 
            case JUNGLE_BOAT: 
            case OAK_BOAT: 
            case SPRUCE_BOAT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMonster(Entity entity) {
        EntityType type = entity.getType();
        return entity instanceof Monster || type == EntityType.GHAST || type == EntityType.MAGMA_CUBE || type == EntityType.SHULKER || type == EntityType.PHANTOM || type == EntityType.SLIME || type == EntityType.HOGLIN;
    }

    public static String getColString(String string) {
        if (Util.isRunningMinecraft(1, 16)) {
            string = string.replace('\u00a7', '&');
            Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
            Matcher matcher = hexPattern.matcher(string);
            while (matcher.find()) {
                String before = string.substring(0, matcher.start());
                String after = string.substring(matcher.end());
                ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1));
                string = before + hexColor + after;
                matcher = hexPattern.matcher(string);
            }
            Pattern hexPattern2 = Pattern.compile("<#([A-Fa-f0-9]){6}>");
            matcher = hexPattern2.matcher(string);
            while (matcher.find()) {
                ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1, matcher.group().length() - 1));
                String before = string.substring(0, matcher.start());
                String after = string.substring(matcher.end());
                string = before + hexColor + after;
                matcher = hexPattern2.matcher(string);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void sendMessage(@Nullable CommandSender player, org.bukkit.ChatColor color, MessageSpecifier specifier) {
        Util.sendMessage(player, color, specifier.getMessageID(), specifier.getMessageParams());
    }

    public static void sendMessage(@Nullable CommandSender player, org.bukkit.ChatColor color, Messages messageID, String ... args) {
        String message = GPFlags.getInstance().getFlagsDataStore().getMessage(messageID, args);
        Util.sendMessage((CommandSender)(player != null ? player : Bukkit.getConsoleSender()), color + message);
    }

    public static void sendMessage(@Nullable CommandSender player, org.bukkit.ChatColor color, String message) {
        Util.sendMessage(player, color + message);
    }

    public static void sendMessage(@Nullable CommandSender receiver, String format, Object ... objects) {
        Util.sendMessage(receiver, String.format(format, objects));
    }

    public static void sendMessage(@Nullable CommandSender receiver, String message) {
        if (receiver != null) {
            receiver.sendMessage(Util.getColString(Util.getPrefix() + message));
        } else {
            Util.log(message);
        }
    }

    public static void sendClaimMessage(@Nullable CommandSender player, org.bukkit.ChatColor color, MessageSpecifier specifier) {
        Util.sendClaimMessage(player, color, specifier.getMessageID(), specifier.getMessageParams());
    }

    public static void sendClaimMessage(@Nullable CommandSender player, org.bukkit.ChatColor color, Messages messageID, String ... args) {
        String message = GPFlags.getInstance().getFlagsDataStore().getMessage(messageID, args);
        Util.sendClaimMessage(player, color, message);
    }

    public static void sendClaimMessage(@Nullable CommandSender player, org.bukkit.ChatColor color, String message) {
        Util.sendClaimMessage(player, color + message);
    }

    public static void sendClaimMessage(@Nullable CommandSender receiver, String format, Object ... args) {
        Util.sendClaimMessage(receiver, String.format(format, args));
    }

    public static void sendClaimMessage(@Nullable CommandSender receiver, String message) {
        if (receiver != null) {
            receiver.sendMessage(Util.getColString(message));
        } else {
            Util.log(Util.getColString(message));
        }
    }

    public static void log(String message) {
        Bukkit.getConsoleSender().sendMessage(Util.getColString(Util.getPrefix() + message));
    }

    public static void log(String format, Object ... objects) {
        Util.log(String.format(format, objects));
    }

    public static void logFlagCommands(String log) {
        if (GPFlagsConfig.LOG_ENTER_EXIT_COMMANDS) {
            Util.log(log);
        }
    }

    public static boolean canBuild(Claim claim, Player player) {
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.ignoreClaims) {
            return true;
        }
        try {
            return claim.checkPermission(player, ClaimPermission.Build, null) == null;
        }
        catch (NoSuchFieldError | NoSuchMethodError e) {
            return claim.allowBuild(player, Material.STONE) == null;
        }
    }

    public static boolean canInventory(Claim claim, Player player) {
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.ignoreClaims) {
            return true;
        }
        try {
            return claim.checkPermission(player, ClaimPermission.Inventory, null) == null;
        }
        catch (NoSuchFieldError | NoSuchMethodError e) {
            return claim.allowContainers(player) == null;
        }
    }

    public static boolean canManage(Claim claim, Player player) {
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.ignoreClaims) {
            return true;
        }
        try {
            return claim.checkPermission(player, ClaimPermission.Manage, null) == null;
        }
        catch (NoSuchFieldError | NoSuchMethodError e) {
            return claim.allowGrantPermission(player) == null;
        }
    }

    public static boolean canAccess(Claim claim, Player player) {
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.ignoreClaims) {
            return true;
        }
        try {
            return claim.checkPermission(player, ClaimPermission.Access, null) == null;
        }
        catch (NoSuchMethodError e) {
            return claim.allowAccess(player) == null;
        }
    }

    public static MessageSpecifier getFlagDefsMessage(Permissible player) {
        StringBuilder flagDefsList = new StringBuilder();
        Collection<FlagDefinition> defs = GPFlags.getInstance().getFlagManager().getFlagDefinitions();
        flagDefsList.append("&b");
        for (FlagDefinition def : defs) {
            if (!player.hasPermission("gpflags.flag." + def.getName())) continue;
            flagDefsList.append(def.getName()).append("&7,&b ");
        }
        String def = flagDefsList.toString();
        if (def.length() > 5) {
            def = def.substring(0, def.length() - 4);
        }
        return new MessageSpecifier(Messages.InvalidFlagDefName, def);
    }

    public static List<String> flagTab(CommandSender sender, String arg) {
        ArrayList flags = new ArrayList();
        GPFlags.getInstance().getFlagManager().getFlagDefinitions().forEach(flagDefinition -> {
            if (sender.hasPermission("gpflags.flag." + flagDefinition.getName())) {
                flags.add(flagDefinition.getName());
            }
        });
        return (List)StringUtil.copyPartialMatches((String)arg, flags, new ArrayList());
    }

    public static List<String> paramTab(CommandSender sender, String[] args) {
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "noenterplayer": 
            case "commandblacklist": 
            case "commandwhitelist": 
            case "entercommand": 
            case "entercommand_members": 
            case "entercommand_owner": 
            case "exitcommand": 
            case "exitcommand_members": 
            case "exitcommand_owner": 
            case "entermessage": 
            case "exitmessage": {
                ArrayList<String> params = new ArrayList<String>();
                if (!(sender instanceof Player)) {
                    return null;
                }
                Player p = (Player)sender;
                FlagDefinition flagD = GPFlags.getInstance().getFlagManager().getFlagDefinitionByName("noenterplayer");
                Flag flag = flagD.getFlagInstanceAtLocation(p.getLocation(), p);
                if (flag == null) {
                    return null;
                }
                String flagParams = flag.parameters;
                if (flagParams != null) {
                    params.add(flagParams);
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], params, new ArrayList());
            }
            case "nomobspawnstype": {
                ArrayList<String> entityTypes = new ArrayList<String>();
                for (EntityType entityType : EntityType.values()) {
                    String type = entityType.toString();
                    if (!sender.hasPermission("gpflags.flag.nomobspawnstype." + type)) continue;
                    String arg = args[1];
                    if (arg.contains(";")) {
                        if (arg.charAt(arg.length() - 1) != ';') {
                            arg = arg.substring(0, arg.lastIndexOf(59) + 1);
                        }
                        entityTypes.add(arg + type);
                        continue;
                    }
                    entityTypes.add(type);
                }
                return (List)StringUtil.copyPartialMatches((String)args[1], entityTypes, new ArrayList());
            }
            case "changebiome": {
                ArrayList<String> biomes = new ArrayList<String>();
                for (Biome biome : Biome.values()) {
                    if (!sender.hasPermission("gpflags.flag.changebiome." + biome)) continue;
                    biomes.add(biome.toString());
                }
                biomes.sort(String.CASE_INSENSITIVE_ORDER);
                return (List)StringUtil.copyPartialMatches((String)args[1], biomes, new ArrayList());
            }
            case "noopendoors": {
                if (args.length != 2) {
                    return null;
                }
                List<String> doorType = Arrays.asList("doors", "trapdoors", "gates");
                return (List)StringUtil.copyPartialMatches((String)args[1], doorType, new ArrayList());
            }
        }
        return Collections.emptyList();
    }

    public static Location getInBoundsLocation(Player p) {
        Location loc = p.getLocation();
        World world = loc.getWorld();
        if (loc.getBlockY() >= world.getMaxHeight()) {
            loc.setY((double)(world.getMaxHeight() - 1));
        }
        return loc;
    }

    public static boolean isClaimOwner(Claim c, Player p) {
        if (c == null) {
            return false;
        }
        if (c.getOwnerID() == null) {
            return false;
        }
        return c.getOwnerID().equals(p.getUniqueId());
    }

    public static boolean shouldBypass(Player p, Claim c, String basePerm) {
        if (p.hasPermission(basePerm)) {
            return true;
        }
        if (c == null) {
            return p.hasPermission(basePerm + ".nonclaim");
        }
        if (c.getOwnerID() == null && p.hasPermission(basePerm + ".adminclaim")) {
            return true;
        }
        if (Util.isClaimOwner(c, p) && p.hasPermission(basePerm + ".ownclaim")) {
            return true;
        }
        if (Util.isManageTrusted(p, c) && p.hasPermission(basePerm + ".manage")) {
            return true;
        }
        if (Util.isBuildTrusted(p, c) && (p.hasPermission(basePerm + ".build") || p.hasPermission(basePerm + ".edit"))) {
            return true;
        }
        if (Util.isContainerTrusted(p, c) && p.hasPermission(basePerm + ".inventory")) {
            return true;
        }
        return Util.isAccessTrusted(p, c) && p.hasPermission(basePerm + ".access");
    }

    public static boolean shouldBypass(Player p, Claim c, Flag f) {
        String basePerm = "gpflags.bypass." + f.getFlagDefinition().getName();
        return Util.shouldBypass(p, c, basePerm);
    }

    public static boolean isManageTrusted(Player p, @NotNull Claim c) {
        return Util.canManage(c, p);
    }

    public static boolean isBuildTrusted(Player p, @NotNull Claim c) {
        return Util.canBuild(c, p);
    }

    public static boolean isContainerTrusted(Player p, @NotNull Claim c) {
        return Util.canInventory(c, p);
    }

    public static boolean isAccessTrusted(Player p, @NotNull Claim c) {
        return Util.canAccess(c, p);
    }

    public static boolean canManageFlags(Player player, Claim claim) {
        try {
            return claim.checkPermission(player, ClaimPermission.Edit, null) == null;
        }
        catch (NoSuchFieldError e) {
            return claim.allowEdit(player) == null;
        }
    }

    public static HashSet<Player> getPlayersIn(Claim claim) {
        HashSet<Player> players = new HashSet<Player>();
        World world = claim.getGreaterBoundaryCorner().getWorld();
        for (Player p : world.getPlayers()) {
            if (!claim.contains(p.getLocation(), false, false)) continue;
            players.add(p);
        }
        return players;
    }
}

