/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class TimedPlayerFlagDefinition
extends FlagDefinition
implements Listener,
Runnable {
    private static long tickOffset = 0L;
    private ConcurrentLinkedQueue<ConcurrentLinkedQueue<Player>> playerQueueQueue = new ConcurrentLinkedQueue();
    private long taskIntervalTicks;
    private boolean isSetup = false;

    public TimedPlayerFlagDefinition(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    public abstract long getPlayerCheckFrequency_Ticks();

    public abstract void processPlayer(Player var1);

    @Override
    public void firstTimeSetup() {
        super.firstTimeSetup();
        if (this.isSetup) {
            return;
        }
        this.taskIntervalTicks = this.getPlayerCheckFrequency_Ticks() / (long)Bukkit.getServer().getMaxPlayers();
        if (this.taskIntervalTicks < 1L) {
            this.taskIntervalTicks = 1L;
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, tickOffset++, Math.max(this.taskIntervalTicks, 1L));
        this.isSetup = true;
    }

    @Override
    public void run() {
        Player player;
        ConcurrentLinkedQueue<Player> playerQueue = this.playerQueueQueue.poll();
        if (playerQueue == null) {
            long iterationsToProcessAllPlayers = this.getPlayerCheckFrequency_Ticks() / this.taskIntervalTicks;
            if (iterationsToProcessAllPlayers < 1L) {
                iterationsToProcessAllPlayers = 1L;
            }
            int i = 0;
            while ((long)i < iterationsToProcessAllPlayers) {
                this.playerQueueQueue.add(new ConcurrentLinkedQueue());
                ++i;
            }
            Collection players = Bukkit.getServer().getOnlinePlayers();
            for (Player player2 : players) {
                ConcurrentLinkedQueue<Player> queueToFill = this.playerQueueQueue.poll();
                queueToFill.add(player2);
                this.playerQueueQueue.add(queueToFill);
            }
            playerQueue = this.playerQueueQueue.poll();
        }
        while ((player = playerQueue.poll()) != null) {
            try {
                this.processPlayer(player);
            }
            catch (Exception e) {
                if (!player.isOnline()) continue;
                e.printStackTrace();
            }
        }
    }
}

