/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.event.PlayerPostClaimBorderEvent;
import me.ryanhamshire.GPFlags.event.PlayerPreClaimBorderEvent;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public abstract class PlayerMovementFlagDefinition
extends FlagDefinition {
    public PlayerMovementFlagDefinition(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    public boolean allowMovement(Player player, Location from, Location to, Claim claimFrom, Claim claimTo) {
        return true;
    }

    @EventHandler
    public void onMove(PlayerPreClaimBorderEvent event) {
        Claim claimTo;
        Claim claimFrom;
        Player player = event.getPlayer();
        Location from = event.getLocFrom().clone();
        int fromMaxHeight = from.getWorld().getMaxHeight();
        if (from.getY() > (double)fromMaxHeight) {
            from.setY((double)fromMaxHeight);
        }
        int fromMinHeight = from.getWorld().getMinHeight();
        if (from.getY() < (double)fromMinHeight) {
            from.setY((double)fromMinHeight);
        }
        Location to = event.getLocTo().clone();
        int toMaxHeight = to.getWorld().getMaxHeight();
        if (to.getY() > (double)toMaxHeight) {
            to.setY((double)toMaxHeight);
        }
        int toMinHeight = to.getWorld().getMinHeight();
        if (to.getY() < (double)toMinHeight) {
            to.setY((double)toMaxHeight);
        }
        if (!this.allowMovement(player, from, to, claimFrom = event.getClaimFrom(), claimTo = event.getClaimTo())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPostMove(PlayerPostClaimBorderEvent event) {
        this.onChangeClaim(event.getPlayer(), event.getLocFrom(), event.getLocTo(), event.getClaimFrom(), event.getClaimTo());
    }

    public void onChangeClaim(Player player, Location from, Location to, Claim claimFrom, Claim claimTo) {
    }

    public void undoMovement(Player player, Location lastLocation) {
        Bukkit.broadcastMessage((String)"Undoing movement");
        if (lastLocation != null) {
            player.teleport(lastLocation);
        } else if (player.getBedSpawnLocation() != null) {
            player.teleport(player.getBedSpawnLocation());
        } else {
            player.teleport(player.getWorld().getSpawnLocation());
        }
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Collections.singletonList(FlagDefinition.FlagType.CLAIM);
    }
}

