/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.WorldSettingsManager;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlagDefinition
implements Listener {
    private final FlagManager flagManager;
    WorldSettingsManager settingsManager;
    private int instances = 0;
    protected GPFlags plugin;
    private boolean hasRegisteredEvents = false;

    public FlagDefinition(FlagManager manager, GPFlags plugin) {
        this.flagManager = manager;
        this.plugin = plugin;
        this.settingsManager = plugin.getWorldSettingsManager();
    }

    public abstract String getName();

    public SetFlagResult validateParameters(String parameters) {
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    public abstract MessageSpecifier getSetMessage(String var1);

    public abstract MessageSpecifier getUnSetMessage();

    public abstract List<FlagType> getFlagType();

    public void onFlagSet(Claim claim, String params) {
    }

    public void onFlagUnset(Claim claim) {
    }

    public Flag getFlagInstanceAtLocation(@NotNull Location location, @Nullable Player player) {
        Flag flag = null;
        if (GriefPrevention.instance.claimsEnabledForWorld(location.getWorld())) {
            Claim claim;
            Claim cachedClaim = null;
            PlayerData playerData = null;
            if (player != null) {
                playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
                cachedClaim = playerData.lastClaim;
            }
            if ((claim = GriefPrevention.instance.dataStore.getClaimAt(location, false, cachedClaim)) != null) {
                if (playerData != null) {
                    playerData.lastClaim = claim;
                }
                if ((flag = this.flagManager.getFlag(claim.getID().toString(), this)) != null && !flag.getSet()) {
                    return null;
                }
                if (flag == null && claim.parent != null && (flag = this.flagManager.getFlag(claim.parent.getID().toString(), this)) != null && !flag.getSet()) {
                    return null;
                }
            }
        }
        if (flag == null && (flag = this.flagManager.getFlag(location.getWorld().getName(), this)) != null && !flag.getSet()) {
            return null;
        }
        if (flag == null && (flag = this.flagManager.getFlag("everywhere", this)) != null && !flag.getSet()) {
            return null;
        }
        return flag;
    }

    public void incrementInstances() {
        if (++this.instances == 1) {
            this.firstTimeSetup();
        }
    }

    public void firstTimeSetup() {
        if (this.hasRegisteredEvents) {
            return;
        }
        this.hasRegisteredEvents = true;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void updateSettings(WorldSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public static enum FlagType {
        CLAIM("&aCLAIM"),
        WORLD("&6WORLD"),
        SERVER("&3SERVER");

        String name;

        private FlagType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)(this.name + "&7"));
        }
    }
}

