/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Arrays;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GriefPrevention.events.SaveTrappedPlayerEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventHandler;

public class FlagDef_TrappedDestination
extends FlagDefinition {
    public FlagDef_TrappedDestination(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @EventHandler
    public void onPlayerDeath(SaveTrappedPlayerEvent event) {
        Flag flag = this.getFlagInstanceAtLocation(event.getClaim().getLesserBoundaryCorner(), null);
        if (flag == null) {
            return;
        }
        String[] params = flag.getParametersArray();
        World world = Bukkit.getServer().getWorld(params[0]);
        Location location = new Location(world, (double)Integer.valueOf(params[1]).intValue(), (double)Integer.valueOf(params[2]).intValue(), (double)Integer.valueOf(params[3]).intValue());
        event.setDestination(location);
    }

    @Override
    public String getName() {
        return "TrappedDestination";
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        String[] params = parameters.split(" ");
        if (params.length != 4) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.LocationRequired, new String[0]));
        }
        World world = Bukkit.getWorld((String)params[0]);
        if (world == null) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.WorldNotFound, new String[0]));
        }
        try {
            Integer.valueOf(params[1]);
            Integer.valueOf(params[2]);
            Integer.valueOf(params[3]);
        }
        catch (NumberFormatException e) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.LocationRequired, new String[0]));
        }
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.EnableTrappedDestination, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.DisableTrappedDestination, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Arrays.asList(FlagDefinition.FlagType.CLAIM, FlagDefinition.FlagType.WORLD, FlagDefinition.FlagType.SERVER);
    }
}

