/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.events.PreventBlockBreakEvent;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class FlagDef_SpleefArena
extends FlagDefinition {
    public FlagDef_SpleefArena(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Location location = player.getLocation();
        Flag flag = this.getFlagInstanceAtLocation(location, player);
        if (flag == null) {
            return;
        }
        SpleefData data = new SpleefData(flag.getParametersArray());
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(location, false, playerData.lastClaim);
        if (claim == null) {
            return;
        }
        ArrayList chunks = claim.getChunks();
        for (Chunk chunk : chunks) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < location.getWorld().getMaxHeight() - data.differenceY; ++y) {
                        Block block;
                        if (!claim.contains(Util.getInBoundsLocation(player), false, false) || !data.IsSupport(block = chunk.getBlock(x, y, z))) continue;
                        chunk.getBlock(x, y + data.differenceY, z).setType(data.blockMat);
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPreventBlockBreak(PreventBlockBreakEvent event) {
        Block block = event.getInnerEvent().getBlock();
        Location location = block.getLocation();
        Flag flag = this.getFlagInstanceAtLocation(location, null);
        if (flag == null) {
            return;
        }
        SpleefData data = new SpleefData(flag.getParametersArray());
        if (data.IsBlock(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Block block = e.getBlock();
        Location location = block.getLocation();
        Flag flag = this.getFlagInstanceAtLocation(location, null);
        if (flag == null) {
            return;
        }
        SpleefData data = new SpleefData(flag.getParametersArray());
        if (data.IsBlock(block)) {
            e.setDropItems(false);
        }
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        String[] params = parameters.split(" ");
        if (params.length != 3) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.SpleefArenaHelp, new String[0]));
        }
        try {
            String supportMaterialName;
            String blockMaterialName;
            String[] params_2;
            if (params[0].contains(":")) {
                params_2 = params[0].split(":");
                if (!params_2[0].startsWith("minecraft")) {
                    throw new IllegalArgumentException("Only supports Minecraft blocks");
                }
                blockMaterialName = params_2[1].toUpperCase();
            } else {
                blockMaterialName = params[0].toUpperCase();
            }
            if (params[1].contains(":")) {
                params_2 = params[1].split(":");
                if (!params_2[0].startsWith("minecraft")) {
                    throw new IllegalArgumentException("Only supports Minecraft blocks");
                }
                supportMaterialName = params_2[1].toUpperCase();
            } else {
                supportMaterialName = params[1].toUpperCase();
            }
            if (!this.isValidMaterial(blockMaterialName)) {
                throw new IllegalArgumentException("Such Material is not found");
            }
            if (!this.isValidMaterial(supportMaterialName)) {
                throw new IllegalArgumentException("Such Material is not found");
            }
        }
        catch (IllegalArgumentException e) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.SpleefArenaHelp, new String[0]));
        }
        try {
            Integer.valueOf(params[2]);
        }
        catch (NumberFormatException e) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.SpleefArenaHelp, new String[0]));
        }
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    boolean isValidMaterial(String materialName) {
        return Material.getMaterial((String)materialName) != null && Material.getMaterial((String)materialName).isBlock();
    }

    @Override
    public String getName() {
        return "SpleefArena";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.SetSpleefArena, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.UnSetSpleefArena, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Collections.singletonList(FlagDefinition.FlagType.CLAIM);
    }

    private class SpleefData {
        Material supportMat = null;
        Material blockMat = null;
        Integer differenceY = null;

        SpleefData(String[] params) {
            String[] params_2;
            if (params[0].contains(":")) {
                params_2 = params[0].split(":");
                this.blockMat = Material.getMaterial((String)params_2[1].toUpperCase());
            } else {
                this.blockMat = Material.getMaterial((String)params[0].toUpperCase());
            }
            if (params[1].contains(":")) {
                params_2 = params[1].split(":");
                this.supportMat = Material.getMaterial((String)params_2[1].toUpperCase());
            } else {
                this.supportMat = Material.getMaterial((String)params[1].toUpperCase());
            }
            this.differenceY = Integer.valueOf(params[2]);
        }

        boolean IsSupport(Block b) {
            return b.getType() == this.supportMat;
        }

        boolean IsBlock(Block b) {
            return b.getType() == this.blockMat;
        }
    }
}

