/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.Arrays;
import java.util.List;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class FlagDef_SpawnReasonWhitelist
extends FlagDefinition
implements Listener {
    public FlagDef_SpawnReasonWhitelist(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        Flag flag = this.getFlagInstanceAtLocation(event.getLocation(), null);
        if (flag == null) {
            return;
        }
        for (String string : flag.getParametersArray()) {
            CreatureSpawnEvent.SpawnReason reason;
            try {
                reason = CreatureSpawnEvent.SpawnReason.valueOf((String)string.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                Util.log("Error with SpawnReasonWhitelist params at " + event.getLocation());
                return;
            }
            if (reason == event.getSpawnReason()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        if (parameters.isEmpty()) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.SpecifySpawnReason, new String[0]));
        }
        for (String s : parameters.split(" ")) {
            try {
                CreatureSpawnEvent.SpawnReason.valueOf((String)s.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                return new SetFlagResult(false, new MessageSpecifier(Messages.NotValidSpawnReason, s));
            }
        }
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public String getName() {
        return "SpawnReasonWhitelist";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.EnabledSpawnReasonWhitelist, parameters);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.DisabledSpawnReasonWhitelist, new String[0]);
    }

    @Override
    public List<FlagDefinition.FlagType> getFlagType() {
        return Arrays.asList(FlagDefinition.FlagType.CLAIM, FlagDefinition.FlagType.WORLD, FlagDefinition.FlagType.SERVER);
    }
}

