/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.WorldSettings;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class FlagDef_PlayerGamemode
extends PlayerMovementFlagDefinition
implements Listener {
    public FlagDef_PlayerGamemode(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @Override
    public void onChangeClaim(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claimTo) {
        WorldSettings settings = this.settingsManager.get(player.getWorld());
        if (lastLocation == null) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(to, player);
        if (flag == null) {
            if (this.getFlagInstanceAtLocation(lastLocation, player) == null) {
                return;
            }
            String gameMode = settings.worldGamemodeDefault;
            player.setGameMode(GameMode.valueOf((String)gameMode.toUpperCase()));
            Util.sendMessage((CommandSender)player, TextMode.Warn, Messages.PlayerGamemode, gameMode);
            if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
                Block block = player.getLocation().getBlock();
                Block below = block.getRelative(BlockFace.DOWN);
                if (below.getRelative(BlockFace.DOWN).getType() != Material.AIR && block.getRelative(BlockFace.UP).getType() == Material.AIR) {
                    return;
                }
                while (block.getY() > 2 && !block.getType().isSolid() && block.getType() != Material.WATER) {
                    block = block.getRelative(BlockFace.DOWN);
                }
                player.teleport(block.getRelative(BlockFace.UP).getLocation());
            }
            return;
        }
        if (flag == this.getFlagInstanceAtLocation(lastLocation, player)) {
            return;
        }
        String gameMode = flag.parameters;
        String playerGameMode = player.getGameMode().toString();
        if (gameMode.equalsIgnoreCase(playerGameMode)) {
            return;
        }
        player.setGameMode(GameMode.valueOf((String)gameMode.toUpperCase()));
        Util.sendMessage((CommandSender)player, TextMode.Warn, Messages.PlayerGamemode, gameMode);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Flag flag = this.getFlagInstanceAtLocation(player.getLocation(), player);
        if (flag != null) {
            String gameMode = flag.parameters;
            player.setGameMode(GameMode.valueOf((String)gameMode.toUpperCase()));
        }
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        if (parameters.isEmpty()) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.PlayerGamemodeRequired, new String[0]));
        }
        if (!(parameters.equalsIgnoreCase("survival") || parameters.equalsIgnoreCase("creative") || parameters.equalsIgnoreCase("adventure") || parameters.equalsIgnoreCase("spectator"))) {
            return new SetFlagResult(false, new MessageSpecifier(Messages.PlayerGamemodeRequired, new String[0]));
        }
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public String getName() {
        return "PlayerGamemode";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.PlayerGamemodeSet, parameters);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.PlayerGamemodeUnSet, new String[0]);
    }
}

