/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class FlagDef_OwnerMemberFly
extends PlayerMovementFlagDefinition
implements Listener {
    public FlagDef_OwnerMemberFly(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @Override
    public void onFlagSet(Claim claim, String param) {
        for (Player p : Util.getPlayersIn(claim)) {
            this.handleFlight(p);
        }
    }

    @Override
    public void onFlagUnset(Claim claim) {
        for (Player p : Util.getPlayersIn(claim)) {
            if (Util.canFly(p)) continue;
            if (p.isFlying()) {
                Block block = p.getLocation().getBlock();
                while (block.getY() > 2 && !block.getType().isSolid() && block.getType() != Material.WATER) {
                    block = block.getRelative(BlockFace.DOWN);
                }
                if (p.getLocation().getY() - (double)block.getY() >= 4.0) {
                    GPFlags.getInstance().getPlayerListener().addFallingPlayer(p);
                }
            }
            p.setAllowFlight(false);
            Util.sendClaimMessage((CommandSender)p, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
        }
    }

    @Override
    public void onChangeClaim(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claim) {
        if (lastLocation == null) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(to, player);
        Flag ownerFly = GPFlags.getInstance().getFlagManager().getFlag(claim, "OwnerFly");
        if (Util.canFly(player)) {
            return;
        }
        if (flag == null && ownerFly == null) {
            Flag noFlight;
            if (claim != null && (noFlight = GPFlags.getInstance().getFlagManager().getFlag(claim, GPFlags.getInstance().getFlagManager().getFlagDefinitionByName("NoFlight"))) != null && !noFlight.getSet()) {
                return;
            }
            if (player.isFlying()) {
                Block block = player.getLocation().getBlock();
                while (block.getY() > 2 && !block.getType().isSolid() && block.getType() != Material.WATER) {
                    block = block.getRelative(BlockFace.DOWN);
                }
                player.setAllowFlight(false);
                if (player.getLocation().getY() - (double)block.getY() >= 4.0) {
                    GPFlags.getInstance().getPlayerListener().addFallingPlayer(player);
                }
                Util.sendClaimMessage((CommandSender)player, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
                return;
            }
            if (player.getAllowFlight()) {
                player.setAllowFlight(false);
                Util.sendClaimMessage((CommandSender)player, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
            }
            return;
        }
        if (flag == this.getFlagInstanceAtLocation(lastLocation, player)) {
            return;
        }
        if (flag == null) {
            return;
        }
        if (claim == null) {
            return;
        }
        if (Util.canAccess(claim, player)) {
            Bukkit.getScheduler().runTaskLater((Plugin)GPFlags.getInstance(), () -> {
                player.setAllowFlight(true);
                Util.sendClaimMessage((CommandSender)player, TextMode.Success, Messages.EnterFlightEnabled, new String[0]);
            }, 1L);
            return;
        }
        if (player.isFlying()) {
            GPFlags.getInstance().getPlayerListener().addFallingPlayer(player);
            player.setAllowFlight(false);
            Util.sendClaimMessage((CommandSender)player, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
        }
        if (player.getAllowFlight()) {
            player.setAllowFlight(false);
            Util.sendClaimMessage((CommandSender)player, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onJoin(PlayerJoinEvent event) {
        this.handleFlight(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.handleFlight(player), 1L);
    }

    private void handleFlight(Player player) {
        Flag flag = this.getFlagInstanceAtLocation(player.getLocation(), player);
        Material below = player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType();
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), false, null);
        if (flag == null) {
            return;
        }
        if (claim == null) {
            return;
        }
        if (!Util.canAccess(claim, player)) {
            return;
        }
        if (!player.getAllowFlight()) {
            Util.sendClaimMessage((CommandSender)player, TextMode.Success, Messages.EnterFlightEnabled, new String[0]);
        }
        player.setAllowFlight(true);
        if (below == Material.AIR) {
            player.setFlying(true);
        }
    }

    @Override
    public String getName() {
        return "OwnerMemberFly";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.OwnerMemberFlightEnabled, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.OwnerMemberFlightDisabled, new String[0]);
    }
}

