/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.UUID;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class FlagDef_OwnerFly
extends PlayerMovementFlagDefinition
implements Listener {
    public FlagDef_OwnerFly(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @Override
    public void onFlagSet(Claim claim, String param) {
        UUID uuid = claim.getOwnerID();
        Player owner = Bukkit.getPlayer((UUID)uuid);
        if (owner == null) {
            return;
        }
        if (this.canFly(owner)) {
            return;
        }
        if (claim.contains(owner.getLocation(), false, false)) {
            if (!owner.getAllowFlight()) {
                Util.sendClaimMessage((CommandSender)owner, TextMode.Success, Messages.EnterFlightEnabled, new String[0]);
            }
            owner.setAllowFlight(true);
        }
    }

    @Override
    public void onFlagUnset(Claim claim) {
        UUID uuid = claim.getOwnerID();
        Player owner = Bukkit.getPlayer((UUID)uuid);
        if (owner == null) {
            return;
        }
        if (this.canFly(owner)) {
            return;
        }
        if (claim.contains(owner.getLocation(), false, false)) {
            if (owner.isFlying()) {
                Block block = owner.getLocation().getBlock();
                while (block.getY() > 2 && !block.getType().isSolid() && block.getType() != Material.WATER) {
                    block = block.getRelative(BlockFace.DOWN);
                }
                owner.setAllowFlight(false);
                if (owner.getLocation().getY() - (double)block.getY() >= 4.0) {
                    GPFlags.getInstance().getPlayerListener().addFallingPlayer(owner);
                }
                Util.sendClaimMessage((CommandSender)owner, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
                return;
            }
            if (owner.getAllowFlight()) {
                owner.setAllowFlight(false);
                Util.sendClaimMessage((CommandSender)owner, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
            }
        }
    }

    @Override
    public void onChangeClaim(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claim) {
        if (lastLocation == null) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(to, player);
        Flag ownerMember = GPFlags.getInstance().getFlagManager().getFlag(claim, "OwnerMemberFly");
        if (flag == null && ownerMember == null) {
            Flag noFlight;
            if (claim != null && (noFlight = GPFlags.getInstance().getFlagManager().getFlag(claim, GPFlags.getInstance().getFlagManager().getFlagDefinitionByName("NoFlight"))) != null && !noFlight.getSet()) {
                return;
            }
            if (player.isFlying() && !this.canFly(player)) {
                Block block = player.getLocation().getBlock();
                while (block.getY() > 2 && !block.getType().isSolid() && block.getType() != Material.WATER) {
                    block = block.getRelative(BlockFace.DOWN);
                }
                player.setAllowFlight(false);
                if (to.getY() - (double)block.getY() >= 4.0) {
                    GPFlags.getInstance().getPlayerListener().addFallingPlayer(player);
                }
                Util.sendClaimMessage((CommandSender)player, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
                return;
            }
            if (player.getAllowFlight() && !this.canFly(player)) {
                player.setAllowFlight(false);
                Util.sendClaimMessage((CommandSender)player, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
            }
            return;
        }
        if (flag == this.getFlagInstanceAtLocation(lastLocation, player)) {
            return;
        }
        if (claim == null) {
            return;
        }
        if (!claim.getOwnerName().equalsIgnoreCase(player.getName())) {
            if (!this.canFly(player)) {
                player.setAllowFlight(false);
                Util.sendClaimMessage((CommandSender)player, TextMode.Warn, Messages.ExitFlightDisabled, new String[0]);
            }
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)GPFlags.getInstance(), () -> {
            if (!player.getAllowFlight()) {
                Util.sendClaimMessage((CommandSender)player, TextMode.Success, Messages.EnterFlightEnabled, new String[0]);
            }
            player.setAllowFlight(true);
        }, 1L);
    }

    private boolean canFly(Player player) {
        GameMode mode = player.getGameMode();
        return mode == GameMode.SPECTATOR || mode == GameMode.CREATIVE || player.hasPermission("gpflags.bypass.fly");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onJoin(PlayerJoinEvent event) {
        this.handleFlight(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.handleFlight(player), 1L);
    }

    private void handleFlight(Player player) {
        Flag flag = this.getFlagInstanceAtLocation(player.getLocation(), player);
        Material below = player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType();
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), false, null);
        if (flag != null && claim != null && claim.getOwnerName() != null && claim.getOwnerName().equalsIgnoreCase(player.getName())) {
            player.setAllowFlight(true);
            Util.sendClaimMessage((CommandSender)player, TextMode.Success, Messages.EnterFlightEnabled, new String[0]);
            if (below == Material.AIR) {
                player.setFlying(true);
            }
        }
    }

    @Override
    public String getName() {
        return "OwnerFly";
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.OwnerFlightEnabled, new String[0]);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.OwnerFlightDisabled, new String[0]);
    }
}

