/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GPFlags.flags;

import java.util.UUID;
import me.ryanhamshire.GPFlags.Flag;
import me.ryanhamshire.GPFlags.FlagManager;
import me.ryanhamshire.GPFlags.GPFlags;
import me.ryanhamshire.GPFlags.MessageSpecifier;
import me.ryanhamshire.GPFlags.Messages;
import me.ryanhamshire.GPFlags.SetFlagResult;
import me.ryanhamshire.GPFlags.TextMode;
import me.ryanhamshire.GPFlags.flags.FlagDefinition;
import me.ryanhamshire.GPFlags.flags.PlayerMovementFlagDefinition;
import me.ryanhamshire.GPFlags.util.Util;
import me.ryanhamshire.GriefPrevention.Claim;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlagDef_NotifyExit
extends PlayerMovementFlagDefinition {
    public FlagDef_NotifyExit(FlagManager manager, GPFlags plugin) {
        super(manager, plugin);
    }

    @Override
    public void onChangeClaim(Player player, Location lastLocation, Location to, Claim claimFrom, Claim claimTo) {
        if (lastLocation == null) {
            return;
        }
        Flag flag = this.getFlagInstanceAtLocation(lastLocation, player);
        if (flag == null) {
            return;
        }
        Flag flagFrom = this.plugin.getFlagManager().getFlag(claimFrom, (FlagDefinition)this);
        Flag flagToEnter = this.plugin.getFlagManager().getFlag(claimTo, this.plugin.getFlagManager().getFlagDefinitionByName("NotifyEnter"));
        if (claimFrom != null && claimTo != null) {
            if (!(claimFrom.parent != claimTo || flagFrom != null && flagFrom.getSet())) {
                return;
            }
            if (!(claimTo.parent != claimFrom || flagToEnter != null && flagToEnter.getSet())) {
                return;
            }
        }
        if (claimTo == null) {
            return;
        }
        Player owner = Bukkit.getPlayer((UUID)claimTo.getOwnerID());
        if (owner == null) {
            return;
        }
        if (owner.getName().equals(player.getName())) {
            return;
        }
        if (!owner.canSee(player)) {
            return;
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        String param = flag.parameters;
        if (param == null || param.isEmpty()) {
            param = "claim " + claimTo.getID();
        }
        Util.sendClaimMessage((CommandSender)owner, TextMode.Info, Messages.NotifyEnter, player.getName(), param);
    }

    @Override
    public String getName() {
        return "NotifyExit";
    }

    @Override
    public SetFlagResult validateParameters(String parameters) {
        return new SetFlagResult(true, this.getSetMessage(parameters));
    }

    @Override
    public MessageSpecifier getSetMessage(String parameters) {
        return new MessageSpecifier(Messages.EnableNotifyExit, parameters);
    }

    @Override
    public MessageSpecifier getUnSetMessage() {
        return new MessageSpecifier(Messages.DisableNotifyExit, new String[0]);
    }
}

